<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Валюты
 * @subpackage Structs
 */
class CurrencyProperty extends AbstractStructBase
{
    /**
     * The codeNum
     * Meta informations extracted from the WSDL
     * - documentation: Код валюты цифровой | Валюта | Код валюты по общероссийскому классификатору валют. В случае отсутствия значения кода в
     * общероссийском классификаторе валют - используется значение из Классификатора клиринговых валют.
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9a-zA-Zа-яА-Я]{1}[0-9]{2}
     * @var string
     */
    public $codeNum;
    /**
     * The codeAlpha
     * Meta informations extracted from the WSDL
     * - documentation: Код валюты буквенный | Строка длиной от 1 до 3 символов
     * - minOccurs: 0
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $codeAlpha;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование валюты | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * Constructor method for CurrencyProperty
     * @uses CurrencyProperty::setCodeNum()
     * @uses CurrencyProperty::setCodeAlpha()
     * @uses CurrencyProperty::setName()
     * @param string $codeNum
     * @param string $codeAlpha
     * @param string $name
     */
    public function __construct($codeNum = null, $codeAlpha = null, $name = null)
    {
        $this
            ->setCodeNum($codeNum)
            ->setCodeAlpha($codeAlpha)
            ->setName($name);
    }
    /**
     * Get codeNum value
     * @return string|null
     */
    public function getCodeNum()
    {
        return $this->codeNum;
    }
    /**
     * Set codeNum value
     * @param string $codeNum
     * @return \AisFssp\StructType\CurrencyProperty
     */
    public function setCodeNum($codeNum = null)
    {
        // validation for constraint: length
        if ((is_scalar($codeNum) && strlen($codeNum) !== 3) || (is_array($codeNum) && count($codeNum) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($codeNum) && !preg_match('/[0-9a-zA-Zа-яА-Я]{1}[0-9]{2}/', $codeNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-zA-Zа-яА-Я]{1}[0-9]{2}", "%s" given', var_export($codeNum, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codeNum) && !is_string($codeNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeNum)), __LINE__);
        }
        $this->codeNum = $codeNum;
        return $this;
    }
    /**
     * Get codeAlpha value
     * @return string|null
     */
    public function getCodeAlpha()
    {
        return $this->codeAlpha;
    }
    /**
     * Set codeAlpha value
     * @param string $codeAlpha
     * @return \AisFssp\StructType\CurrencyProperty
     */
    public function setCodeAlpha($codeAlpha = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codeAlpha) && strlen($codeAlpha) > 3) || (is_array($codeAlpha) && count($codeAlpha) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($codeAlpha) ? strlen($codeAlpha) : count($codeAlpha)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($codeAlpha) && strlen($codeAlpha) < 1) || (is_array($codeAlpha) && count($codeAlpha) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codeAlpha) && !is_string($codeAlpha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeAlpha)), __LINE__);
        }
        $this->codeAlpha = $codeAlpha;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \AisFssp\StructType\CurrencyProperty
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CurrencyProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
