<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrimeRegistryDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Выписка из реестра розыска подозреваемых в преступлениях
 * - type: tns:CrimeRegistryDetail
 * @subpackage Structs
 */
class CrimeRegistryDetail extends AbstractStructBase
{
    /**
     * The OSPName
     * Meta informations extracted from the WSDL
     * - documentation: Террорган | Наименование ОСП по справочнику ВКСП. | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OSPName;
    /**
     * The CrimeName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО подозреваемого | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $CrimeName;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения подозреваемого | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BirthDate;
    /**
     * The BirthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения подозреваемого | Место рождения контрагента-физического лица. | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $BirthPlace;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Место регистрации подозреваемого
     * - minOccurs: 0
     * @var \AisFssp\StructType\AddressType
     */
    public $Address;
    /**
     * The DistinguishingCharacteristics
     * Meta informations extracted from the WSDL
     * - documentation: Особые приметы и иные сведения | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $DistinguishingCharacteristics;
    /**
     * The InitiatorName
     * Meta informations extracted from the WSDL
     * - documentation: Орган, инициирующий розыск | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $InitiatorName;
    /**
     * The ContactInformation
     * Meta informations extracted from the WSDL
     * - documentation: Контактная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ContactInformation;
    /**
     * The DateDecreeInvestigation
     * Meta informations extracted from the WSDL
     * - documentation: Дата вынесения постановления о розыске | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDecreeInvestigation;
    /**
     * The InvestigationDepartment
     * Meta informations extracted from the WSDL
     * - documentation: Госорган, осуществляющий розыск | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $InvestigationDepartment;
    /**
     * The CriminalCase
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $CriminalCase;
    /**
     * The DateCriminalCase
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждение дела | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateCriminalCase;
    /**
     * The ArrestLocally
     * Meta informations extracted from the WSDL
     * - documentation: Статья УК РФ | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ArrestLocally;
    /**
     * The Pre_trialRestrictions
     * Meta informations extracted from the WSDL
     * - documentation: Мера пресечения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Pre_trialRestrictions;
    /**
     * Constructor method for CrimeRegistryDetail
     * @uses CrimeRegistryDetail::setOSPName()
     * @uses CrimeRegistryDetail::setCrimeName()
     * @uses CrimeRegistryDetail::setBirthDate()
     * @uses CrimeRegistryDetail::setBirthPlace()
     * @uses CrimeRegistryDetail::setAddress()
     * @uses CrimeRegistryDetail::setDistinguishingCharacteristics()
     * @uses CrimeRegistryDetail::setInitiatorName()
     * @uses CrimeRegistryDetail::setContactInformation()
     * @uses CrimeRegistryDetail::setDateDecreeInvestigation()
     * @uses CrimeRegistryDetail::setInvestigationDepartment()
     * @uses CrimeRegistryDetail::setCriminalCase()
     * @uses CrimeRegistryDetail::setDateCriminalCase()
     * @uses CrimeRegistryDetail::setArrestLocally()
     * @uses CrimeRegistryDetail::setPre_trialRestrictions()
     * @param string $oSPName
     * @param string $crimeName
     * @param string $birthDate
     * @param string $birthPlace
     * @param \AisFssp\StructType\AddressType $address
     * @param string $distinguishingCharacteristics
     * @param string $initiatorName
     * @param string $contactInformation
     * @param string $dateDecreeInvestigation
     * @param string $investigationDepartment
     * @param string $criminalCase
     * @param string $dateCriminalCase
     * @param string $arrestLocally
     * @param string $pre_trialRestrictions
     */
    public function __construct($oSPName = null, $crimeName = null, $birthDate = null, $birthPlace = null, \AisFssp\StructType\AddressType $address = null, $distinguishingCharacteristics = null, $initiatorName = null, $contactInformation = null, $dateDecreeInvestigation = null, $investigationDepartment = null, $criminalCase = null, $dateCriminalCase = null, $arrestLocally = null, $pre_trialRestrictions = null)
    {
        $this
            ->setOSPName($oSPName)
            ->setCrimeName($crimeName)
            ->setBirthDate($birthDate)
            ->setBirthPlace($birthPlace)
            ->setAddress($address)
            ->setDistinguishingCharacteristics($distinguishingCharacteristics)
            ->setInitiatorName($initiatorName)
            ->setContactInformation($contactInformation)
            ->setDateDecreeInvestigation($dateDecreeInvestigation)
            ->setInvestigationDepartment($investigationDepartment)
            ->setCriminalCase($criminalCase)
            ->setDateCriminalCase($dateCriminalCase)
            ->setArrestLocally($arrestLocally)
            ->setPre_trialRestrictions($pre_trialRestrictions);
    }
    /**
     * Get OSPName value
     * @return string|null
     */
    public function getOSPName()
    {
        return $this->OSPName;
    }
    /**
     * Set OSPName value
     * @param string $oSPName
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setOSPName($oSPName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oSPName) && strlen($oSPName) > 100) || (is_array($oSPName) && count($oSPName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($oSPName) ? strlen($oSPName) : count($oSPName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oSPName) && strlen($oSPName) < 1) || (is_array($oSPName) && count($oSPName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oSPName) && !is_string($oSPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oSPName)), __LINE__);
        }
        $this->OSPName = $oSPName;
        return $this;
    }
    /**
     * Get CrimeName value
     * @return string|null
     */
    public function getCrimeName()
    {
        return $this->CrimeName;
    }
    /**
     * Set CrimeName value
     * @param string $crimeName
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setCrimeName($crimeName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($crimeName) && strlen($crimeName) > 1000) || (is_array($crimeName) && count($crimeName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($crimeName) ? strlen($crimeName) : count($crimeName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($crimeName) && strlen($crimeName) < 1) || (is_array($crimeName) && count($crimeName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($crimeName) && !is_string($crimeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($crimeName)), __LINE__);
        }
        $this->CrimeName = $crimeName;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($birthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get BirthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->BirthPlace;
    }
    /**
     * Set BirthPlace value
     * @param string $birthPlace
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setBirthPlace($birthPlace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($birthPlace) && strlen($birthPlace) > 300) || (is_array($birthPlace) && count($birthPlace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($birthPlace) ? strlen($birthPlace) : count($birthPlace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($birthPlace) && strlen($birthPlace) < 1) || (is_array($birthPlace) && count($birthPlace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthPlace) && !is_string($birthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthPlace)), __LINE__);
        }
        $this->BirthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get Address value
     * @return \AisFssp\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \AisFssp\StructType\AddressType $address
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setAddress(\AisFssp\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get DistinguishingCharacteristics value
     * @return string|null
     */
    public function getDistinguishingCharacteristics()
    {
        return $this->DistinguishingCharacteristics;
    }
    /**
     * Set DistinguishingCharacteristics value
     * @param string $distinguishingCharacteristics
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setDistinguishingCharacteristics($distinguishingCharacteristics = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($distinguishingCharacteristics) && strlen($distinguishingCharacteristics) > 4000) || (is_array($distinguishingCharacteristics) && count($distinguishingCharacteristics) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($distinguishingCharacteristics) ? strlen($distinguishingCharacteristics) : count($distinguishingCharacteristics)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($distinguishingCharacteristics) && strlen($distinguishingCharacteristics) < 1) || (is_array($distinguishingCharacteristics) && count($distinguishingCharacteristics) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($distinguishingCharacteristics) && !is_string($distinguishingCharacteristics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distinguishingCharacteristics)), __LINE__);
        }
        $this->DistinguishingCharacteristics = $distinguishingCharacteristics;
        return $this;
    }
    /**
     * Get InitiatorName value
     * @return string|null
     */
    public function getInitiatorName()
    {
        return $this->InitiatorName;
    }
    /**
     * Set InitiatorName value
     * @param string $initiatorName
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setInitiatorName($initiatorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($initiatorName) && strlen($initiatorName) > 100) || (is_array($initiatorName) && count($initiatorName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($initiatorName) ? strlen($initiatorName) : count($initiatorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($initiatorName) && strlen($initiatorName) < 1) || (is_array($initiatorName) && count($initiatorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($initiatorName) && !is_string($initiatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($initiatorName)), __LINE__);
        }
        $this->InitiatorName = $initiatorName;
        return $this;
    }
    /**
     * Get ContactInformation value
     * @return string|null
     */
    public function getContactInformation()
    {
        return $this->ContactInformation;
    }
    /**
     * Set ContactInformation value
     * @param string $contactInformation
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setContactInformation($contactInformation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contactInformation) && strlen($contactInformation) > 1000) || (is_array($contactInformation) && count($contactInformation) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($contactInformation) ? strlen($contactInformation) : count($contactInformation)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($contactInformation) && strlen($contactInformation) < 1) || (is_array($contactInformation) && count($contactInformation) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactInformation) && !is_string($contactInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactInformation)), __LINE__);
        }
        $this->ContactInformation = $contactInformation;
        return $this;
    }
    /**
     * Get DateDecreeInvestigation value
     * @return string|null
     */
    public function getDateDecreeInvestigation()
    {
        return $this->DateDecreeInvestigation;
    }
    /**
     * Set DateDecreeInvestigation value
     * @param string $dateDecreeInvestigation
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setDateDecreeInvestigation($dateDecreeInvestigation = null)
    {
        // validation for constraint: maxExclusive
        if ($dateDecreeInvestigation >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateDecreeInvestigation), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateDecreeInvestigation < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateDecreeInvestigation), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDecreeInvestigation) && !is_string($dateDecreeInvestigation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDecreeInvestigation)), __LINE__);
        }
        $this->DateDecreeInvestigation = $dateDecreeInvestigation;
        return $this;
    }
    /**
     * Get InvestigationDepartment value
     * @return string|null
     */
    public function getInvestigationDepartment()
    {
        return $this->InvestigationDepartment;
    }
    /**
     * Set InvestigationDepartment value
     * @param string $investigationDepartment
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setInvestigationDepartment($investigationDepartment = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($investigationDepartment) && strlen($investigationDepartment) > 1000) || (is_array($investigationDepartment) && count($investigationDepartment) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($investigationDepartment) ? strlen($investigationDepartment) : count($investigationDepartment)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($investigationDepartment) && strlen($investigationDepartment) < 1) || (is_array($investigationDepartment) && count($investigationDepartment) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($investigationDepartment) && !is_string($investigationDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($investigationDepartment)), __LINE__);
        }
        $this->InvestigationDepartment = $investigationDepartment;
        return $this;
    }
    /**
     * Get CriminalCase value
     * @return string|null
     */
    public function getCriminalCase()
    {
        return $this->CriminalCase;
    }
    /**
     * Set CriminalCase value
     * @param string $criminalCase
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setCriminalCase($criminalCase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($criminalCase) && strlen($criminalCase) > 25) || (is_array($criminalCase) && count($criminalCase) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($criminalCase) ? strlen($criminalCase) : count($criminalCase)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($criminalCase) && strlen($criminalCase) < 1) || (is_array($criminalCase) && count($criminalCase) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($criminalCase) && !is_string($criminalCase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($criminalCase)), __LINE__);
        }
        $this->CriminalCase = $criminalCase;
        return $this;
    }
    /**
     * Get DateCriminalCase value
     * @return string|null
     */
    public function getDateCriminalCase()
    {
        return $this->DateCriminalCase;
    }
    /**
     * Set DateCriminalCase value
     * @param string $dateCriminalCase
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setDateCriminalCase($dateCriminalCase = null)
    {
        // validation for constraint: maxExclusive
        if ($dateCriminalCase >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateCriminalCase), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateCriminalCase < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateCriminalCase), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateCriminalCase) && !is_string($dateCriminalCase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateCriminalCase)), __LINE__);
        }
        $this->DateCriminalCase = $dateCriminalCase;
        return $this;
    }
    /**
     * Get ArrestLocally value
     * @return string|null
     */
    public function getArrestLocally()
    {
        return $this->ArrestLocally;
    }
    /**
     * Set ArrestLocally value
     * @param string $arrestLocally
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setArrestLocally($arrestLocally = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($arrestLocally) && strlen($arrestLocally) > 100) || (is_array($arrestLocally) && count($arrestLocally) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($arrestLocally) ? strlen($arrestLocally) : count($arrestLocally)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($arrestLocally) && strlen($arrestLocally) < 1) || (is_array($arrestLocally) && count($arrestLocally) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($arrestLocally) && !is_string($arrestLocally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrestLocally)), __LINE__);
        }
        $this->ArrestLocally = $arrestLocally;
        return $this;
    }
    /**
     * Get Pre_trialRestrictions value
     * @return string|null
     */
    public function getPre_trialRestrictions()
    {
        return $this->{'Pre-trialRestrictions'};
    }
    /**
     * Set Pre_trialRestrictions value
     * @param string $pre_trialRestrictions
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public function setPre_trialRestrictions($pre_trialRestrictions = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pre_trialRestrictions) && strlen($pre_trialRestrictions) > 1000) || (is_array($pre_trialRestrictions) && count($pre_trialRestrictions) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($pre_trialRestrictions) ? strlen($pre_trialRestrictions) : count($pre_trialRestrictions)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($pre_trialRestrictions) && strlen($pre_trialRestrictions) < 1) || (is_array($pre_trialRestrictions) && count($pre_trialRestrictions) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pre_trialRestrictions) && !is_string($pre_trialRestrictions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pre_trialRestrictions)), __LINE__);
        }
        $this->Pre_trialRestrictions = $this->{'Pre-trialRestrictions'} = $pre_trialRestrictions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CrimeRegistryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
