<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContragentDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных ContragentDatumType «Данные контрагента»
 * @subpackage Structs
 */
class ContragentDatumType extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип контрагента | Физ. лицо, юр.лицо, инд. предприниматель
     * @var string
     */
    public $type;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование контрагента | ФИО контрагента-физического лица или наименование организации | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The FIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО контрагента | Обязательно для физического лица или ИП.
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $FIO;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН контрагента | Обязательно для юридического лица | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $INN;
    /**
     * The SNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС физического лица | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $SNILS;
    /**
     * The OGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОРГН контрагента | Обязательно для юридического лица или ИП | Основной государственный регистрационный номер (ОГРН)/Основной
     * государственный регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $OGRN;
    /**
     * The KPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП | Обязательно для юридического лица | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $KPP;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения контрагента | Заполняется для физического лица при наличии данных о дате рождения. В противном случае
     * заполняется только поле «Год рождения контрагента» | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $birthDate;
    /**
     * The birthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения контрагента | Обязательно для физического лица | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $birthYear;
    /**
     * The birthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения контрагента | Место рождения контрагента-физического лица | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $birthPlace;
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Серия и номер документа (паспорта и пр.) | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $documentNumber;
    /**
     * The documentType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа, удостоверяющего личность | Код типа документа, удостоверяющего личность
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $documentType;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес контрагента
     * - minOccurs: 0
     * @var \AisFssp\StructType\AddressType
     */
    public $address;
    /**
     * The telephoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $telephoneNumber;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: Электропочта | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $email;
    /**
     * The postName
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Должность физического лица — представителя организации | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $postName;
    /**
     * Constructor method for ContragentDatumType
     * @uses ContragentDatumType::setType()
     * @uses ContragentDatumType::setName()
     * @uses ContragentDatumType::setFIO()
     * @uses ContragentDatumType::setINN()
     * @uses ContragentDatumType::setSNILS()
     * @uses ContragentDatumType::setOGRN()
     * @uses ContragentDatumType::setKPP()
     * @uses ContragentDatumType::setBirthDate()
     * @uses ContragentDatumType::setBirthYear()
     * @uses ContragentDatumType::setBirthPlace()
     * @uses ContragentDatumType::setDocumentNumber()
     * @uses ContragentDatumType::setDocumentType()
     * @uses ContragentDatumType::setAddress()
     * @uses ContragentDatumType::setTelephoneNumber()
     * @uses ContragentDatumType::setEmail()
     * @uses ContragentDatumType::setPostName()
     * @param string $type
     * @param string $name
     * @param \AisFssp\StructType\FioType $fIO
     * @param string $iNN
     * @param string $sNILS
     * @param string $oGRN
     * @param string $kPP
     * @param string $birthDate
     * @param string $birthYear
     * @param string $birthPlace
     * @param string $documentNumber
     * @param string $documentType
     * @param \AisFssp\StructType\AddressType $address
     * @param string $telephoneNumber
     * @param string $email
     * @param string $postName
     */
    public function __construct($type = null, $name = null, \AisFssp\StructType\FioType $fIO = null, $iNN = null, $sNILS = null, $oGRN = null, $kPP = null, $birthDate = null, $birthYear = null, $birthPlace = null, $documentNumber = null, $documentType = null, \AisFssp\StructType\AddressType $address = null, $telephoneNumber = null, $email = null, $postName = null)
    {
        $this
            ->setType($type)
            ->setName($name)
            ->setFIO($fIO)
            ->setINN($iNN)
            ->setSNILS($sNILS)
            ->setOGRN($oGRN)
            ->setKPP($kPP)
            ->setBirthDate($birthDate)
            ->setBirthYear($birthYear)
            ->setBirthPlace($birthPlace)
            ->setDocumentNumber($documentNumber)
            ->setDocumentType($documentType)
            ->setAddress($address)
            ->setTelephoneNumber($telephoneNumber)
            ->setEmail($email)
            ->setPostName($postName);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 1000) || (is_array($name) && count($name) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get FIO value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getFIO()
    {
        return $this->FIO;
    }
    /**
     * Set FIO value
     * @param \AisFssp\StructType\FioType $fIO
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setFIO(\AisFssp\StructType\FioType $fIO = null)
    {
        $this->FIO = $fIO;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iNN) && strlen($iNN) > 12) || (is_array($iNN) && count($iNN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($iNN) ? strlen($iNN) : count($iNN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iNN) && strlen($iNN) < 10) || (is_array($iNN) && count($iNN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iNN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($iNN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get SNILS value
     * @return string|null
     */
    public function getSNILS()
    {
        return $this->SNILS;
    }
    /**
     * Set SNILS value
     * @param string $sNILS
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setSNILS($sNILS = null)
    {
        // validation for constraint: length
        if ((is_scalar($sNILS) && strlen($sNILS) !== 11) || (is_array($sNILS) && count($sNILS) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sNILS) && !preg_match('/[0-9]{11}/', $sNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($sNILS, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sNILS) && !is_string($sNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sNILS)), __LINE__);
        }
        $this->SNILS = $sNILS;
        return $this;
    }
    /**
     * Get OGRN value
     * @return string|null
     */
    public function getOGRN()
    {
        return $this->OGRN;
    }
    /**
     * Set OGRN value
     * @param string $oGRN
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setOGRN($oGRN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oGRN) && strlen($oGRN) > 15) || (is_array($oGRN) && count($oGRN) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($oGRN) ? strlen($oGRN) : count($oGRN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oGRN) && strlen($oGRN) < 13) || (is_array($oGRN) && count($oGRN) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oGRN) && !preg_match('/([0-9]{13})|([0-9]{15})/', $oGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{13})|([0-9]{15})", "%s" given', var_export($oGRN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oGRN) && !is_string($oGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oGRN)), __LINE__);
        }
        $this->OGRN = $oGRN;
        return $this;
    }
    /**
     * Get KPP value
     * @return string|null
     */
    public function getKPP()
    {
        return $this->KPP;
    }
    /**
     * Set KPP value
     * @param string $kPP
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setKPP($kPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($kPP) && strlen($kPP) !== 9) || (is_array($kPP) && count($kPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $kPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($kPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kPP) && !is_string($kPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kPP)), __LINE__);
        }
        $this->KPP = $kPP;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($birthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get birthYear value
     * @return string|null
     */
    public function getBirthYear()
    {
        return $this->birthYear;
    }
    /**
     * Set birthYear value
     * @param string $birthYear
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setBirthYear($birthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($birthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $birthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthYear) && !is_string($birthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthYear)), __LINE__);
        }
        $this->birthYear = $birthYear;
        return $this;
    }
    /**
     * Get birthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->birthPlace;
    }
    /**
     * Set birthPlace value
     * @param string $birthPlace
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setBirthPlace($birthPlace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($birthPlace) && strlen($birthPlace) > 300) || (is_array($birthPlace) && count($birthPlace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($birthPlace) ? strlen($birthPlace) : count($birthPlace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($birthPlace) && strlen($birthPlace) < 1) || (is_array($birthPlace) && count($birthPlace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthPlace) && !is_string($birthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthPlace)), __LINE__);
        }
        $this->birthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param string $documentNumber
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) > 25) || (is_array($documentNumber) && count($documentNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($documentNumber) ? strlen($documentNumber) : count($documentNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) < 1) || (is_array($documentNumber) && count($documentNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get documentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @param string $documentType
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: length
        if ((is_scalar($documentType) && strlen($documentType) !== 2) || (is_array($documentType) && count($documentType) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($documentType) && !preg_match('/[0-9]{2}/', $documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{2}", "%s" given', var_export($documentType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentType)), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get address value
     * @return \AisFssp\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \AisFssp\StructType\AddressType $address
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setAddress(\AisFssp\StructType\AddressType $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telephoneNumber) && strlen($telephoneNumber) > 25) || (is_array($telephoneNumber) && count($telephoneNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($telephoneNumber) ? strlen($telephoneNumber) : count($telephoneNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($telephoneNumber) && strlen($telephoneNumber) < 1) || (is_array($telephoneNumber) && count($telephoneNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 100) || (is_array($email) && count($email) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($email) && strlen($email) < 1) || (is_array($email) && count($email) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get postName value
     * @return string|null
     */
    public function getPostName()
    {
        return $this->postName;
    }
    /**
     * Set postName value
     * @param string $postName
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function setPostName($postName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postName) && strlen($postName) > 255) || (is_array($postName) && count($postName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($postName) ? strlen($postName) : count($postName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($postName) && strlen($postName) < 1) || (is_array($postName) && count($postName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postName) && !is_string($postName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postName)), __LINE__);
        }
        $this->postName = $postName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
