<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyAddressDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Адрес юридического лица
 * @subpackage Structs
 */
class CompanyAddressDatumType extends AddressDataType
{
    /**
     * The organName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, адрес которого является адресом (местом нахождения) юридического лица | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $organName;
    /**
     * The addressKindId
     * Meta informations extracted from the WSDL
     * - documentation: Вид адреса юридического лица | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $addressKindId;
    /**
     * The addressKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида адреса юридического лица | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $addressKindName;
    /**
     * Constructor method for CompanyAddressDatumType
     * @uses CompanyAddressDatumType::setOrganName()
     * @uses CompanyAddressDatumType::setAddressKindId()
     * @uses CompanyAddressDatumType::setAddressKindName()
     * @param string $organName
     * @param int $addressKindId
     * @param string $addressKindName
     */
    public function __construct($organName = null, $addressKindId = null, $addressKindName = null)
    {
        $this
            ->setOrganName($organName)
            ->setAddressKindId($addressKindId)
            ->setAddressKindName($addressKindName);
    }
    /**
     * Get organName value
     * @return string|null
     */
    public function getOrganName()
    {
        return $this->organName;
    }
    /**
     * Set organName value
     * @param string $organName
     * @return \AisFssp\StructType\CompanyAddressDatumType
     */
    public function setOrganName($organName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organName) && strlen($organName) > 255) || (is_array($organName) && count($organName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($organName) ? strlen($organName) : count($organName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organName) && strlen($organName) < 1) || (is_array($organName) && count($organName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organName) && !is_string($organName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organName)), __LINE__);
        }
        $this->organName = $organName;
        return $this;
    }
    /**
     * Get addressKindId value
     * @return int|null
     */
    public function getAddressKindId()
    {
        return $this->addressKindId;
    }
    /**
     * Set addressKindId value
     * @param int $addressKindId
     * @return \AisFssp\StructType\CompanyAddressDatumType
     */
    public function setAddressKindId($addressKindId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($addressKindId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $addressKindId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($addressKindId, strpos($addressKindId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($addressKindId) && !is_numeric($addressKindId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($addressKindId)), __LINE__);
        }
        $this->addressKindId = $addressKindId;
        return $this;
    }
    /**
     * Get addressKindName value
     * @return string|null
     */
    public function getAddressKindName()
    {
        return $this->addressKindName;
    }
    /**
     * Set addressKindName value
     * @param string $addressKindName
     * @return \AisFssp\StructType\CompanyAddressDatumType
     */
    public function setAddressKindName($addressKindName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressKindName) && strlen($addressKindName) > 255) || (is_array($addressKindName) && count($addressKindName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($addressKindName) ? strlen($addressKindName) : count($addressKindName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($addressKindName) && strlen($addressKindName) < 1) || (is_array($addressKindName) && count($addressKindName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressKindName) && !is_string($addressKindName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressKindName)), __LINE__);
        }
        $this->addressKindName = $addressKindName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CompanyAddressDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
