<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashLetterDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о периодических выплатах, зачислениях
 * @subpackage Structs
 */
class CashLetterDatumType extends InformationType
{
    /**
     * The CashLetter
     * Meta informations extracted from the WSDL
     * - documentation: Вид зачисления
     * @var string
     */
    public $CashLetter;
    /**
     * The TextCashLetter
     * Meta informations extracted from the WSDL
     * - documentation: Наименование зачисления | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $TextCashLetter;
    /**
     * The CashStartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $CashStartDate;
    /**
     * The CashFinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $CashFinDate;
    /**
     * The PaymentPeriod
     * Meta informations extracted from the WSDL
     * - documentation: Периодичность зачисления
     * - minOccurs: 0
     * @var string
     */
    public $PaymentPeriod;
    /**
     * The NamePaymentPeriod
     * Meta informations extracted from the WSDL
     * - documentation: Наименование периодичности | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NamePaymentPeriod;
    /**
     * The Outpayments
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Outpayments;
    /**
     * The AccessDrawingFacilities
     * Meta informations extracted from the WSDL
     * - documentation: Порядок получения
     * @var string
     */
    public $AccessDrawingFacilities;
    /**
     * The NameAccessDrawingFacilities
     * Meta informations extracted from the WSDL
     * - documentation: Наименование порядка получения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NameAccessDrawingFacilities;
    /**
     * The Grounds
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Grounds;
    /**
     * Constructor method for CashLetterDatumType
     * @uses CashLetterDatumType::setCashLetter()
     * @uses CashLetterDatumType::setTextCashLetter()
     * @uses CashLetterDatumType::setCashStartDate()
     * @uses CashLetterDatumType::setCashFinDate()
     * @uses CashLetterDatumType::setPaymentPeriod()
     * @uses CashLetterDatumType::setNamePaymentPeriod()
     * @uses CashLetterDatumType::setOutpayments()
     * @uses CashLetterDatumType::setAccessDrawingFacilities()
     * @uses CashLetterDatumType::setNameAccessDrawingFacilities()
     * @uses CashLetterDatumType::setGrounds()
     * @param string $cashLetter
     * @param string $textCashLetter
     * @param string $cashStartDate
     * @param string $cashFinDate
     * @param string $paymentPeriod
     * @param string $namePaymentPeriod
     * @param float $outpayments
     * @param string $accessDrawingFacilities
     * @param string $nameAccessDrawingFacilities
     * @param string $grounds
     */
    public function __construct($cashLetter = null, $textCashLetter = null, $cashStartDate = null, $cashFinDate = null, $paymentPeriod = null, $namePaymentPeriod = null, $outpayments = null, $accessDrawingFacilities = null, $nameAccessDrawingFacilities = null, $grounds = null)
    {
        $this
            ->setCashLetter($cashLetter)
            ->setTextCashLetter($textCashLetter)
            ->setCashStartDate($cashStartDate)
            ->setCashFinDate($cashFinDate)
            ->setPaymentPeriod($paymentPeriod)
            ->setNamePaymentPeriod($namePaymentPeriod)
            ->setOutpayments($outpayments)
            ->setAccessDrawingFacilities($accessDrawingFacilities)
            ->setNameAccessDrawingFacilities($nameAccessDrawingFacilities)
            ->setGrounds($grounds);
    }
    /**
     * Get CashLetter value
     * @return string|null
     */
    public function getCashLetter()
    {
        return $this->CashLetter;
    }
    /**
     * Set CashLetter value
     * @uses \AisFssp\EnumType\CashLetterType::valueIsValid()
     * @uses \AisFssp\EnumType\CashLetterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cashLetter
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setCashLetter($cashLetter = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\CashLetterType::valueIsValid($cashLetter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cashLetter, implode(', ', \AisFssp\EnumType\CashLetterType::getValidValues())), __LINE__);
        }
        $this->CashLetter = $cashLetter;
        return $this;
    }
    /**
     * Get TextCashLetter value
     * @return string|null
     */
    public function getTextCashLetter()
    {
        return $this->TextCashLetter;
    }
    /**
     * Set TextCashLetter value
     * @param string $textCashLetter
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setTextCashLetter($textCashLetter = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textCashLetter) && strlen($textCashLetter) > 1000) || (is_array($textCashLetter) && count($textCashLetter) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($textCashLetter) ? strlen($textCashLetter) : count($textCashLetter)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($textCashLetter) && strlen($textCashLetter) < 1) || (is_array($textCashLetter) && count($textCashLetter) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textCashLetter) && !is_string($textCashLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textCashLetter)), __LINE__);
        }
        $this->TextCashLetter = $textCashLetter;
        return $this;
    }
    /**
     * Get CashStartDate value
     * @return string|null
     */
    public function getCashStartDate()
    {
        return $this->CashStartDate;
    }
    /**
     * Set CashStartDate value
     * @param string $cashStartDate
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setCashStartDate($cashStartDate = null)
    {
        // validation for constraint: maxExclusive
        if ($cashStartDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $cashStartDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($cashStartDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $cashStartDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cashStartDate) && !is_string($cashStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cashStartDate)), __LINE__);
        }
        $this->CashStartDate = $cashStartDate;
        return $this;
    }
    /**
     * Get CashFinDate value
     * @return string|null
     */
    public function getCashFinDate()
    {
        return $this->CashFinDate;
    }
    /**
     * Set CashFinDate value
     * @param string $cashFinDate
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setCashFinDate($cashFinDate = null)
    {
        // validation for constraint: maxExclusive
        if ($cashFinDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $cashFinDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($cashFinDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $cashFinDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cashFinDate) && !is_string($cashFinDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cashFinDate)), __LINE__);
        }
        $this->CashFinDate = $cashFinDate;
        return $this;
    }
    /**
     * Get PaymentPeriod value
     * @return string|null
     */
    public function getPaymentPeriod()
    {
        return $this->PaymentPeriod;
    }
    /**
     * Set PaymentPeriod value
     * @uses \AisFssp\EnumType\PaymentPeriodType::valueIsValid()
     * @uses \AisFssp\EnumType\PaymentPeriodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentPeriod
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setPaymentPeriod($paymentPeriod = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\PaymentPeriodType::valueIsValid($paymentPeriod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentPeriod, implode(', ', \AisFssp\EnumType\PaymentPeriodType::getValidValues())), __LINE__);
        }
        $this->PaymentPeriod = $paymentPeriod;
        return $this;
    }
    /**
     * Get NamePaymentPeriod value
     * @return string|null
     */
    public function getNamePaymentPeriod()
    {
        return $this->NamePaymentPeriod;
    }
    /**
     * Set NamePaymentPeriod value
     * @param string $namePaymentPeriod
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setNamePaymentPeriod($namePaymentPeriod = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($namePaymentPeriod) && strlen($namePaymentPeriod) > 1000) || (is_array($namePaymentPeriod) && count($namePaymentPeriod) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($namePaymentPeriod) ? strlen($namePaymentPeriod) : count($namePaymentPeriod)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($namePaymentPeriod) && strlen($namePaymentPeriod) < 1) || (is_array($namePaymentPeriod) && count($namePaymentPeriod) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($namePaymentPeriod) && !is_string($namePaymentPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($namePaymentPeriod)), __LINE__);
        }
        $this->NamePaymentPeriod = $namePaymentPeriod;
        return $this;
    }
    /**
     * Get Outpayments value
     * @return float|null
     */
    public function getOutpayments()
    {
        return $this->Outpayments;
    }
    /**
     * Set Outpayments value
     * @param float $outpayments
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setOutpayments($outpayments = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($outpayments) && strlen(substr($outpayments, strpos($outpayments, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($outpayments, strpos($outpayments, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($outpayments) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $outpayments)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($outpayments, strpos($outpayments, '.')))), __LINE__);
        }
        $this->Outpayments = $outpayments;
        return $this;
    }
    /**
     * Get AccessDrawingFacilities value
     * @return string|null
     */
    public function getAccessDrawingFacilities()
    {
        return $this->AccessDrawingFacilities;
    }
    /**
     * Set AccessDrawingFacilities value
     * @uses \AisFssp\EnumType\AccessDrawingFacilitiesType::valueIsValid()
     * @uses \AisFssp\EnumType\AccessDrawingFacilitiesType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessDrawingFacilities
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setAccessDrawingFacilities($accessDrawingFacilities = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\AccessDrawingFacilitiesType::valueIsValid($accessDrawingFacilities)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accessDrawingFacilities, implode(', ', \AisFssp\EnumType\AccessDrawingFacilitiesType::getValidValues())), __LINE__);
        }
        $this->AccessDrawingFacilities = $accessDrawingFacilities;
        return $this;
    }
    /**
     * Get NameAccessDrawingFacilities value
     * @return string|null
     */
    public function getNameAccessDrawingFacilities()
    {
        return $this->NameAccessDrawingFacilities;
    }
    /**
     * Set NameAccessDrawingFacilities value
     * @param string $nameAccessDrawingFacilities
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setNameAccessDrawingFacilities($nameAccessDrawingFacilities = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nameAccessDrawingFacilities) && strlen($nameAccessDrawingFacilities) > 1000) || (is_array($nameAccessDrawingFacilities) && count($nameAccessDrawingFacilities) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($nameAccessDrawingFacilities) ? strlen($nameAccessDrawingFacilities) : count($nameAccessDrawingFacilities)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($nameAccessDrawingFacilities) && strlen($nameAccessDrawingFacilities) < 1) || (is_array($nameAccessDrawingFacilities) && count($nameAccessDrawingFacilities) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nameAccessDrawingFacilities) && !is_string($nameAccessDrawingFacilities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameAccessDrawingFacilities)), __LINE__);
        }
        $this->NameAccessDrawingFacilities = $nameAccessDrawingFacilities;
        return $this;
    }
    /**
     * Get Grounds value
     * @return string|null
     */
    public function getGrounds()
    {
        return $this->Grounds;
    }
    /**
     * Set Grounds value
     * @param string $grounds
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public function setGrounds($grounds = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($grounds) && strlen($grounds) > 1000) || (is_array($grounds) && count($grounds) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($grounds) ? strlen($grounds) : count($grounds)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($grounds) && strlen($grounds) < 1) || (is_array($grounds) && count($grounds) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($grounds) && !is_string($grounds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grounds)), __LINE__);
        }
        $this->Grounds = $grounds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CashLetterDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
