<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityAccDepoDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений AvailabilityAccDepoDataType "Наличие счетов ДЕПО"
 * @subpackage Structs
 */
class AvailabilityAccDepoDataType extends InformationType
{
    /**
     * The StrAcc
     * Meta informations extracted from the WSDL
     * - documentation: Счет ДЕПО | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $StrAcc;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * Constructor method for AvailabilityAccDepoDataType
     * @uses AvailabilityAccDepoDataType::setStrAcc()
     * @uses AvailabilityAccDepoDataType::setDeptCode()
     * @param string $strAcc
     * @param string $deptCode
     */
    public function __construct($strAcc = null, $deptCode = null)
    {
        $this
            ->setStrAcc($strAcc)
            ->setDeptCode($deptCode);
    }
    /**
     * Get StrAcc value
     * @return string|null
     */
    public function getStrAcc()
    {
        return $this->StrAcc;
    }
    /**
     * Set StrAcc value
     * @param string $strAcc
     * @return \AisFssp\StructType\AvailabilityAccDepoDataType
     */
    public function setStrAcc($strAcc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($strAcc) && strlen($strAcc) > 20) || (is_array($strAcc) && count($strAcc) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($strAcc) ? strlen($strAcc) : count($strAcc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($strAcc) && strlen($strAcc) < 1) || (is_array($strAcc) && count($strAcc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($strAcc) && !is_string($strAcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($strAcc)), __LINE__);
        }
        $this->StrAcc = $strAcc;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \AisFssp\StructType\AvailabilityAccDepoDataType
     */
    public function setDeptCode($deptCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deptCode) && strlen($deptCode) > 10) || (is_array($deptCode) && count($deptCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($deptCode) ? strlen($deptCode) : count($deptCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($deptCode) && strlen($deptCode) < 1) || (is_array($deptCode) && count($deptCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deptCode) && !is_string($deptCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deptCode)), __LINE__);
        }
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AvailabilityAccDepoDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
