<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityAccDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений AvailabilityAccDataType "Наличие денежных средств на счете"
 * @subpackage Structs
 */
class AvailabilityAccDataType extends AccountDatumType
{
    /**
     * The Summa
     * Meta informations extracted from the WSDL
     * - documentation: Cумма в валюте счета | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Summa;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Валюта счета | Указывается код валюты счета в соответствии с Общероссийским классификатором валют. В случае отсутствия
     * значения кода в общероссийском классификаторе валют, используется значение из Классификатора клиринговых валют. | Валюта | Код валюты
     * по общероссийскому классификатору валют. В случае отсутствия значения кода в общероссийском классификаторе валют - используется
     * значение из Классификатора клиринговых валют.
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9a-zA-Zа-яА-Я]{1}[0-9]{2}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The SummaInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о сумме | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SummaInfo;
    /**
     * The SummaRUB
     * Meta informations extracted from the WSDL
     * - documentation: Сумма в рублях | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SummaRUB;
    /**
     * The DateChange
     * Meta informations extracted from the WSDL
     * - documentation: Дата курса | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateChange;
    /**
     * The UnityExchange
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о сумме | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $UnityExchange;
    /**
     * The ExchangeRate
     * Meta informations extracted from the WSDL
     * - documentation: Курс валюты | Обязательно заполняется курс валюты, в случае если валюта счета отлична от значения «810», «643». Указывается курс
     * валюты банка, либо, в случае отсутствия в банке собственного курса валюты, курс валюты ЦБ РФ, на дату формирования ответа. | Курс валюты
     * - minOccurs: 0
     * - fractionDigits: 4
     * - totalDigits: 15
     * @var float
     */
    public $ExchangeRate;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * Constructor method for AvailabilityAccDataType
     * @uses AvailabilityAccDataType::setSumma()
     * @uses AvailabilityAccDataType::setCurrencyCode()
     * @uses AvailabilityAccDataType::setSummaInfo()
     * @uses AvailabilityAccDataType::setSummaRUB()
     * @uses AvailabilityAccDataType::setDateChange()
     * @uses AvailabilityAccDataType::setUnityExchange()
     * @uses AvailabilityAccDataType::setExchangeRate()
     * @uses AvailabilityAccDataType::setDeptCode()
     * @param float $summa
     * @param string $currencyCode
     * @param string $summaInfo
     * @param float $summaRUB
     * @param string $dateChange
     * @param string $unityExchange
     * @param float $exchangeRate
     * @param string $deptCode
     */
    public function __construct($summa = null, $currencyCode = null, $summaInfo = null, $summaRUB = null, $dateChange = null, $unityExchange = null, $exchangeRate = null, $deptCode = null)
    {
        $this
            ->setSumma($summa)
            ->setCurrencyCode($currencyCode)
            ->setSummaInfo($summaInfo)
            ->setSummaRUB($summaRUB)
            ->setDateChange($dateChange)
            ->setUnityExchange($unityExchange)
            ->setExchangeRate($exchangeRate)
            ->setDeptCode($deptCode);
    }
    /**
     * Get Summa value
     * @return float|null
     */
    public function getSumma()
    {
        return $this->Summa;
    }
    /**
     * Set Summa value
     * @param float $summa
     * @return \AisFssp\StructType\AvailabilityAccDataType
     */
    public function setSumma($summa = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($summa) && strlen(substr($summa, strpos($summa, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($summa, strpos($summa, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($summa) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $summa)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($summa, strpos($summa, '.')))), __LINE__);
        }
        $this->Summa = $summa;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \AisFssp\StructType\AvailabilityAccDataType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($currencyCode) && strlen($currencyCode) !== 3) || (is_array($currencyCode) && count($currencyCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($currencyCode) && !preg_match('/[0-9a-zA-Zа-яА-Я]{1}[0-9]{2}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-zA-Zа-яА-Я]{1}[0-9]{2}", "%s" given', var_export($currencyCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get SummaInfo value
     * @return string|null
     */
    public function getSummaInfo()
    {
        return $this->SummaInfo;
    }
    /**
     * Set SummaInfo value
     * @param string $summaInfo
     * @return \AisFssp\StructType\AvailabilityAccDataType
     */
    public function setSummaInfo($summaInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($summaInfo) && strlen($summaInfo) > 100) || (is_array($summaInfo) && count($summaInfo) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($summaInfo) ? strlen($summaInfo) : count($summaInfo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($summaInfo) && strlen($summaInfo) < 1) || (is_array($summaInfo) && count($summaInfo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($summaInfo) && !is_string($summaInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($summaInfo)), __LINE__);
        }
        $this->SummaInfo = $summaInfo;
        return $this;
    }
    /**
     * Get SummaRUB value
     * @return float|null
     */
    public function getSummaRUB()
    {
        return $this->SummaRUB;
    }
    /**
     * Set SummaRUB value
     * @param float $summaRUB
     * @return \AisFssp\StructType\AvailabilityAccDataType
     */
    public function setSummaRUB($summaRUB = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($summaRUB) && strlen(substr($summaRUB, strpos($summaRUB, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($summaRUB, strpos($summaRUB, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($summaRUB) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $summaRUB)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($summaRUB, strpos($summaRUB, '.')))), __LINE__);
        }
        $this->SummaRUB = $summaRUB;
        return $this;
    }
    /**
     * Get DateChange value
     * @return string|null
     */
    public function getDateChange()
    {
        return $this->DateChange;
    }
    /**
     * Set DateChange value
     * @param string $dateChange
     * @return \AisFssp\StructType\AvailabilityAccDataType
     */
    public function setDateChange($dateChange = null)
    {
        // validation for constraint: maxExclusive
        if ($dateChange >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateChange), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateChange < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateChange), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateChange) && !is_string($dateChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateChange)), __LINE__);
        }
        $this->DateChange = $dateChange;
        return $this;
    }
    /**
     * Get UnityExchange value
     * @return string|null
     */
    public function getUnityExchange()
    {
        return $this->UnityExchange;
    }
    /**
     * Set UnityExchange value
     * @param string $unityExchange
     * @return \AisFssp\StructType\AvailabilityAccDataType
     */
    public function setUnityExchange($unityExchange = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unityExchange) && strlen($unityExchange) > 10) || (is_array($unityExchange) && count($unityExchange) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($unityExchange) ? strlen($unityExchange) : count($unityExchange)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($unityExchange) && strlen($unityExchange) < 1) || (is_array($unityExchange) && count($unityExchange) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unityExchange) && !is_string($unityExchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unityExchange)), __LINE__);
        }
        $this->UnityExchange = $unityExchange;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \AisFssp\StructType\AvailabilityAccDataType
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($exchangeRate) && strlen(substr($exchangeRate, strpos($exchangeRate, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($exchangeRate, strpos($exchangeRate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($exchangeRate) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $exchangeRate)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($exchangeRate, strpos($exchangeRate, '.')))), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \AisFssp\StructType\AvailabilityAccDataType
     */
    public function setDeptCode($deptCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deptCode) && strlen($deptCode) > 10) || (is_array($deptCode) && count($deptCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($deptCode) ? strlen($deptCode) : count($deptCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($deptCode) && strlen($deptCode) < 1) || (is_array($deptCode) && count($deptCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deptCode) && !is_string($deptCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deptCode)), __LINE__);
        }
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AvailabilityAccDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
