<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrestRegistryDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Строка выписки из реестра арестованного имущество отправленного на реализацию
 * - type: tns:ArrestRegistryDetail
 * @subpackage Structs
 */
class ArrestRegistryDetail extends AbstractStructBase
{
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumber;
    /**
     * The IPStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус ИП | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $IPStatus;
    /**
     * The OSPName
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия сведений | Наименование ОСП по справочнику ВКСП. | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OSPName;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО СПИ полностью. | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIFioParts
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО СПИ. Заполняется только в том случае, если соответствующие данные есть в системе.
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $SPIFioParts;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ по справочнику должностей СПИ на основе ОКПДТР / РДФГГС. | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The Debtor
     * Meta informations extracted from the WSDL
     * - documentation: Должник | Сведения о должнике. В рамках сведений не передается такая информация, как: Место рождения контрагента, Номер
     * документа, Тип документа, удостоверяющего личность, Адрес контрагента, Телефон, Электропочта, Должность.
     * - minOccurs: 0
     * @var \AisFssp\StructType\ContragentDatumType
     */
    public $Debtor;
    /**
     * The IDSubjName
     * Meta informations extracted from the WSDL
     * - documentation: Сущность исполнения | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDSubjName;
    /**
     * The IPDebt
     * Meta informations extracted from the WSDL
     * - documentation: Сумма взыскания | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebt;
    /**
     * The DateArrest
     * Meta informations extracted from the WSDL
     * - documentation: Дата наложения ареста | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateArrest;
    /**
     * The TypeProperty
     * Meta informations extracted from the WSDL
     * - documentation: Тип имущества | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $TypeProperty;
    /**
     * The TypePropertyText
     * Meta informations extracted from the WSDL
     * - documentation: Наименование имущества | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $TypePropertyText;
    /**
     * The CostPropertyAct
     * Meta informations extracted from the WSDL
     * - documentation: Стоимость имущества по акту | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $CostPropertyAct;
    /**
     * The NumberRealEstate
     * Meta informations extracted from the WSDL
     * - documentation: Номер заявки на оценку | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NumberRealEstate;
    /**
     * The DateRealEstate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заявки на оценку | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateRealEstate;
    /**
     * The DateDecreeAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления об участии оценщика | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDecreeAppraiser;
    /**
     * The NameOrgAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Наименование оценочной организации | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NameOrgAppraiser;
    /**
     * The DateReportAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчета об оценке | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateReportAppraiser;
    /**
     * The DateDecreeApprovalAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления об утверждении оценки | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDecreeApprovalAppraiser;
    /**
     * The DateAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Дата оценки | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateAppraiser;
    /**
     * The CostPropertyAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Стоимость имущества по результатам оценки | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $CostPropertyAppraiser;
    /**
     * The DateDecreeSelling
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления о передаче на реализацию | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDecreeSelling;
    /**
     * The NumberApplicationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Номер заявки на реализацию | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NumberApplicationSelling;
    /**
     * The DateApplicationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Дата заявки на реализацию | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateApplicationSelling;
    /**
     * The DateDliverySelling
     * Meta informations extracted from the WSDL
     * - documentation: Дата передачи на реализацию | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDliverySelling;
    /**
     * The OrganizationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Наименование реализатора | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $OrganizationSelling;
    /**
     * The AddressOrganizationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Адрес реализатора
     * @var \AisFssp\StructType\AddressType
     */
    public $AddressOrganizationSelling;
    /**
     * The PhoneOrganizationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PhoneOrganizationSelling;
    /**
     * The DateSelling
     * Meta informations extracted from the WSDL
     * - documentation: Дата проведения торгов или выставления имущества на экспозицию | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateSelling;
    /**
     * The AddressSelling
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места проведения торгов (место экспозиции)
     * @var \AisFssp\StructType\AddressType
     */
    public $AddressSelling;
    /**
     * The NameMedia
     * Meta informations extracted from the WSDL
     * - documentation: Наименование СМИ | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NameMedia;
    /**
     * The DatePublication
     * Meta informations extracted from the WSDL
     * - documentation: Дата публикации информации о реализации арестованного имущества | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DatePublication;
    /**
     * The StartingPrice
     * Meta informations extracted from the WSDL
     * - documentation: Начальная продажная цена (руб.) | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $StartingPrice;
    /**
     * Constructor method for ArrestRegistryDetail
     * @uses ArrestRegistryDetail::setIPNumber()
     * @uses ArrestRegistryDetail::setIPStatus()
     * @uses ArrestRegistryDetail::setOSPName()
     * @uses ArrestRegistryDetail::setSPI()
     * @uses ArrestRegistryDetail::setSPIFio()
     * @uses ArrestRegistryDetail::setSPIFioParts()
     * @uses ArrestRegistryDetail::setSPITel()
     * @uses ArrestRegistryDetail::setSPIPost()
     * @uses ArrestRegistryDetail::setDebtor()
     * @uses ArrestRegistryDetail::setIDSubjName()
     * @uses ArrestRegistryDetail::setIPDebt()
     * @uses ArrestRegistryDetail::setDateArrest()
     * @uses ArrestRegistryDetail::setTypeProperty()
     * @uses ArrestRegistryDetail::setTypePropertyText()
     * @uses ArrestRegistryDetail::setCostPropertyAct()
     * @uses ArrestRegistryDetail::setNumberRealEstate()
     * @uses ArrestRegistryDetail::setDateRealEstate()
     * @uses ArrestRegistryDetail::setDateDecreeAppraiser()
     * @uses ArrestRegistryDetail::setNameOrgAppraiser()
     * @uses ArrestRegistryDetail::setDateReportAppraiser()
     * @uses ArrestRegistryDetail::setDateDecreeApprovalAppraiser()
     * @uses ArrestRegistryDetail::setDateAppraiser()
     * @uses ArrestRegistryDetail::setCostPropertyAppraiser()
     * @uses ArrestRegistryDetail::setDateDecreeSelling()
     * @uses ArrestRegistryDetail::setNumberApplicationSelling()
     * @uses ArrestRegistryDetail::setDateApplicationSelling()
     * @uses ArrestRegistryDetail::setDateDliverySelling()
     * @uses ArrestRegistryDetail::setOrganizationSelling()
     * @uses ArrestRegistryDetail::setAddressOrganizationSelling()
     * @uses ArrestRegistryDetail::setPhoneOrganizationSelling()
     * @uses ArrestRegistryDetail::setDateSelling()
     * @uses ArrestRegistryDetail::setAddressSelling()
     * @uses ArrestRegistryDetail::setNameMedia()
     * @uses ArrestRegistryDetail::setDatePublication()
     * @uses ArrestRegistryDetail::setStartingPrice()
     * @param string $iPNumber
     * @param string $iPStatus
     * @param string $oSPName
     * @param int $sPI
     * @param string $sPIFio
     * @param \AisFssp\StructType\FioType $sPIFioParts
     * @param string $sPITel
     * @param string $sPIPost
     * @param \AisFssp\StructType\ContragentDatumType $debtor
     * @param string $iDSubjName
     * @param float $iPDebt
     * @param string $dateArrest
     * @param string $typeProperty
     * @param string $typePropertyText
     * @param float $costPropertyAct
     * @param string $numberRealEstate
     * @param string $dateRealEstate
     * @param string $dateDecreeAppraiser
     * @param string $nameOrgAppraiser
     * @param string $dateReportAppraiser
     * @param string $dateDecreeApprovalAppraiser
     * @param string $dateAppraiser
     * @param float $costPropertyAppraiser
     * @param string $dateDecreeSelling
     * @param string $numberApplicationSelling
     * @param string $dateApplicationSelling
     * @param string $dateDliverySelling
     * @param string $organizationSelling
     * @param \AisFssp\StructType\AddressType $addressOrganizationSelling
     * @param string $phoneOrganizationSelling
     * @param string $dateSelling
     * @param \AisFssp\StructType\AddressType $addressSelling
     * @param string $nameMedia
     * @param string $datePublication
     * @param float $startingPrice
     */
    public function __construct($iPNumber = null, $iPStatus = null, $oSPName = null, $sPI = null, $sPIFio = null, \AisFssp\StructType\FioType $sPIFioParts = null, $sPITel = null, $sPIPost = null, \AisFssp\StructType\ContragentDatumType $debtor = null, $iDSubjName = null, $iPDebt = null, $dateArrest = null, $typeProperty = null, $typePropertyText = null, $costPropertyAct = null, $numberRealEstate = null, $dateRealEstate = null, $dateDecreeAppraiser = null, $nameOrgAppraiser = null, $dateReportAppraiser = null, $dateDecreeApprovalAppraiser = null, $dateAppraiser = null, $costPropertyAppraiser = null, $dateDecreeSelling = null, $numberApplicationSelling = null, $dateApplicationSelling = null, $dateDliverySelling = null, $organizationSelling = null, \AisFssp\StructType\AddressType $addressOrganizationSelling = null, $phoneOrganizationSelling = null, $dateSelling = null, \AisFssp\StructType\AddressType $addressSelling = null, $nameMedia = null, $datePublication = null, $startingPrice = null)
    {
        $this
            ->setIPNumber($iPNumber)
            ->setIPStatus($iPStatus)
            ->setOSPName($oSPName)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPIFioParts($sPIFioParts)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost)
            ->setDebtor($debtor)
            ->setIDSubjName($iDSubjName)
            ->setIPDebt($iPDebt)
            ->setDateArrest($dateArrest)
            ->setTypeProperty($typeProperty)
            ->setTypePropertyText($typePropertyText)
            ->setCostPropertyAct($costPropertyAct)
            ->setNumberRealEstate($numberRealEstate)
            ->setDateRealEstate($dateRealEstate)
            ->setDateDecreeAppraiser($dateDecreeAppraiser)
            ->setNameOrgAppraiser($nameOrgAppraiser)
            ->setDateReportAppraiser($dateReportAppraiser)
            ->setDateDecreeApprovalAppraiser($dateDecreeApprovalAppraiser)
            ->setDateAppraiser($dateAppraiser)
            ->setCostPropertyAppraiser($costPropertyAppraiser)
            ->setDateDecreeSelling($dateDecreeSelling)
            ->setNumberApplicationSelling($numberApplicationSelling)
            ->setDateApplicationSelling($dateApplicationSelling)
            ->setDateDliverySelling($dateDliverySelling)
            ->setOrganizationSelling($organizationSelling)
            ->setAddressOrganizationSelling($addressOrganizationSelling)
            ->setPhoneOrganizationSelling($phoneOrganizationSelling)
            ->setDateSelling($dateSelling)
            ->setAddressSelling($addressSelling)
            ->setNameMedia($nameMedia)
            ->setDatePublication($datePublication)
            ->setStartingPrice($startingPrice);
    }
    /**
     * Get IPNumber value
     * @return string|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @param string $iPNumber
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setIPNumber($iPNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) > 25) || (is_array($iPNumber) && count($iPNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNumber) ? strlen($iPNumber) : count($iPNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) < 1) || (is_array($iPNumber) && count($iPNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNumber) && !is_string($iPNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNumber)), __LINE__);
        }
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Get IPStatus value
     * @return string|null
     */
    public function getIPStatus()
    {
        return $this->IPStatus;
    }
    /**
     * Set IPStatus value
     * @param string $iPStatus
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setIPStatus($iPStatus = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPStatus) && strlen($iPStatus) > 255) || (is_array($iPStatus) && count($iPStatus) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($iPStatus) ? strlen($iPStatus) : count($iPStatus)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPStatus) && strlen($iPStatus) < 1) || (is_array($iPStatus) && count($iPStatus) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPStatus) && !is_string($iPStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPStatus)), __LINE__);
        }
        $this->IPStatus = $iPStatus;
        return $this;
    }
    /**
     * Get OSPName value
     * @return string|null
     */
    public function getOSPName()
    {
        return $this->OSPName;
    }
    /**
     * Set OSPName value
     * @param string $oSPName
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setOSPName($oSPName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oSPName) && strlen($oSPName) > 100) || (is_array($oSPName) && count($oSPName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($oSPName) ? strlen($oSPName) : count($oSPName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oSPName) && strlen($oSPName) < 1) || (is_array($oSPName) && count($oSPName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oSPName) && !is_string($oSPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oSPName)), __LINE__);
        }
        $this->OSPName = $oSPName;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setSPI($sPI = null)
    {
        // validation for constraint: maxInclusive
        if ($sPI > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($sPI < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($sPI) && !is_numeric($sPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sPI)), __LINE__);
        }
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setSPIFio($sPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) > 100) || (is_array($sPIFio) && count($sPIFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($sPIFio) ? strlen($sPIFio) : count($sPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) < 1) || (is_array($sPIFio) && count($sPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIFio) && !is_string($sPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIFio)), __LINE__);
        }
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIFioParts value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getSPIFioParts()
    {
        return $this->SPIFioParts;
    }
    /**
     * Set SPIFioParts value
     * @param \AisFssp\StructType\FioType $sPIFioParts
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setSPIFioParts(\AisFssp\StructType\FioType $sPIFioParts = null)
    {
        $this->SPIFioParts = $sPIFioParts;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setSPITel($sPITel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPITel) && strlen($sPITel) > 25) || (is_array($sPITel) && count($sPITel) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPITel) ? strlen($sPITel) : count($sPITel)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPITel) && strlen($sPITel) < 1) || (is_array($sPITel) && count($sPITel) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPITel) && !is_string($sPITel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPITel)), __LINE__);
        }
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setSPIPost($sPIPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) > 25) || (is_array($sPIPost) && count($sPIPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPIPost) ? strlen($sPIPost) : count($sPIPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) < 1) || (is_array($sPIPost) && count($sPIPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sPIPost) && !preg_match('/[0-9\\-\\.\\s]+/', $sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($sPIPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIPost) && !is_string($sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIPost)), __LINE__);
        }
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get Debtor value
     * @return \AisFssp\StructType\ContragentDatumType|null
     */
    public function getDebtor()
    {
        return $this->Debtor;
    }
    /**
     * Set Debtor value
     * @param \AisFssp\StructType\ContragentDatumType $debtor
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDebtor(\AisFssp\StructType\ContragentDatumType $debtor = null)
    {
        $this->Debtor = $debtor;
        return $this;
    }
    /**
     * Get IDSubjName value
     * @return string|null
     */
    public function getIDSubjName()
    {
        return $this->IDSubjName;
    }
    /**
     * Set IDSubjName value
     * @param string $iDSubjName
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setIDSubjName($iDSubjName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDSubjName) && strlen($iDSubjName) > 300) || (is_array($iDSubjName) && count($iDSubjName) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($iDSubjName) ? strlen($iDSubjName) : count($iDSubjName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDSubjName) && strlen($iDSubjName) < 1) || (is_array($iDSubjName) && count($iDSubjName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDSubjName) && !is_string($iDSubjName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDSubjName)), __LINE__);
        }
        $this->IDSubjName = $iDSubjName;
        return $this;
    }
    /**
     * Get IPDebt value
     * @return float|null
     */
    public function getIPDebt()
    {
        return $this->IPDebt;
    }
    /**
     * Set IPDebt value
     * @param float $iPDebt
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setIPDebt($iPDebt = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iPDebt) && strlen(substr($iPDebt, strpos($iPDebt, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iPDebt, strpos($iPDebt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iPDebt) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iPDebt)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iPDebt, strpos($iPDebt, '.')))), __LINE__);
        }
        $this->IPDebt = $iPDebt;
        return $this;
    }
    /**
     * Get DateArrest value
     * @return string|null
     */
    public function getDateArrest()
    {
        return $this->DateArrest;
    }
    /**
     * Set DateArrest value
     * @param string $dateArrest
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateArrest($dateArrest = null)
    {
        // validation for constraint: maxExclusive
        if ($dateArrest >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateArrest), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateArrest < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateArrest), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateArrest) && !is_string($dateArrest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateArrest)), __LINE__);
        }
        $this->DateArrest = $dateArrest;
        return $this;
    }
    /**
     * Get TypeProperty value
     * @return string|null
     */
    public function getTypeProperty()
    {
        return $this->TypeProperty;
    }
    /**
     * Set TypeProperty value
     * @param string $typeProperty
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setTypeProperty($typeProperty = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($typeProperty) && strlen($typeProperty) > 300) || (is_array($typeProperty) && count($typeProperty) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($typeProperty) ? strlen($typeProperty) : count($typeProperty)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($typeProperty) && strlen($typeProperty) < 1) || (is_array($typeProperty) && count($typeProperty) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($typeProperty) && !is_string($typeProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeProperty)), __LINE__);
        }
        $this->TypeProperty = $typeProperty;
        return $this;
    }
    /**
     * Get TypePropertyText value
     * @return string|null
     */
    public function getTypePropertyText()
    {
        return $this->TypePropertyText;
    }
    /**
     * Set TypePropertyText value
     * @param string $typePropertyText
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setTypePropertyText($typePropertyText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($typePropertyText) && strlen($typePropertyText) > 1000) || (is_array($typePropertyText) && count($typePropertyText) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($typePropertyText) ? strlen($typePropertyText) : count($typePropertyText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($typePropertyText) && strlen($typePropertyText) < 1) || (is_array($typePropertyText) && count($typePropertyText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($typePropertyText) && !is_string($typePropertyText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typePropertyText)), __LINE__);
        }
        $this->TypePropertyText = $typePropertyText;
        return $this;
    }
    /**
     * Get CostPropertyAct value
     * @return float|null
     */
    public function getCostPropertyAct()
    {
        return $this->CostPropertyAct;
    }
    /**
     * Set CostPropertyAct value
     * @param float $costPropertyAct
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setCostPropertyAct($costPropertyAct = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($costPropertyAct) && strlen(substr($costPropertyAct, strpos($costPropertyAct, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($costPropertyAct, strpos($costPropertyAct, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($costPropertyAct) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $costPropertyAct)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($costPropertyAct, strpos($costPropertyAct, '.')))), __LINE__);
        }
        $this->CostPropertyAct = $costPropertyAct;
        return $this;
    }
    /**
     * Get NumberRealEstate value
     * @return string|null
     */
    public function getNumberRealEstate()
    {
        return $this->NumberRealEstate;
    }
    /**
     * Set NumberRealEstate value
     * @param string $numberRealEstate
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setNumberRealEstate($numberRealEstate = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numberRealEstate) && strlen($numberRealEstate) > 25) || (is_array($numberRealEstate) && count($numberRealEstate) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($numberRealEstate) ? strlen($numberRealEstate) : count($numberRealEstate)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numberRealEstate) && strlen($numberRealEstate) < 1) || (is_array($numberRealEstate) && count($numberRealEstate) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numberRealEstate) && !is_string($numberRealEstate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberRealEstate)), __LINE__);
        }
        $this->NumberRealEstate = $numberRealEstate;
        return $this;
    }
    /**
     * Get DateRealEstate value
     * @return string|null
     */
    public function getDateRealEstate()
    {
        return $this->DateRealEstate;
    }
    /**
     * Set DateRealEstate value
     * @param string $dateRealEstate
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateRealEstate($dateRealEstate = null)
    {
        // validation for constraint: maxExclusive
        if ($dateRealEstate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateRealEstate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateRealEstate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateRealEstate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRealEstate) && !is_string($dateRealEstate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRealEstate)), __LINE__);
        }
        $this->DateRealEstate = $dateRealEstate;
        return $this;
    }
    /**
     * Get DateDecreeAppraiser value
     * @return string|null
     */
    public function getDateDecreeAppraiser()
    {
        return $this->DateDecreeAppraiser;
    }
    /**
     * Set DateDecreeAppraiser value
     * @param string $dateDecreeAppraiser
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateDecreeAppraiser($dateDecreeAppraiser = null)
    {
        // validation for constraint: maxExclusive
        if ($dateDecreeAppraiser >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateDecreeAppraiser), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateDecreeAppraiser < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateDecreeAppraiser), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDecreeAppraiser) && !is_string($dateDecreeAppraiser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDecreeAppraiser)), __LINE__);
        }
        $this->DateDecreeAppraiser = $dateDecreeAppraiser;
        return $this;
    }
    /**
     * Get NameOrgAppraiser value
     * @return string|null
     */
    public function getNameOrgAppraiser()
    {
        return $this->NameOrgAppraiser;
    }
    /**
     * Set NameOrgAppraiser value
     * @param string $nameOrgAppraiser
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setNameOrgAppraiser($nameOrgAppraiser = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nameOrgAppraiser) && strlen($nameOrgAppraiser) > 1000) || (is_array($nameOrgAppraiser) && count($nameOrgAppraiser) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($nameOrgAppraiser) ? strlen($nameOrgAppraiser) : count($nameOrgAppraiser)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($nameOrgAppraiser) && strlen($nameOrgAppraiser) < 1) || (is_array($nameOrgAppraiser) && count($nameOrgAppraiser) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nameOrgAppraiser) && !is_string($nameOrgAppraiser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOrgAppraiser)), __LINE__);
        }
        $this->NameOrgAppraiser = $nameOrgAppraiser;
        return $this;
    }
    /**
     * Get DateReportAppraiser value
     * @return string|null
     */
    public function getDateReportAppraiser()
    {
        return $this->DateReportAppraiser;
    }
    /**
     * Set DateReportAppraiser value
     * @param string $dateReportAppraiser
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateReportAppraiser($dateReportAppraiser = null)
    {
        // validation for constraint: maxExclusive
        if ($dateReportAppraiser >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateReportAppraiser), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateReportAppraiser < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateReportAppraiser), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateReportAppraiser) && !is_string($dateReportAppraiser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateReportAppraiser)), __LINE__);
        }
        $this->DateReportAppraiser = $dateReportAppraiser;
        return $this;
    }
    /**
     * Get DateDecreeApprovalAppraiser value
     * @return string|null
     */
    public function getDateDecreeApprovalAppraiser()
    {
        return $this->DateDecreeApprovalAppraiser;
    }
    /**
     * Set DateDecreeApprovalAppraiser value
     * @param string $dateDecreeApprovalAppraiser
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateDecreeApprovalAppraiser($dateDecreeApprovalAppraiser = null)
    {
        // validation for constraint: maxExclusive
        if ($dateDecreeApprovalAppraiser >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateDecreeApprovalAppraiser), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateDecreeApprovalAppraiser < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateDecreeApprovalAppraiser), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDecreeApprovalAppraiser) && !is_string($dateDecreeApprovalAppraiser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDecreeApprovalAppraiser)), __LINE__);
        }
        $this->DateDecreeApprovalAppraiser = $dateDecreeApprovalAppraiser;
        return $this;
    }
    /**
     * Get DateAppraiser value
     * @return string|null
     */
    public function getDateAppraiser()
    {
        return $this->DateAppraiser;
    }
    /**
     * Set DateAppraiser value
     * @param string $dateAppraiser
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateAppraiser($dateAppraiser = null)
    {
        // validation for constraint: maxExclusive
        if ($dateAppraiser >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateAppraiser), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateAppraiser < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateAppraiser), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateAppraiser) && !is_string($dateAppraiser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateAppraiser)), __LINE__);
        }
        $this->DateAppraiser = $dateAppraiser;
        return $this;
    }
    /**
     * Get CostPropertyAppraiser value
     * @return float|null
     */
    public function getCostPropertyAppraiser()
    {
        return $this->CostPropertyAppraiser;
    }
    /**
     * Set CostPropertyAppraiser value
     * @param float $costPropertyAppraiser
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setCostPropertyAppraiser($costPropertyAppraiser = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($costPropertyAppraiser) && strlen(substr($costPropertyAppraiser, strpos($costPropertyAppraiser, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($costPropertyAppraiser, strpos($costPropertyAppraiser, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($costPropertyAppraiser) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $costPropertyAppraiser)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($costPropertyAppraiser, strpos($costPropertyAppraiser, '.')))), __LINE__);
        }
        $this->CostPropertyAppraiser = $costPropertyAppraiser;
        return $this;
    }
    /**
     * Get DateDecreeSelling value
     * @return string|null
     */
    public function getDateDecreeSelling()
    {
        return $this->DateDecreeSelling;
    }
    /**
     * Set DateDecreeSelling value
     * @param string $dateDecreeSelling
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateDecreeSelling($dateDecreeSelling = null)
    {
        // validation for constraint: maxExclusive
        if ($dateDecreeSelling >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateDecreeSelling), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateDecreeSelling < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateDecreeSelling), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDecreeSelling) && !is_string($dateDecreeSelling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDecreeSelling)), __LINE__);
        }
        $this->DateDecreeSelling = $dateDecreeSelling;
        return $this;
    }
    /**
     * Get NumberApplicationSelling value
     * @return string|null
     */
    public function getNumberApplicationSelling()
    {
        return $this->NumberApplicationSelling;
    }
    /**
     * Set NumberApplicationSelling value
     * @param string $numberApplicationSelling
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setNumberApplicationSelling($numberApplicationSelling = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numberApplicationSelling) && strlen($numberApplicationSelling) > 25) || (is_array($numberApplicationSelling) && count($numberApplicationSelling) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($numberApplicationSelling) ? strlen($numberApplicationSelling) : count($numberApplicationSelling)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numberApplicationSelling) && strlen($numberApplicationSelling) < 1) || (is_array($numberApplicationSelling) && count($numberApplicationSelling) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numberApplicationSelling) && !is_string($numberApplicationSelling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberApplicationSelling)), __LINE__);
        }
        $this->NumberApplicationSelling = $numberApplicationSelling;
        return $this;
    }
    /**
     * Get DateApplicationSelling value
     * @return string|null
     */
    public function getDateApplicationSelling()
    {
        return $this->DateApplicationSelling;
    }
    /**
     * Set DateApplicationSelling value
     * @param string $dateApplicationSelling
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateApplicationSelling($dateApplicationSelling = null)
    {
        // validation for constraint: maxExclusive
        if ($dateApplicationSelling >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateApplicationSelling), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateApplicationSelling < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateApplicationSelling), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateApplicationSelling) && !is_string($dateApplicationSelling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateApplicationSelling)), __LINE__);
        }
        $this->DateApplicationSelling = $dateApplicationSelling;
        return $this;
    }
    /**
     * Get DateDliverySelling value
     * @return string|null
     */
    public function getDateDliverySelling()
    {
        return $this->DateDliverySelling;
    }
    /**
     * Set DateDliverySelling value
     * @param string $dateDliverySelling
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateDliverySelling($dateDliverySelling = null)
    {
        // validation for constraint: maxExclusive
        if ($dateDliverySelling >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateDliverySelling), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateDliverySelling < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateDliverySelling), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDliverySelling) && !is_string($dateDliverySelling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDliverySelling)), __LINE__);
        }
        $this->DateDliverySelling = $dateDliverySelling;
        return $this;
    }
    /**
     * Get OrganizationSelling value
     * @return string|null
     */
    public function getOrganizationSelling()
    {
        return $this->OrganizationSelling;
    }
    /**
     * Set OrganizationSelling value
     * @param string $organizationSelling
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setOrganizationSelling($organizationSelling = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organizationSelling) && strlen($organizationSelling) > 1000) || (is_array($organizationSelling) && count($organizationSelling) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($organizationSelling) ? strlen($organizationSelling) : count($organizationSelling)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organizationSelling) && strlen($organizationSelling) < 1) || (is_array($organizationSelling) && count($organizationSelling) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organizationSelling) && !is_string($organizationSelling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organizationSelling)), __LINE__);
        }
        $this->OrganizationSelling = $organizationSelling;
        return $this;
    }
    /**
     * Get AddressOrganizationSelling value
     * @return \AisFssp\StructType\AddressType|null
     */
    public function getAddressOrganizationSelling()
    {
        return $this->AddressOrganizationSelling;
    }
    /**
     * Set AddressOrganizationSelling value
     * @param \AisFssp\StructType\AddressType $addressOrganizationSelling
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setAddressOrganizationSelling(\AisFssp\StructType\AddressType $addressOrganizationSelling = null)
    {
        $this->AddressOrganizationSelling = $addressOrganizationSelling;
        return $this;
    }
    /**
     * Get PhoneOrganizationSelling value
     * @return string|null
     */
    public function getPhoneOrganizationSelling()
    {
        return $this->PhoneOrganizationSelling;
    }
    /**
     * Set PhoneOrganizationSelling value
     * @param string $phoneOrganizationSelling
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setPhoneOrganizationSelling($phoneOrganizationSelling = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phoneOrganizationSelling) && strlen($phoneOrganizationSelling) > 25) || (is_array($phoneOrganizationSelling) && count($phoneOrganizationSelling) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($phoneOrganizationSelling) ? strlen($phoneOrganizationSelling) : count($phoneOrganizationSelling)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($phoneOrganizationSelling) && strlen($phoneOrganizationSelling) < 1) || (is_array($phoneOrganizationSelling) && count($phoneOrganizationSelling) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phoneOrganizationSelling) && !is_string($phoneOrganizationSelling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneOrganizationSelling)), __LINE__);
        }
        $this->PhoneOrganizationSelling = $phoneOrganizationSelling;
        return $this;
    }
    /**
     * Get DateSelling value
     * @return string|null
     */
    public function getDateSelling()
    {
        return $this->DateSelling;
    }
    /**
     * Set DateSelling value
     * @param string $dateSelling
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDateSelling($dateSelling = null)
    {
        // validation for constraint: maxExclusive
        if ($dateSelling >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateSelling), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateSelling < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateSelling), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateSelling) && !is_string($dateSelling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateSelling)), __LINE__);
        }
        $this->DateSelling = $dateSelling;
        return $this;
    }
    /**
     * Get AddressSelling value
     * @return \AisFssp\StructType\AddressType|null
     */
    public function getAddressSelling()
    {
        return $this->AddressSelling;
    }
    /**
     * Set AddressSelling value
     * @param \AisFssp\StructType\AddressType $addressSelling
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setAddressSelling(\AisFssp\StructType\AddressType $addressSelling = null)
    {
        $this->AddressSelling = $addressSelling;
        return $this;
    }
    /**
     * Get NameMedia value
     * @return string|null
     */
    public function getNameMedia()
    {
        return $this->NameMedia;
    }
    /**
     * Set NameMedia value
     * @param string $nameMedia
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setNameMedia($nameMedia = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nameMedia) && strlen($nameMedia) > 1000) || (is_array($nameMedia) && count($nameMedia) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($nameMedia) ? strlen($nameMedia) : count($nameMedia)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($nameMedia) && strlen($nameMedia) < 1) || (is_array($nameMedia) && count($nameMedia) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nameMedia) && !is_string($nameMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameMedia)), __LINE__);
        }
        $this->NameMedia = $nameMedia;
        return $this;
    }
    /**
     * Get DatePublication value
     * @return string|null
     */
    public function getDatePublication()
    {
        return $this->DatePublication;
    }
    /**
     * Set DatePublication value
     * @param string $datePublication
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setDatePublication($datePublication = null)
    {
        // validation for constraint: maxExclusive
        if ($datePublication >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $datePublication), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($datePublication < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $datePublication), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($datePublication) && !is_string($datePublication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datePublication)), __LINE__);
        }
        $this->DatePublication = $datePublication;
        return $this;
    }
    /**
     * Get StartingPrice value
     * @return float|null
     */
    public function getStartingPrice()
    {
        return $this->StartingPrice;
    }
    /**
     * Set StartingPrice value
     * @param float $startingPrice
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public function setStartingPrice($startingPrice = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($startingPrice) && strlen(substr($startingPrice, strpos($startingPrice, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($startingPrice, strpos($startingPrice, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($startingPrice) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $startingPrice)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($startingPrice, strpos($startingPrice, '.')))), __LINE__);
        }
        $this->StartingPrice = $startingPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ArrestRegistryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
