<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnswerAppResult StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на запрос статуса рассмотрения обращения
 * - type: tns:AnswerAppResult
 * @subpackage Structs
 */
class AnswerAppResult extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The CitizensRegistryKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор записи | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $CitizensRegistryKey;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IsAppStatus
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия статуса | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsAppStatus;
    /**
     * The ClaimerEmail
     * Meta informations extracted from the WSDL
     * - documentation: Адрес электронной почты заявителя | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ClaimerEmail;
    /**
     * The ExternalRegistrationDate
     * Meta informations extracted from the WSDL
     * - documentation: Внешняя дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ExternalRegistrationDate;
    /**
     * The InternalRegistrationNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $InternalRegistrationNumber;
    /**
     * The InternalRegistrationDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $InternalRegistrationDate;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обращения
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое сообщение | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Text;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for AnswerAppResult
     * @uses AnswerAppResult::setInternalKey()
     * @uses AnswerAppResult::setCitizensRegistryKey()
     * @uses AnswerAppResult::setExternalKey()
     * @uses AnswerAppResult::setIsAppStatus()
     * @uses AnswerAppResult::setClaimerEmail()
     * @uses AnswerAppResult::setExternalRegistrationDate()
     * @uses AnswerAppResult::setInternalRegistrationNumber()
     * @uses AnswerAppResult::setInternalRegistrationDate()
     * @uses AnswerAppResult::setStatus()
     * @uses AnswerAppResult::setText()
     * @uses AnswerAppResult::setId()
     * @param int $internalKey
     * @param int $citizensRegistryKey
     * @param string $externalKey
     * @param bool $isAppStatus
     * @param string $claimerEmail
     * @param string $externalRegistrationDate
     * @param string $internalRegistrationNumber
     * @param string $internalRegistrationDate
     * @param string $status
     * @param string $text
     * @param string $id
     */
    public function __construct($internalKey = null, $citizensRegistryKey = null, $externalKey = null, $isAppStatus = null, $claimerEmail = null, $externalRegistrationDate = null, $internalRegistrationNumber = null, $internalRegistrationDate = null, $status = null, $text = null, $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setCitizensRegistryKey($citizensRegistryKey)
            ->setExternalKey($externalKey)
            ->setIsAppStatus($isAppStatus)
            ->setClaimerEmail($claimerEmail)
            ->setExternalRegistrationDate($externalRegistrationDate)
            ->setInternalRegistrationNumber($internalRegistrationNumber)
            ->setInternalRegistrationDate($internalRegistrationDate)
            ->setStatus($status)
            ->setText($text)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get CitizensRegistryKey value
     * @return int|null
     */
    public function getCitizensRegistryKey()
    {
        return $this->CitizensRegistryKey;
    }
    /**
     * Set CitizensRegistryKey value
     * @param int $citizensRegistryKey
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setCitizensRegistryKey($citizensRegistryKey = null)
    {
        // validation for constraint: maxInclusive
        if ($citizensRegistryKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $citizensRegistryKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($citizensRegistryKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $citizensRegistryKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($citizensRegistryKey) && !is_numeric($citizensRegistryKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($citizensRegistryKey)), __LINE__);
        }
        $this->CitizensRegistryKey = $citizensRegistryKey;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IsAppStatus value
     * @return bool|null
     */
    public function getIsAppStatus()
    {
        return $this->IsAppStatus;
    }
    /**
     * Set IsAppStatus value
     * @param bool $isAppStatus
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setIsAppStatus($isAppStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAppStatus) && !is_bool($isAppStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAppStatus)), __LINE__);
        }
        $this->IsAppStatus = $isAppStatus;
        return $this;
    }
    /**
     * Get ClaimerEmail value
     * @return string|null
     */
    public function getClaimerEmail()
    {
        return $this->ClaimerEmail;
    }
    /**
     * Set ClaimerEmail value
     * @param string $claimerEmail
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setClaimerEmail($claimerEmail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($claimerEmail) && strlen($claimerEmail) > 100) || (is_array($claimerEmail) && count($claimerEmail) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($claimerEmail) ? strlen($claimerEmail) : count($claimerEmail)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($claimerEmail) && strlen($claimerEmail) < 1) || (is_array($claimerEmail) && count($claimerEmail) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($claimerEmail) && !is_string($claimerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($claimerEmail)), __LINE__);
        }
        $this->ClaimerEmail = $claimerEmail;
        return $this;
    }
    /**
     * Get ExternalRegistrationDate value
     * @return string|null
     */
    public function getExternalRegistrationDate()
    {
        return $this->ExternalRegistrationDate;
    }
    /**
     * Set ExternalRegistrationDate value
     * @param string $externalRegistrationDate
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setExternalRegistrationDate($externalRegistrationDate = null)
    {
        // validation for constraint: maxExclusive
        if ($externalRegistrationDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $externalRegistrationDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($externalRegistrationDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $externalRegistrationDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalRegistrationDate) && !is_string($externalRegistrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalRegistrationDate)), __LINE__);
        }
        $this->ExternalRegistrationDate = $externalRegistrationDate;
        return $this;
    }
    /**
     * Get InternalRegistrationNumber value
     * @return string|null
     */
    public function getInternalRegistrationNumber()
    {
        return $this->InternalRegistrationNumber;
    }
    /**
     * Set InternalRegistrationNumber value
     * @param string $internalRegistrationNumber
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setInternalRegistrationNumber($internalRegistrationNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($internalRegistrationNumber) && strlen($internalRegistrationNumber) > 25) || (is_array($internalRegistrationNumber) && count($internalRegistrationNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($internalRegistrationNumber) ? strlen($internalRegistrationNumber) : count($internalRegistrationNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($internalRegistrationNumber) && strlen($internalRegistrationNumber) < 1) || (is_array($internalRegistrationNumber) && count($internalRegistrationNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($internalRegistrationNumber) && !is_string($internalRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalRegistrationNumber)), __LINE__);
        }
        $this->InternalRegistrationNumber = $internalRegistrationNumber;
        return $this;
    }
    /**
     * Get InternalRegistrationDate value
     * @return string|null
     */
    public function getInternalRegistrationDate()
    {
        return $this->InternalRegistrationDate;
    }
    /**
     * Set InternalRegistrationDate value
     * @param string $internalRegistrationDate
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setInternalRegistrationDate($internalRegistrationDate = null)
    {
        // validation for constraint: maxExclusive
        if ($internalRegistrationDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $internalRegistrationDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalRegistrationDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $internalRegistrationDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($internalRegistrationDate) && !is_string($internalRegistrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalRegistrationDate)), __LINE__);
        }
        $this->InternalRegistrationDate = $internalRegistrationDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \AisFssp\EnumType\ApplicationStatus::valueIsValid()
     * @uses \AisFssp\EnumType\ApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ApplicationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \AisFssp\EnumType\ApplicationStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setText($text = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($text) && strlen($text) > 1000) || (is_array($text) && count($text) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($text) ? strlen($text) : count($text)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($text) && strlen($text) < 1) || (is_array($text) && count($text) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AnswerAppResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
