<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений AccountingDataType "Бухгалтерская отчетность"
 * @subpackage Structs
 */
class AccountingDataType extends InformationType
{
    /**
     * The PeriodText
     * Meta informations extracted from the WSDL
     * - documentation: Отчетный период | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $PeriodText;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - documentation: Состояние счета | Множество элементов, описывающих счета баланса
     * - maxOccurs: unbounded
     * @var \AisFssp\StructType\AccountType[]
     */
    public $Account;
    /**
     * Constructor method for AccountingDataType
     * @uses AccountingDataType::setPeriodText()
     * @uses AccountingDataType::setAccount()
     * @param string $periodText
     * @param \AisFssp\StructType\AccountType[] $account
     */
    public function __construct($periodText = null, array $account = array())
    {
        $this
            ->setPeriodText($periodText)
            ->setAccount($account);
    }
    /**
     * Get PeriodText value
     * @return string|null
     */
    public function getPeriodText()
    {
        return $this->PeriodText;
    }
    /**
     * Set PeriodText value
     * @param string $periodText
     * @return \AisFssp\StructType\AccountingDataType
     */
    public function setPeriodText($periodText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($periodText) && strlen($periodText) > 100) || (is_array($periodText) && count($periodText) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($periodText) ? strlen($periodText) : count($periodText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($periodText) && strlen($periodText) < 1) || (is_array($periodText) && count($periodText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($periodText) && !is_string($periodText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodText)), __LINE__);
        }
        $this->PeriodText = $periodText;
        return $this;
    }
    /**
     * Get Account value
     * @return \AisFssp\StructType\AccountType[]|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AccountType[] $account
     * @return \AisFssp\StructType\AccountingDataType
     */
    public function setAccount(array $account = array())
    {
        foreach ($account as $accountingDataTypeAccountItem) {
            // validation for constraint: itemType
            if (!$accountingDataTypeAccountItem instanceof \AisFssp\StructType\AccountType) {
                throw new \InvalidArgumentException(sprintf('The Account property can only contain items of \AisFssp\StructType\AccountType, "%s" given', is_object($accountingDataTypeAccountItem) ? get_class($accountingDataTypeAccountItem) : gettype($accountingDataTypeAccountItem)), __LINE__);
            }
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Add item to Account value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AccountType $item
     * @return \AisFssp\StructType\AccountingDataType
     */
    public function addToAccount(\AisFssp\StructType\AccountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AccountType) {
            throw new \InvalidArgumentException(sprintf('The Account property can only contain items of \AisFssp\StructType\AccountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Account[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AccountingDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
