<?php

namespace AisFssp\EnumType;

/**
 * This class stands for RegistryType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип реестра, передаваемого из ПКОСП в МВВ
 * @subpackage Enumerations
 */
class RegistryType
{
    /**
     * Constant for value 'UIN'
     * @return string 'UIN'
     */
    const VALUE_UIN = 'UIN';
    /**
     * Constant for value 'TS'
     * @return string 'TS'
     */
    const VALUE_TS = 'TS';
    /**
     * Constant for value 'IP_DOC'
     * @return string 'IP_DOC'
     */
    const VALUE_IP_DOC = 'IP_DOC';
    /**
     * Constant for value 'IP_CALC'
     * @return string 'IP_CALC'
     */
    const VALUE_IP_CALC = 'IP_CALC';
    /**
     * Constant for value 'DEBT_TEL'
     * @return string 'DEBT_TEL'
     */
    const VALUE_DEBT_TEL = 'DEBT_TEL';
    /**
     * Constant for value 'IP_BKI'
     * @return string 'IP_BKI'
     */
    const VALUE_IP_BKI = 'IP_BKI';
    /**
     * Constant for value 'CTZ_REG'
     * @return string 'CTZ_REG'
     */
    const VALUE_CTZ_REG = 'CTZ_REG';
    /**
     * Constant for value 'CTZ_QST'
     * @return string 'CTZ_QST'
     */
    const VALUE_CTZ_QST = 'CTZ_QST';
    /**
     * Constant for value 'TRUSTEE'
     * @return string 'TRUSTEE'
     */
    const VALUE_TRUSTEE = 'TRUSTEE';
    /**
     * Constant for value 'GUN'
     * @return string 'GUN'
     */
    const VALUE_GUN = 'GUN';
    /**
     * Constant for value 'IP_OLD_REGNUMBER'
     * @return string 'IP_OLD_REGNUMBER'
     */
    const VALUE_IP_OLD_REGNUMBER = 'IP_OLD_REGNUMBER';
    /**
     * Constant for value 'GSPTO_ACT_TRAN'
     * @return string 'GSPTO_ACT_TRAN'
     */
    const VALUE_GSPTO_ACT_TRAN = 'GSPTO_ACT_TRAN';
    /**
     * Constant for value 'EXCLUDED_DEBTORS'
     * @return string 'EXCLUDED_DEBTORS'
     */
    const VALUE_EXCLUDED_DEBTORS = 'EXCLUDED_DEBTORS';
    /**
     * Constant for value 'IP_BITMASK'
     * @return string 'IP_BITMASK'
     */
    const VALUE_IP_BITMASK = 'IP_BITMASK';
    /**
     * Constant for value 'PENALTY'
     * @return string 'PENALTY'
     */
    const VALUE_PENALTY = 'PENALTY';
    /**
     * Constant for value 'BUDGET_RECEIPTS'
     * @return string 'BUDGET_RECEIPTS'
     */
    const VALUE_BUDGET_RECEIPTS = 'BUDGET_RECEIPTS';
    /**
     * Constant for value 'PROPERTY_REESTR'
     * @return string 'PROPERTY_REESTR'
     */
    const VALUE_PROPERTY_REESTR = 'PROPERTY_REESTR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UIN
     * @uses self::VALUE_TS
     * @uses self::VALUE_IP_DOC
     * @uses self::VALUE_IP_CALC
     * @uses self::VALUE_DEBT_TEL
     * @uses self::VALUE_IP_BKI
     * @uses self::VALUE_CTZ_REG
     * @uses self::VALUE_CTZ_QST
     * @uses self::VALUE_TRUSTEE
     * @uses self::VALUE_GUN
     * @uses self::VALUE_IP_OLD_REGNUMBER
     * @uses self::VALUE_GSPTO_ACT_TRAN
     * @uses self::VALUE_EXCLUDED_DEBTORS
     * @uses self::VALUE_IP_BITMASK
     * @uses self::VALUE_PENALTY
     * @uses self::VALUE_BUDGET_RECEIPTS
     * @uses self::VALUE_PROPERTY_REESTR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UIN,
            self::VALUE_TS,
            self::VALUE_IP_DOC,
            self::VALUE_IP_CALC,
            self::VALUE_DEBT_TEL,
            self::VALUE_IP_BKI,
            self::VALUE_CTZ_REG,
            self::VALUE_CTZ_QST,
            self::VALUE_TRUSTEE,
            self::VALUE_GUN,
            self::VALUE_IP_OLD_REGNUMBER,
            self::VALUE_GSPTO_ACT_TRAN,
            self::VALUE_EXCLUDED_DEBTORS,
            self::VALUE_IP_BITMASK,
            self::VALUE_PENALTY,
            self::VALUE_BUDGET_RECEIPTS,
            self::VALUE_PROPERTY_REESTR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
