<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithheldDetailType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о произведенных удержаниях
 * @subpackage Structs
 */
class WithheldDetailType extends AbstractStructBase
{
    /**
     * The WithheldType
     * Meta informations extracted from the WSDL
     * - documentation: Тип удержания
     * @var string
     */
    public $WithheldType;
    /**
     * The WithheldAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $WithheldAmount;
    /**
     * Constructor method for WithheldDetailType
     * @uses WithheldDetailType::setWithheldType()
     * @uses WithheldDetailType::setWithheldAmount()
     * @param string $withheldType
     * @param float $withheldAmount
     */
    public function __construct($withheldType = null, $withheldAmount = null)
    {
        $this
            ->setWithheldType($withheldType)
            ->setWithheldAmount($withheldAmount);
    }
    /**
     * Get WithheldType value
     * @return string|null
     */
    public function getWithheldType()
    {
        return $this->WithheldType;
    }
    /**
     * Set WithheldType value
     * @uses \AisFssp\EnumType\WithheldCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\WithheldCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withheldType
     * @return \AisFssp\StructType\WithheldDetailType
     */
    public function setWithheldType($withheldType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\WithheldCodeType::valueIsValid($withheldType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withheldType, implode(', ', \AisFssp\EnumType\WithheldCodeType::getValidValues())), __LINE__);
        }
        $this->WithheldType = $withheldType;
        return $this;
    }
    /**
     * Get WithheldAmount value
     * @return float|null
     */
    public function getWithheldAmount()
    {
        return $this->WithheldAmount;
    }
    /**
     * Set WithheldAmount value
     * @param float $withheldAmount
     * @return \AisFssp\StructType\WithheldDetailType
     */
    public function setWithheldAmount($withheldAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($withheldAmount) && strlen(substr($withheldAmount, strpos($withheldAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($withheldAmount, strpos($withheldAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($withheldAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $withheldAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($withheldAmount, strpos($withheldAmount, '.')))), __LINE__);
        }
        $this->WithheldAmount = $withheldAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\WithheldDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
