<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UINRegistry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ для передачи реестра УИН
 * - type: tns:UINRegistry
 * @subpackage Structs
 */
class UINRegistry extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocVersion
     * Meta informations extracted from the WSDL
     * - documentation: Версия документа | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $DocVersion;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * Constructor method for UINRegistry
     * @uses UINRegistry::setInternalKey()
     * @uses UINRegistry::setDocDate()
     * @uses UINRegistry::setDocVersion()
     * @uses UINRegistry::setUnloadDate()
     * @uses UINRegistry::setOspCode()
     * @param int $internalKey
     * @param string $docDate
     * @param int $docVersion
     * @param string $unloadDate
     * @param string $ospCode
     */
    public function __construct($internalKey = null, $docDate = null, $docVersion = null, $unloadDate = null, $ospCode = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setDocDate($docDate)
            ->setDocVersion($docVersion)
            ->setUnloadDate($unloadDate)
            ->setOspCode($ospCode);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\UINRegistry
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\UINRegistry
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocVersion value
     * @return int|null
     */
    public function getDocVersion()
    {
        return $this->DocVersion;
    }
    /**
     * Set DocVersion value
     * @param int $docVersion
     * @return \AisFssp\StructType\UINRegistry
     */
    public function setDocVersion($docVersion = null)
    {
        // validation for constraint: maxInclusive
        if ($docVersion > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $docVersion), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($docVersion) && !is_numeric($docVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($docVersion)), __LINE__);
        }
        $this->DocVersion = $docVersion;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \AisFssp\StructType\UINRegistry
     */
    public function setUnloadDate($unloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unloadDate) && !is_string($unloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unloadDate)), __LINE__);
        }
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\UINRegistry
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\UINRegistry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
