<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений TicketDatumType "Сведения о передвижении"
 * @subpackage Structs
 */
class TicketDatumType extends InformationType
{
    /**
     * The TicketDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время продажи билета | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $TicketDate;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выбытия должника из пункта назначения | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время прибытия должника в пункт назначения | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DepartureStation
     * Meta informations extracted from the WSDL
     * - documentation: Пункт отправления | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DepartureStation;
    /**
     * The DestinationStation
     * Meta informations extracted from the WSDL
     * - documentation: Пункт назначения | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DestinationStation;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Контактный номер телефона | Номер телефона
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $TelephoneNumber;
    /**
     * Constructor method for TicketDatumType
     * @uses TicketDatumType::setTicketDate()
     * @uses TicketDatumType::setDepartureDate()
     * @uses TicketDatumType::setArrivalDate()
     * @uses TicketDatumType::setDepartureStation()
     * @uses TicketDatumType::setDestinationStation()
     * @uses TicketDatumType::setTelephoneNumber()
     * @param string $ticketDate
     * @param string $departureDate
     * @param string $arrivalDate
     * @param string $departureStation
     * @param string $destinationStation
     * @param string $telephoneNumber
     */
    public function __construct($ticketDate = null, $departureDate = null, $arrivalDate = null, $departureStation = null, $destinationStation = null, $telephoneNumber = null)
    {
        $this
            ->setTicketDate($ticketDate)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setDepartureStation($departureStation)
            ->setDestinationStation($destinationStation)
            ->setTelephoneNumber($telephoneNumber);
    }
    /**
     * Get TicketDate value
     * @return string|null
     */
    public function getTicketDate()
    {
        return $this->TicketDate;
    }
    /**
     * Set TicketDate value
     * @param string $ticketDate
     * @return \AisFssp\StructType\TicketDatumType
     */
    public function setTicketDate($ticketDate = null)
    {
        // validation for constraint: maxExclusive
        if ($ticketDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $ticketDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ticketDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $ticketDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ticketDate) && !is_string($ticketDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketDate)), __LINE__);
        }
        $this->TicketDate = $ticketDate;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \AisFssp\StructType\TicketDatumType
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: maxExclusive
        if ($departureDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $departureDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($departureDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $departureDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \AisFssp\StructType\TicketDatumType
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: maxExclusive
        if ($arrivalDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $arrivalDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($arrivalDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $arrivalDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DepartureStation value
     * @return string|null
     */
    public function getDepartureStation()
    {
        return $this->DepartureStation;
    }
    /**
     * Set DepartureStation value
     * @param string $departureStation
     * @return \AisFssp\StructType\TicketDatumType
     */
    public function setDepartureStation($departureStation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($departureStation) && strlen($departureStation) > 100) || (is_array($departureStation) && count($departureStation) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($departureStation) ? strlen($departureStation) : count($departureStation)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($departureStation) && strlen($departureStation) < 1) || (is_array($departureStation) && count($departureStation) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($departureStation) && !is_string($departureStation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureStation)), __LINE__);
        }
        $this->DepartureStation = $departureStation;
        return $this;
    }
    /**
     * Get DestinationStation value
     * @return string|null
     */
    public function getDestinationStation()
    {
        return $this->DestinationStation;
    }
    /**
     * Set DestinationStation value
     * @param string $destinationStation
     * @return \AisFssp\StructType\TicketDatumType
     */
    public function setDestinationStation($destinationStation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destinationStation) && strlen($destinationStation) > 100) || (is_array($destinationStation) && count($destinationStation) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($destinationStation) ? strlen($destinationStation) : count($destinationStation)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($destinationStation) && strlen($destinationStation) < 1) || (is_array($destinationStation) && count($destinationStation) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destinationStation) && !is_string($destinationStation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationStation)), __LINE__);
        }
        $this->DestinationStation = $destinationStation;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * Set TelephoneNumber value
     * @param string $telephoneNumber
     * @return \AisFssp\StructType\TicketDatumType
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telephoneNumber) && strlen($telephoneNumber) > 25) || (is_array($telephoneNumber) && count($telephoneNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($telephoneNumber) ? strlen($telephoneNumber) : count($telephoneNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($telephoneNumber) && strlen($telephoneNumber) < 1) || (is_array($telephoneNumber) && count($telephoneNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\TicketDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
