<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvObjectType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об объекте недвижимости
 * @subpackage Structs
 */
class SvedNedvObjectType extends InformationType
{
    /**
     * The cadastralNumber
     * Meta informations extracted from the WSDL
     * - documentation: Кадастровый номер объекта недвижимого имущества | Строка длиной от 1 до 500 символов
     * - minOccurs: 0
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $cadastralNumber;
    /**
     * The conditionalNumber
     * Meta informations extracted from the WSDL
     * - documentation: Условный номер | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $conditionalNumber;
    /**
     * The objectTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код типа объекта недвижимости | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $objectTypeCode;
    /**
     * The objectTypeText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание типа объекта недвижимости | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $objectTypeText;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование объекта недвижимости | Строка длиной от 1 до 4000 символов
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The assignationCode
     * Meta informations extracted from the WSDL
     * - documentation: Код назначения | По классификатору «Классификатор назначений объектов технического учета» | Строка длиной от 1 до 12 символов
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $assignationCode;
    /**
     * The assignationName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование назначения | Из «Классификатора назначений объектов технического учета» | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $assignationName;
    /**
     * The assignationText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание назначения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $assignationText;
    /**
     * The groundCategoryCode
     * Meta informations extracted from the WSDL
     * - documentation: Целевое назначение (категория) земель | По классификатору «Категории земель» | Строка длиной от 1 до 12 символов
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $groundCategoryCode;
    /**
     * The groundCategoryText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание целевого назначения(категории) земель | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $groundCategoryText;
    /**
     * The area
     * Meta informations extracted from the WSDL
     * - documentation: Площади
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\SvedNedvAreaType[]
     */
    public $area;
    /**
     * Constructor method for SvedNedvObjectType
     * @uses SvedNedvObjectType::setCadastralNumber()
     * @uses SvedNedvObjectType::setConditionalNumber()
     * @uses SvedNedvObjectType::setObjectTypeCode()
     * @uses SvedNedvObjectType::setObjectTypeText()
     * @uses SvedNedvObjectType::setName()
     * @uses SvedNedvObjectType::setAssignationCode()
     * @uses SvedNedvObjectType::setAssignationName()
     * @uses SvedNedvObjectType::setAssignationText()
     * @uses SvedNedvObjectType::setGroundCategoryCode()
     * @uses SvedNedvObjectType::setGroundCategoryText()
     * @uses SvedNedvObjectType::setArea()
     * @param string $cadastralNumber
     * @param string $conditionalNumber
     * @param string $objectTypeCode
     * @param string $objectTypeText
     * @param string $name
     * @param string $assignationCode
     * @param string $assignationName
     * @param string $assignationText
     * @param string $groundCategoryCode
     * @param string $groundCategoryText
     * @param \AisFssp\StructType\SvedNedvAreaType[] $area
     */
    public function __construct($cadastralNumber = null, $conditionalNumber = null, $objectTypeCode = null, $objectTypeText = null, $name = null, $assignationCode = null, $assignationName = null, $assignationText = null, $groundCategoryCode = null, $groundCategoryText = null, array $area = array())
    {
        $this
            ->setCadastralNumber($cadastralNumber)
            ->setConditionalNumber($conditionalNumber)
            ->setObjectTypeCode($objectTypeCode)
            ->setObjectTypeText($objectTypeText)
            ->setName($name)
            ->setAssignationCode($assignationCode)
            ->setAssignationName($assignationName)
            ->setAssignationText($assignationText)
            ->setGroundCategoryCode($groundCategoryCode)
            ->setGroundCategoryText($groundCategoryText)
            ->setArea($area);
    }
    /**
     * Get cadastralNumber value
     * @return string|null
     */
    public function getCadastralNumber()
    {
        return $this->cadastralNumber;
    }
    /**
     * Set cadastralNumber value
     * @param string $cadastralNumber
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setCadastralNumber($cadastralNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cadastralNumber) && strlen($cadastralNumber) > 500) || (is_array($cadastralNumber) && count($cadastralNumber) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($cadastralNumber) ? strlen($cadastralNumber) : count($cadastralNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cadastralNumber) && strlen($cadastralNumber) < 1) || (is_array($cadastralNumber) && count($cadastralNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cadastralNumber) && !is_string($cadastralNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cadastralNumber)), __LINE__);
        }
        $this->cadastralNumber = $cadastralNumber;
        return $this;
    }
    /**
     * Get conditionalNumber value
     * @return string|null
     */
    public function getConditionalNumber()
    {
        return $this->conditionalNumber;
    }
    /**
     * Set conditionalNumber value
     * @param string $conditionalNumber
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setConditionalNumber($conditionalNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($conditionalNumber) && strlen($conditionalNumber) > 100) || (is_array($conditionalNumber) && count($conditionalNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($conditionalNumber) ? strlen($conditionalNumber) : count($conditionalNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($conditionalNumber) && strlen($conditionalNumber) < 1) || (is_array($conditionalNumber) && count($conditionalNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($conditionalNumber) && !is_string($conditionalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conditionalNumber)), __LINE__);
        }
        $this->conditionalNumber = $conditionalNumber;
        return $this;
    }
    /**
     * Get objectTypeCode value
     * @return string|null
     */
    public function getObjectTypeCode()
    {
        return $this->objectTypeCode;
    }
    /**
     * Set objectTypeCode value
     * @param string $objectTypeCode
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setObjectTypeCode($objectTypeCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($objectTypeCode) && strlen($objectTypeCode) > 255) || (is_array($objectTypeCode) && count($objectTypeCode) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($objectTypeCode) ? strlen($objectTypeCode) : count($objectTypeCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($objectTypeCode) && strlen($objectTypeCode) < 1) || (is_array($objectTypeCode) && count($objectTypeCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectTypeCode) && !is_string($objectTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectTypeCode)), __LINE__);
        }
        $this->objectTypeCode = $objectTypeCode;
        return $this;
    }
    /**
     * Get objectTypeText value
     * @return string|null
     */
    public function getObjectTypeText()
    {
        return $this->objectTypeText;
    }
    /**
     * Set objectTypeText value
     * @param string $objectTypeText
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setObjectTypeText($objectTypeText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($objectTypeText) && strlen($objectTypeText) > 1000) || (is_array($objectTypeText) && count($objectTypeText) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($objectTypeText) ? strlen($objectTypeText) : count($objectTypeText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($objectTypeText) && strlen($objectTypeText) < 1) || (is_array($objectTypeText) && count($objectTypeText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectTypeText) && !is_string($objectTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectTypeText)), __LINE__);
        }
        $this->objectTypeText = $objectTypeText;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 4000) || (is_array($name) && count($name) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get assignationCode value
     * @return string|null
     */
    public function getAssignationCode()
    {
        return $this->assignationCode;
    }
    /**
     * Set assignationCode value
     * @param string $assignationCode
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setAssignationCode($assignationCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($assignationCode) && strlen($assignationCode) > 12) || (is_array($assignationCode) && count($assignationCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($assignationCode) ? strlen($assignationCode) : count($assignationCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($assignationCode) && strlen($assignationCode) < 1) || (is_array($assignationCode) && count($assignationCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($assignationCode) && !is_string($assignationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignationCode)), __LINE__);
        }
        $this->assignationCode = $assignationCode;
        return $this;
    }
    /**
     * Get assignationName value
     * @return string|null
     */
    public function getAssignationName()
    {
        return $this->assignationName;
    }
    /**
     * Set assignationName value
     * @param string $assignationName
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setAssignationName($assignationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($assignationName) && strlen($assignationName) > 50) || (is_array($assignationName) && count($assignationName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($assignationName) ? strlen($assignationName) : count($assignationName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($assignationName) && strlen($assignationName) < 1) || (is_array($assignationName) && count($assignationName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($assignationName) && !is_string($assignationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignationName)), __LINE__);
        }
        $this->assignationName = $assignationName;
        return $this;
    }
    /**
     * Get assignationText value
     * @return string|null
     */
    public function getAssignationText()
    {
        return $this->assignationText;
    }
    /**
     * Set assignationText value
     * @param string $assignationText
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setAssignationText($assignationText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($assignationText) && strlen($assignationText) > 1000) || (is_array($assignationText) && count($assignationText) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($assignationText) ? strlen($assignationText) : count($assignationText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($assignationText) && strlen($assignationText) < 1) || (is_array($assignationText) && count($assignationText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($assignationText) && !is_string($assignationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignationText)), __LINE__);
        }
        $this->assignationText = $assignationText;
        return $this;
    }
    /**
     * Get groundCategoryCode value
     * @return string|null
     */
    public function getGroundCategoryCode()
    {
        return $this->groundCategoryCode;
    }
    /**
     * Set groundCategoryCode value
     * @param string $groundCategoryCode
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setGroundCategoryCode($groundCategoryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($groundCategoryCode) && strlen($groundCategoryCode) > 12) || (is_array($groundCategoryCode) && count($groundCategoryCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($groundCategoryCode) ? strlen($groundCategoryCode) : count($groundCategoryCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($groundCategoryCode) && strlen($groundCategoryCode) < 1) || (is_array($groundCategoryCode) && count($groundCategoryCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groundCategoryCode) && !is_string($groundCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groundCategoryCode)), __LINE__);
        }
        $this->groundCategoryCode = $groundCategoryCode;
        return $this;
    }
    /**
     * Get groundCategoryText value
     * @return string|null
     */
    public function getGroundCategoryText()
    {
        return $this->groundCategoryText;
    }
    /**
     * Set groundCategoryText value
     * @param string $groundCategoryText
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setGroundCategoryText($groundCategoryText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($groundCategoryText) && strlen($groundCategoryText) > 1000) || (is_array($groundCategoryText) && count($groundCategoryText) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($groundCategoryText) ? strlen($groundCategoryText) : count($groundCategoryText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($groundCategoryText) && strlen($groundCategoryText) < 1) || (is_array($groundCategoryText) && count($groundCategoryText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groundCategoryText) && !is_string($groundCategoryText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groundCategoryText)), __LINE__);
        }
        $this->groundCategoryText = $groundCategoryText;
        return $this;
    }
    /**
     * Get area value
     * @return \AisFssp\StructType\SvedNedvAreaType[]|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SvedNedvAreaType[] $area
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function setArea(array $area = array())
    {
        foreach ($area as $svedNedvObjectTypeAreaItem) {
            // validation for constraint: itemType
            if (!$svedNedvObjectTypeAreaItem instanceof \AisFssp\StructType\SvedNedvAreaType) {
                throw new \InvalidArgumentException(sprintf('The area property can only contain items of \AisFssp\StructType\SvedNedvAreaType, "%s" given', is_object($svedNedvObjectTypeAreaItem) ? get_class($svedNedvObjectTypeAreaItem) : gettype($svedNedvObjectTypeAreaItem)), __LINE__);
            }
        }
        $this->area = $area;
        return $this;
    }
    /**
     * Add item to area value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SvedNedvAreaType $item
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public function addToArea(\AisFssp\StructType\SvedNedvAreaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SvedNedvAreaType) {
            throw new \InvalidArgumentException(sprintf('The area property can only contain items of \AisFssp\StructType\SvedNedvAreaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->area[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SvedNedvObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
