<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvEncumbranceType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об обременениях
 * @subpackage Structs
 */
class SvedNedvEncumbranceType extends InformationType
{
    /**
     * The encCode
     * Meta informations extracted from the WSDL
     * - documentation: Код обременения | Код по справочнику «Виды Обременения (ограничения)» | Строка длиной от 1 до 12 символов
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $encCode;
    /**
     * The encText
     * Meta informations extracted from the WSDL
     * - documentation: Текст обременения | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $encText;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер государствеенной регистрации | Строка длиной от 1 до 45 символов
     * - maxLength: 45
     * - minLength: 1
     * @var string
     */
    public $regNumber;
    /**
     * The regDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата государственной регистрации | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $regDate;
    /**
     * The durationStart
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $durationStart;
    /**
     * The durationFin
     * Meta informations extracted from the WSDL
     * - documentation: Дата прекращения действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $durationFin;
    /**
     * The durationTerm
     * Meta informations extracted from the WSDL
     * - documentation: Продолжительность | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $durationTerm;
    /**
     * Constructor method for SvedNedvEncumbranceType
     * @uses SvedNedvEncumbranceType::setEncCode()
     * @uses SvedNedvEncumbranceType::setEncText()
     * @uses SvedNedvEncumbranceType::setRegNumber()
     * @uses SvedNedvEncumbranceType::setRegDate()
     * @uses SvedNedvEncumbranceType::setDurationStart()
     * @uses SvedNedvEncumbranceType::setDurationFin()
     * @uses SvedNedvEncumbranceType::setDurationTerm()
     * @param string $encCode
     * @param string $encText
     * @param string $regNumber
     * @param string $regDate
     * @param string $durationStart
     * @param string $durationFin
     * @param string $durationTerm
     */
    public function __construct($encCode = null, $encText = null, $regNumber = null, $regDate = null, $durationStart = null, $durationFin = null, $durationTerm = null)
    {
        $this
            ->setEncCode($encCode)
            ->setEncText($encText)
            ->setRegNumber($regNumber)
            ->setRegDate($regDate)
            ->setDurationStart($durationStart)
            ->setDurationFin($durationFin)
            ->setDurationTerm($durationTerm);
    }
    /**
     * Get encCode value
     * @return string|null
     */
    public function getEncCode()
    {
        return $this->encCode;
    }
    /**
     * Set encCode value
     * @param string $encCode
     * @return \AisFssp\StructType\SvedNedvEncumbranceType
     */
    public function setEncCode($encCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($encCode) && strlen($encCode) > 12) || (is_array($encCode) && count($encCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($encCode) ? strlen($encCode) : count($encCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($encCode) && strlen($encCode) < 1) || (is_array($encCode) && count($encCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($encCode) && !is_string($encCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encCode)), __LINE__);
        }
        $this->encCode = $encCode;
        return $this;
    }
    /**
     * Get encText value
     * @return string|null
     */
    public function getEncText()
    {
        return $this->encText;
    }
    /**
     * Set encText value
     * @param string $encText
     * @return \AisFssp\StructType\SvedNedvEncumbranceType
     */
    public function setEncText($encText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($encText) && strlen($encText) > 255) || (is_array($encText) && count($encText) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($encText) ? strlen($encText) : count($encText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($encText) && strlen($encText) < 1) || (is_array($encText) && count($encText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($encText) && !is_string($encText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encText)), __LINE__);
        }
        $this->encText = $encText;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \AisFssp\StructType\SvedNedvEncumbranceType
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNumber) && strlen($regNumber) > 45) || (is_array($regNumber) && count($regNumber) > 45)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 45 element(s) or a scalar of 45 character(s) at most, "%d" length given', is_scalar($regNumber) ? strlen($regNumber) : count($regNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regNumber) && strlen($regNumber) < 1) || (is_array($regNumber) && count($regNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNumber)), __LINE__);
        }
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get regDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->regDate;
    }
    /**
     * Set regDate value
     * @param string $regDate
     * @return \AisFssp\StructType\SvedNedvEncumbranceType
     */
    public function setRegDate($regDate = null)
    {
        // validation for constraint: maxExclusive
        if ($regDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($regDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDate) && !is_string($regDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDate)), __LINE__);
        }
        $this->regDate = $regDate;
        return $this;
    }
    /**
     * Get durationStart value
     * @return string|null
     */
    public function getDurationStart()
    {
        return $this->durationStart;
    }
    /**
     * Set durationStart value
     * @param string $durationStart
     * @return \AisFssp\StructType\SvedNedvEncumbranceType
     */
    public function setDurationStart($durationStart = null)
    {
        // validation for constraint: maxExclusive
        if ($durationStart >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $durationStart), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($durationStart < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $durationStart), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($durationStart) && !is_string($durationStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($durationStart)), __LINE__);
        }
        $this->durationStart = $durationStart;
        return $this;
    }
    /**
     * Get durationFin value
     * @return string|null
     */
    public function getDurationFin()
    {
        return $this->durationFin;
    }
    /**
     * Set durationFin value
     * @param string $durationFin
     * @return \AisFssp\StructType\SvedNedvEncumbranceType
     */
    public function setDurationFin($durationFin = null)
    {
        // validation for constraint: maxExclusive
        if ($durationFin >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $durationFin), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($durationFin < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $durationFin), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($durationFin) && !is_string($durationFin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($durationFin)), __LINE__);
        }
        $this->durationFin = $durationFin;
        return $this;
    }
    /**
     * Get durationTerm value
     * @return string|null
     */
    public function getDurationTerm()
    {
        return $this->durationTerm;
    }
    /**
     * Set durationTerm value
     * @param string $durationTerm
     * @return \AisFssp\StructType\SvedNedvEncumbranceType
     */
    public function setDurationTerm($durationTerm = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($durationTerm) && strlen($durationTerm) > 100) || (is_array($durationTerm) && count($durationTerm) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($durationTerm) ? strlen($durationTerm) : count($durationTerm)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($durationTerm) && strlen($durationTerm) < 1) || (is_array($durationTerm) && count($durationTerm) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($durationTerm) && !is_string($durationTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($durationTerm)), __LINE__);
        }
        $this->durationTerm = $durationTerm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SvedNedvEncumbranceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
