<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений SvedNedvDataType "Сведения о недвижимости"
 * @subpackage Structs
 */
class SvedNedvDataType extends InformationType
{
    /**
     * The NaimNedv
     * Meta informations extracted from the WSDL
     * - documentation: Наименование объекта недвижимости | Строка длиной от 1 до 4000 символов
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $NaimNedv;
    /**
     * The ObjectTypeText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание типа объекта недвижимости | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ObjectTypeText;
    /**
     * The KadastrN
     * Meta informations extracted from the WSDL
     * - documentation: Кадастровый номер | Строка длиной от 1 до 500 символов
     * - minOccurs: 0
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $KadastrN;
    /**
     * The ConditionalNumber
     * Meta informations extracted from the WSDL
     * - documentation: Условный номер | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ConditionalNumber;
    /**
     * The ObjectTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код типа объекта недвижимости | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $ObjectTypeCode;
    /**
     * The AdresNedv
     * Meta informations extracted from the WSDL
     * - documentation: Точный адрес (местоположение) | Строка длиной от 1 до 1500 символов
     * - maxLength: 1500
     * - minLength: 1
     * @var string
     */
    public $AdresNedv;
    /**
     * The AddressParts
     * Meta informations extracted from the WSDL
     * - documentation: Адрес объекта
     * - minOccurs: 0
     * @var \AisFssp\StructType\AddressType
     */
    public $AddressParts;
    /**
     * The SNedv
     * Meta informations extracted from the WSDL
     * - documentation: Площадь | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SNedv;
    /**
     * The InvNNedv
     * Meta informations extracted from the WSDL
     * - documentation: Инвентарный номер | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $InvNNedv;
    /**
     * The LiterN
     * Meta informations extracted from the WSDL
     * - documentation: Литер | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $LiterN;
    /**
     * The Floor
     * Meta informations extracted from the WSDL
     * - documentation: Этаж | Строка длиной от 1 до 3 символов
     * - minOccurs: 0
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $Floor;
    /**
     * The Nfloor
     * Meta informations extracted from the WSDL
     * - documentation: Номер на поэтажном плане | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Nfloor;
    /**
     * The RegisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegisterDate;
    /**
     * The UnregisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчуждения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $UnregisterDate;
    /**
     * The AssignationCode
     * Meta informations extracted from the WSDL
     * - documentation: Код назначения | Строка длиной от 1 до 12 символов
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $AssignationCode;
    /**
     * The AssignationName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование назначения | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $AssignationName;
    /**
     * The AssignationText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание назначения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $AssignationText;
    /**
     * The GroundCategoryCode
     * Meta informations extracted from the WSDL
     * - documentation: Целевое назначение (категория) земель | Строка длиной от 1 до 12 символов
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $GroundCategoryCode;
    /**
     * The GroundCategoryText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание целевого назначения(категории) земель | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $GroundCategoryText;
    /**
     * The Area
     * Meta informations extracted from the WSDL
     * - documentation: Площади
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\SvedNedvAreaType[]
     */
    public $Area;
    /**
     * Constructor method for SvedNedvDataType
     * @uses SvedNedvDataType::setNaimNedv()
     * @uses SvedNedvDataType::setObjectTypeText()
     * @uses SvedNedvDataType::setKadastrN()
     * @uses SvedNedvDataType::setConditionalNumber()
     * @uses SvedNedvDataType::setObjectTypeCode()
     * @uses SvedNedvDataType::setAdresNedv()
     * @uses SvedNedvDataType::setAddressParts()
     * @uses SvedNedvDataType::setSNedv()
     * @uses SvedNedvDataType::setInvNNedv()
     * @uses SvedNedvDataType::setLiterN()
     * @uses SvedNedvDataType::setFloor()
     * @uses SvedNedvDataType::setNfloor()
     * @uses SvedNedvDataType::setRegisterDate()
     * @uses SvedNedvDataType::setUnregisterDate()
     * @uses SvedNedvDataType::setAssignationCode()
     * @uses SvedNedvDataType::setAssignationName()
     * @uses SvedNedvDataType::setAssignationText()
     * @uses SvedNedvDataType::setGroundCategoryCode()
     * @uses SvedNedvDataType::setGroundCategoryText()
     * @uses SvedNedvDataType::setArea()
     * @param string $naimNedv
     * @param string $objectTypeText
     * @param string $kadastrN
     * @param string $conditionalNumber
     * @param string $objectTypeCode
     * @param string $adresNedv
     * @param \AisFssp\StructType\AddressType $addressParts
     * @param float $sNedv
     * @param string $invNNedv
     * @param string $literN
     * @param string $floor
     * @param string $nfloor
     * @param string $registerDate
     * @param string $unregisterDate
     * @param string $assignationCode
     * @param string $assignationName
     * @param string $assignationText
     * @param string $groundCategoryCode
     * @param string $groundCategoryText
     * @param \AisFssp\StructType\SvedNedvAreaType[] $area
     */
    public function __construct($naimNedv = null, $objectTypeText = null, $kadastrN = null, $conditionalNumber = null, $objectTypeCode = null, $adresNedv = null, \AisFssp\StructType\AddressType $addressParts = null, $sNedv = null, $invNNedv = null, $literN = null, $floor = null, $nfloor = null, $registerDate = null, $unregisterDate = null, $assignationCode = null, $assignationName = null, $assignationText = null, $groundCategoryCode = null, $groundCategoryText = null, array $area = array())
    {
        $this
            ->setNaimNedv($naimNedv)
            ->setObjectTypeText($objectTypeText)
            ->setKadastrN($kadastrN)
            ->setConditionalNumber($conditionalNumber)
            ->setObjectTypeCode($objectTypeCode)
            ->setAdresNedv($adresNedv)
            ->setAddressParts($addressParts)
            ->setSNedv($sNedv)
            ->setInvNNedv($invNNedv)
            ->setLiterN($literN)
            ->setFloor($floor)
            ->setNfloor($nfloor)
            ->setRegisterDate($registerDate)
            ->setUnregisterDate($unregisterDate)
            ->setAssignationCode($assignationCode)
            ->setAssignationName($assignationName)
            ->setAssignationText($assignationText)
            ->setGroundCategoryCode($groundCategoryCode)
            ->setGroundCategoryText($groundCategoryText)
            ->setArea($area);
    }
    /**
     * Get NaimNedv value
     * @return string|null
     */
    public function getNaimNedv()
    {
        return $this->NaimNedv;
    }
    /**
     * Set NaimNedv value
     * @param string $naimNedv
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setNaimNedv($naimNedv = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($naimNedv) && strlen($naimNedv) > 4000) || (is_array($naimNedv) && count($naimNedv) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($naimNedv) ? strlen($naimNedv) : count($naimNedv)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($naimNedv) && strlen($naimNedv) < 1) || (is_array($naimNedv) && count($naimNedv) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($naimNedv) && !is_string($naimNedv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naimNedv)), __LINE__);
        }
        $this->NaimNedv = $naimNedv;
        return $this;
    }
    /**
     * Get ObjectTypeText value
     * @return string|null
     */
    public function getObjectTypeText()
    {
        return $this->ObjectTypeText;
    }
    /**
     * Set ObjectTypeText value
     * @param string $objectTypeText
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setObjectTypeText($objectTypeText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($objectTypeText) && strlen($objectTypeText) > 1000) || (is_array($objectTypeText) && count($objectTypeText) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($objectTypeText) ? strlen($objectTypeText) : count($objectTypeText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($objectTypeText) && strlen($objectTypeText) < 1) || (is_array($objectTypeText) && count($objectTypeText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectTypeText) && !is_string($objectTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectTypeText)), __LINE__);
        }
        $this->ObjectTypeText = $objectTypeText;
        return $this;
    }
    /**
     * Get KadastrN value
     * @return string|null
     */
    public function getKadastrN()
    {
        return $this->KadastrN;
    }
    /**
     * Set KadastrN value
     * @param string $kadastrN
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setKadastrN($kadastrN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kadastrN) && strlen($kadastrN) > 500) || (is_array($kadastrN) && count($kadastrN) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($kadastrN) ? strlen($kadastrN) : count($kadastrN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($kadastrN) && strlen($kadastrN) < 1) || (is_array($kadastrN) && count($kadastrN) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kadastrN) && !is_string($kadastrN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kadastrN)), __LINE__);
        }
        $this->KadastrN = $kadastrN;
        return $this;
    }
    /**
     * Get ConditionalNumber value
     * @return string|null
     */
    public function getConditionalNumber()
    {
        return $this->ConditionalNumber;
    }
    /**
     * Set ConditionalNumber value
     * @param string $conditionalNumber
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setConditionalNumber($conditionalNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($conditionalNumber) && strlen($conditionalNumber) > 100) || (is_array($conditionalNumber) && count($conditionalNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($conditionalNumber) ? strlen($conditionalNumber) : count($conditionalNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($conditionalNumber) && strlen($conditionalNumber) < 1) || (is_array($conditionalNumber) && count($conditionalNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($conditionalNumber) && !is_string($conditionalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conditionalNumber)), __LINE__);
        }
        $this->ConditionalNumber = $conditionalNumber;
        return $this;
    }
    /**
     * Get ObjectTypeCode value
     * @return string|null
     */
    public function getObjectTypeCode()
    {
        return $this->ObjectTypeCode;
    }
    /**
     * Set ObjectTypeCode value
     * @param string $objectTypeCode
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setObjectTypeCode($objectTypeCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($objectTypeCode) && strlen($objectTypeCode) > 255) || (is_array($objectTypeCode) && count($objectTypeCode) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($objectTypeCode) ? strlen($objectTypeCode) : count($objectTypeCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($objectTypeCode) && strlen($objectTypeCode) < 1) || (is_array($objectTypeCode) && count($objectTypeCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectTypeCode) && !is_string($objectTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectTypeCode)), __LINE__);
        }
        $this->ObjectTypeCode = $objectTypeCode;
        return $this;
    }
    /**
     * Get AdresNedv value
     * @return string|null
     */
    public function getAdresNedv()
    {
        return $this->AdresNedv;
    }
    /**
     * Set AdresNedv value
     * @param string $adresNedv
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setAdresNedv($adresNedv = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($adresNedv) && strlen($adresNedv) > 1500) || (is_array($adresNedv) && count($adresNedv) > 1500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1500 element(s) or a scalar of 1500 character(s) at most, "%d" length given', is_scalar($adresNedv) ? strlen($adresNedv) : count($adresNedv)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($adresNedv) && strlen($adresNedv) < 1) || (is_array($adresNedv) && count($adresNedv) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($adresNedv) && !is_string($adresNedv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresNedv)), __LINE__);
        }
        $this->AdresNedv = $adresNedv;
        return $this;
    }
    /**
     * Get AddressParts value
     * @return \AisFssp\StructType\AddressType|null
     */
    public function getAddressParts()
    {
        return $this->AddressParts;
    }
    /**
     * Set AddressParts value
     * @param \AisFssp\StructType\AddressType $addressParts
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setAddressParts(\AisFssp\StructType\AddressType $addressParts = null)
    {
        $this->AddressParts = $addressParts;
        return $this;
    }
    /**
     * Get SNedv value
     * @return float|null
     */
    public function getSNedv()
    {
        return $this->SNedv;
    }
    /**
     * Set SNedv value
     * @param float $sNedv
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setSNedv($sNedv = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($sNedv) && strlen(substr($sNedv, strpos($sNedv, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($sNedv, strpos($sNedv, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($sNedv) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $sNedv)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($sNedv, strpos($sNedv, '.')))), __LINE__);
        }
        $this->SNedv = $sNedv;
        return $this;
    }
    /**
     * Get InvNNedv value
     * @return string|null
     */
    public function getInvNNedv()
    {
        return $this->InvNNedv;
    }
    /**
     * Set InvNNedv value
     * @param string $invNNedv
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setInvNNedv($invNNedv = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invNNedv) && strlen($invNNedv) > 50) || (is_array($invNNedv) && count($invNNedv) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($invNNedv) ? strlen($invNNedv) : count($invNNedv)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($invNNedv) && strlen($invNNedv) < 1) || (is_array($invNNedv) && count($invNNedv) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invNNedv) && !is_string($invNNedv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invNNedv)), __LINE__);
        }
        $this->InvNNedv = $invNNedv;
        return $this;
    }
    /**
     * Get LiterN value
     * @return string|null
     */
    public function getLiterN()
    {
        return $this->LiterN;
    }
    /**
     * Set LiterN value
     * @param string $literN
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setLiterN($literN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($literN) && strlen($literN) > 10) || (is_array($literN) && count($literN) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($literN) ? strlen($literN) : count($literN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($literN) && strlen($literN) < 1) || (is_array($literN) && count($literN) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($literN) && !is_string($literN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($literN)), __LINE__);
        }
        $this->LiterN = $literN;
        return $this;
    }
    /**
     * Get Floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->Floor;
    }
    /**
     * Set Floor value
     * @param string $floor
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($floor) && strlen($floor) > 3) || (is_array($floor) && count($floor) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($floor) ? strlen($floor) : count($floor)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($floor) && strlen($floor) < 1) || (is_array($floor) && count($floor) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floor)), __LINE__);
        }
        $this->Floor = $floor;
        return $this;
    }
    /**
     * Get Nfloor value
     * @return string|null
     */
    public function getNfloor()
    {
        return $this->Nfloor;
    }
    /**
     * Set Nfloor value
     * @param string $nfloor
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setNfloor($nfloor = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nfloor) && strlen($nfloor) > 50) || (is_array($nfloor) && count($nfloor) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($nfloor) ? strlen($nfloor) : count($nfloor)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($nfloor) && strlen($nfloor) < 1) || (is_array($nfloor) && count($nfloor) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nfloor) && !is_string($nfloor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nfloor)), __LINE__);
        }
        $this->Nfloor = $nfloor;
        return $this;
    }
    /**
     * Get RegisterDate value
     * @return string|null
     */
    public function getRegisterDate()
    {
        return $this->RegisterDate;
    }
    /**
     * Set RegisterDate value
     * @param string $registerDate
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setRegisterDate($registerDate = null)
    {
        // validation for constraint: maxExclusive
        if ($registerDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $registerDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($registerDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $registerDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registerDate) && !is_string($registerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registerDate)), __LINE__);
        }
        $this->RegisterDate = $registerDate;
        return $this;
    }
    /**
     * Get UnregisterDate value
     * @return string|null
     */
    public function getUnregisterDate()
    {
        return $this->UnregisterDate;
    }
    /**
     * Set UnregisterDate value
     * @param string $unregisterDate
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setUnregisterDate($unregisterDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unregisterDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unregisterDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unregisterDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unregisterDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unregisterDate) && !is_string($unregisterDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unregisterDate)), __LINE__);
        }
        $this->UnregisterDate = $unregisterDate;
        return $this;
    }
    /**
     * Get AssignationCode value
     * @return string|null
     */
    public function getAssignationCode()
    {
        return $this->AssignationCode;
    }
    /**
     * Set AssignationCode value
     * @param string $assignationCode
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setAssignationCode($assignationCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($assignationCode) && strlen($assignationCode) > 12) || (is_array($assignationCode) && count($assignationCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($assignationCode) ? strlen($assignationCode) : count($assignationCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($assignationCode) && strlen($assignationCode) < 1) || (is_array($assignationCode) && count($assignationCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($assignationCode) && !is_string($assignationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignationCode)), __LINE__);
        }
        $this->AssignationCode = $assignationCode;
        return $this;
    }
    /**
     * Get AssignationName value
     * @return string|null
     */
    public function getAssignationName()
    {
        return $this->AssignationName;
    }
    /**
     * Set AssignationName value
     * @param string $assignationName
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setAssignationName($assignationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($assignationName) && strlen($assignationName) > 50) || (is_array($assignationName) && count($assignationName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($assignationName) ? strlen($assignationName) : count($assignationName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($assignationName) && strlen($assignationName) < 1) || (is_array($assignationName) && count($assignationName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($assignationName) && !is_string($assignationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignationName)), __LINE__);
        }
        $this->AssignationName = $assignationName;
        return $this;
    }
    /**
     * Get AssignationText value
     * @return string|null
     */
    public function getAssignationText()
    {
        return $this->AssignationText;
    }
    /**
     * Set AssignationText value
     * @param string $assignationText
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setAssignationText($assignationText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($assignationText) && strlen($assignationText) > 1000) || (is_array($assignationText) && count($assignationText) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($assignationText) ? strlen($assignationText) : count($assignationText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($assignationText) && strlen($assignationText) < 1) || (is_array($assignationText) && count($assignationText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($assignationText) && !is_string($assignationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignationText)), __LINE__);
        }
        $this->AssignationText = $assignationText;
        return $this;
    }
    /**
     * Get GroundCategoryCode value
     * @return string|null
     */
    public function getGroundCategoryCode()
    {
        return $this->GroundCategoryCode;
    }
    /**
     * Set GroundCategoryCode value
     * @param string $groundCategoryCode
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setGroundCategoryCode($groundCategoryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($groundCategoryCode) && strlen($groundCategoryCode) > 12) || (is_array($groundCategoryCode) && count($groundCategoryCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($groundCategoryCode) ? strlen($groundCategoryCode) : count($groundCategoryCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($groundCategoryCode) && strlen($groundCategoryCode) < 1) || (is_array($groundCategoryCode) && count($groundCategoryCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groundCategoryCode) && !is_string($groundCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groundCategoryCode)), __LINE__);
        }
        $this->GroundCategoryCode = $groundCategoryCode;
        return $this;
    }
    /**
     * Get GroundCategoryText value
     * @return string|null
     */
    public function getGroundCategoryText()
    {
        return $this->GroundCategoryText;
    }
    /**
     * Set GroundCategoryText value
     * @param string $groundCategoryText
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setGroundCategoryText($groundCategoryText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($groundCategoryText) && strlen($groundCategoryText) > 1000) || (is_array($groundCategoryText) && count($groundCategoryText) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($groundCategoryText) ? strlen($groundCategoryText) : count($groundCategoryText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($groundCategoryText) && strlen($groundCategoryText) < 1) || (is_array($groundCategoryText) && count($groundCategoryText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groundCategoryText) && !is_string($groundCategoryText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groundCategoryText)), __LINE__);
        }
        $this->GroundCategoryText = $groundCategoryText;
        return $this;
    }
    /**
     * Get Area value
     * @return \AisFssp\StructType\SvedNedvAreaType[]|null
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * Set Area value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SvedNedvAreaType[] $area
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function setArea(array $area = array())
    {
        foreach ($area as $svedNedvDataTypeAreaItem) {
            // validation for constraint: itemType
            if (!$svedNedvDataTypeAreaItem instanceof \AisFssp\StructType\SvedNedvAreaType) {
                throw new \InvalidArgumentException(sprintf('The Area property can only contain items of \AisFssp\StructType\SvedNedvAreaType, "%s" given', is_object($svedNedvDataTypeAreaItem) ? get_class($svedNedvDataTypeAreaItem) : gettype($svedNedvDataTypeAreaItem)), __LINE__);
            }
        }
        $this->Area = $area;
        return $this;
    }
    /**
     * Add item to Area value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SvedNedvAreaType $item
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public function addToArea(\AisFssp\StructType\SvedNedvAreaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SvedNedvAreaType) {
            throw new \InvalidArgumentException(sprintf('The Area property can only contain items of \AisFssp\StructType\SvedNedvAreaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Area[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SvedNedvDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
