<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvAreaType StructType
 * @subpackage Structs
 */
class SvedNedvAreaType extends AbstractStructBase
{
    /**
     * The areaCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида площади | Строка длиной от 1 до 3 символов
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $areaCode;
    /**
     * The areaName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида площади по справочнику | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $areaName;
    /**
     * The areaText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание вида площади по справочнику | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $areaText;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - documentation: Значение площади | Площадь
     * - fractionDigits: 2
     * - totalDigits: 20
     * @var float
     */
    public $value;
    /**
     * The unitCode
     * Meta informations extracted from the WSDL
     * - documentation: Единица измерений | Код ОКЕИ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $unitCode;
    /**
     * The unitName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование единицы измерения | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $unitName;
    /**
     * Constructor method for SvedNedvAreaType
     * @uses SvedNedvAreaType::setAreaCode()
     * @uses SvedNedvAreaType::setAreaName()
     * @uses SvedNedvAreaType::setAreaText()
     * @uses SvedNedvAreaType::setValue()
     * @uses SvedNedvAreaType::setUnitCode()
     * @uses SvedNedvAreaType::setUnitName()
     * @param string $areaCode
     * @param string $areaName
     * @param string $areaText
     * @param float $value
     * @param string $unitCode
     * @param string $unitName
     */
    public function __construct($areaCode = null, $areaName = null, $areaText = null, $value = null, $unitCode = null, $unitName = null)
    {
        $this
            ->setAreaCode($areaCode)
            ->setAreaName($areaName)
            ->setAreaText($areaText)
            ->setValue($value)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName);
    }
    /**
     * Get areaCode value
     * @return string|null
     */
    public function getAreaCode()
    {
        return $this->areaCode;
    }
    /**
     * Set areaCode value
     * @param string $areaCode
     * @return \AisFssp\StructType\SvedNedvAreaType
     */
    public function setAreaCode($areaCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($areaCode) && strlen($areaCode) > 3) || (is_array($areaCode) && count($areaCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($areaCode) ? strlen($areaCode) : count($areaCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($areaCode) && strlen($areaCode) < 1) || (is_array($areaCode) && count($areaCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($areaCode) && !is_string($areaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaCode)), __LINE__);
        }
        $this->areaCode = $areaCode;
        return $this;
    }
    /**
     * Get areaName value
     * @return string|null
     */
    public function getAreaName()
    {
        return $this->areaName;
    }
    /**
     * Set areaName value
     * @param string $areaName
     * @return \AisFssp\StructType\SvedNedvAreaType
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($areaName) && strlen($areaName) > 50) || (is_array($areaName) && count($areaName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($areaName) ? strlen($areaName) : count($areaName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($areaName) && strlen($areaName) < 1) || (is_array($areaName) && count($areaName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaName)), __LINE__);
        }
        $this->areaName = $areaName;
        return $this;
    }
    /**
     * Get areaText value
     * @return string|null
     */
    public function getAreaText()
    {
        return $this->areaText;
    }
    /**
     * Set areaText value
     * @param string $areaText
     * @return \AisFssp\StructType\SvedNedvAreaType
     */
    public function setAreaText($areaText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($areaText) && strlen($areaText) > 1000) || (is_array($areaText) && count($areaText) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($areaText) ? strlen($areaText) : count($areaText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($areaText) && strlen($areaText) < 1) || (is_array($areaText) && count($areaText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($areaText) && !is_string($areaText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaText)), __LINE__);
        }
        $this->areaText = $areaText;
        return $this;
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \AisFssp\StructType\SvedNedvAreaType
     */
    public function setValue($value = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($value) && strlen(substr($value, strpos($value, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($value, strpos($value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($value) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $value)) !== 20) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 20 digits, "%d" given', strlen(substr($value, strpos($value, '.')))), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get unitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->unitCode;
    }
    /**
     * Set unitCode value
     * @param string $unitCode
     * @return \AisFssp\StructType\SvedNedvAreaType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($unitCode) && strlen($unitCode) !== 3) || (is_array($unitCode) && count($unitCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitCode)), __LINE__);
        }
        $this->unitCode = $unitCode;
        return $this;
    }
    /**
     * Get unitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->unitName;
    }
    /**
     * Set unitName value
     * @param string $unitName
     * @return \AisFssp\StructType\SvedNedvAreaType
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unitName) && strlen($unitName) > 50) || (is_array($unitName) && count($unitName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($unitName) ? strlen($unitName) : count($unitName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($unitName) && strlen($unitName) < 1) || (is_array($unitName) && count($unitName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitName)), __LINE__);
        }
        $this->unitName = $unitName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SvedNedvAreaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
