<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubdivisionDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об обособленном подразделении
 * @subpackage Structs
 */
class SubdivisionDatumType extends InformationType
{
    /**
     * The subdivisionKind
     * Meta informations extracted from the WSDL
     * - documentation: Код вида подразделения | Строка длиной от 1 до 6 символов
     * - maxLength: 6
     * - minLength: 1
     * @var string
     */
    public $subdivisionKind;
    /**
     * Constructor method for SubdivisionDatumType
     * @uses SubdivisionDatumType::setSubdivisionKind()
     * @param string $subdivisionKind
     */
    public function __construct($subdivisionKind = null)
    {
        $this
            ->setSubdivisionKind($subdivisionKind);
    }
    /**
     * Get subdivisionKind value
     * @return string|null
     */
    public function getSubdivisionKind()
    {
        return $this->subdivisionKind;
    }
    /**
     * Set subdivisionKind value
     * @param string $subdivisionKind
     * @return \AisFssp\StructType\SubdivisionDatumType
     */
    public function setSubdivisionKind($subdivisionKind = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subdivisionKind) && strlen($subdivisionKind) > 6) || (is_array($subdivisionKind) && count($subdivisionKind) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($subdivisionKind) ? strlen($subdivisionKind) : count($subdivisionKind)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($subdivisionKind) && strlen($subdivisionKind) < 1) || (is_array($subdivisionKind) && count($subdivisionKind) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subdivisionKind) && !is_string($subdivisionKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subdivisionKind)), __LINE__);
        }
        $this->subdivisionKind = $subdivisionKind;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SubdivisionDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
