<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoleEntrepreneurDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об индивидуальном предпринимателе
 * @subpackage Structs
 */
class SoleEntrepreneurDatumType extends PersonDatumType
{
    /**
     * The documentId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа | Строка длиной 9 символов
     * - length: 9
     * @var string
     */
    public $documentId;
    /**
     * The soleEntrepreneurId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИП в базе данных | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $soleEntrepreneurId;
    /**
     * The OKVED
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о видах экономической деятельности
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\OkvedDetailType[]
     */
    public $OKVED;
    /**
     * The kindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $kindId;
    /**
     * The kindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $kindName;
    /**
     * The statusId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор состояния индивидуального предпринимателя (КФХ) | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $statusId;
    /**
     * The statusName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование состояния индивидуального предпринимателя (КФХ) | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $statusName;
    /**
     * The statusDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия указанного статуса (состояния) | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $statusDate;
    /**
     * The citizenDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата внесения записи с сведениями о гражданстве в ЕГРИП | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $citizenDate;
    /**
     * The citizenKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида гражданства | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $citizenKindId;
    /**
     * The citizenKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида гражданства | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $citizenKindName;
    /**
     * The countryId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор страны гражданства | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $countryId;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Код страны гражданства по классификатору ОКСМ | Код страны буквенный | Трехзначный (альфа-3) буквенный код страны мира по
     * классификатору ОКСМ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $countryCode;
    /**
     * The countryName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование страны гражданства | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $countryName;
    /**
     * Constructor method for SoleEntrepreneurDatumType
     * @uses SoleEntrepreneurDatumType::setDocumentId()
     * @uses SoleEntrepreneurDatumType::setSoleEntrepreneurId()
     * @uses SoleEntrepreneurDatumType::setOKVED()
     * @uses SoleEntrepreneurDatumType::setKindId()
     * @uses SoleEntrepreneurDatumType::setKindName()
     * @uses SoleEntrepreneurDatumType::setStatusId()
     * @uses SoleEntrepreneurDatumType::setStatusName()
     * @uses SoleEntrepreneurDatumType::setStatusDate()
     * @uses SoleEntrepreneurDatumType::setCitizenDate()
     * @uses SoleEntrepreneurDatumType::setCitizenKindId()
     * @uses SoleEntrepreneurDatumType::setCitizenKindName()
     * @uses SoleEntrepreneurDatumType::setCountryId()
     * @uses SoleEntrepreneurDatumType::setCountryCode()
     * @uses SoleEntrepreneurDatumType::setCountryName()
     * @param string $documentId
     * @param int $soleEntrepreneurId
     * @param \AisFssp\StructType\OkvedDetailType[] $oKVED
     * @param int $kindId
     * @param string $kindName
     * @param int $statusId
     * @param string $statusName
     * @param string $statusDate
     * @param string $citizenDate
     * @param int $citizenKindId
     * @param string $citizenKindName
     * @param int $countryId
     * @param string $countryCode
     * @param string $countryName
     */
    public function __construct($documentId = null, $soleEntrepreneurId = null, array $oKVED = array(), $kindId = null, $kindName = null, $statusId = null, $statusName = null, $statusDate = null, $citizenDate = null, $citizenKindId = null, $citizenKindName = null, $countryId = null, $countryCode = null, $countryName = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setSoleEntrepreneurId($soleEntrepreneurId)
            ->setOKVED($oKVED)
            ->setKindId($kindId)
            ->setKindName($kindName)
            ->setStatusId($statusId)
            ->setStatusName($statusName)
            ->setStatusDate($statusDate)
            ->setCitizenDate($citizenDate)
            ->setCitizenKindId($citizenKindId)
            ->setCitizenKindName($citizenKindName)
            ->setCountryId($countryId)
            ->setCountryCode($countryCode)
            ->setCountryName($countryName);
    }
    /**
     * Get documentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param string $documentId
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: length
        if ((is_scalar($documentId) && strlen($documentId) !== 9) || (is_array($documentId) && count($documentId) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentId)), __LINE__);
        }
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get soleEntrepreneurId value
     * @return int|null
     */
    public function getSoleEntrepreneurId()
    {
        return $this->soleEntrepreneurId;
    }
    /**
     * Set soleEntrepreneurId value
     * @param int $soleEntrepreneurId
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setSoleEntrepreneurId($soleEntrepreneurId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($soleEntrepreneurId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $soleEntrepreneurId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($soleEntrepreneurId, strpos($soleEntrepreneurId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($soleEntrepreneurId) && !is_numeric($soleEntrepreneurId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($soleEntrepreneurId)), __LINE__);
        }
        $this->soleEntrepreneurId = $soleEntrepreneurId;
        return $this;
    }
    /**
     * Get OKVED value
     * @return \AisFssp\StructType\OkvedDetailType[]|null
     */
    public function getOKVED()
    {
        return $this->OKVED;
    }
    /**
     * Set OKVED value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OkvedDetailType[] $oKVED
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setOKVED(array $oKVED = array())
    {
        foreach ($oKVED as $soleEntrepreneurDatumTypeOKVEDItem) {
            // validation for constraint: itemType
            if (!$soleEntrepreneurDatumTypeOKVEDItem instanceof \AisFssp\StructType\OkvedDetailType) {
                throw new \InvalidArgumentException(sprintf('The OKVED property can only contain items of \AisFssp\StructType\OkvedDetailType, "%s" given', is_object($soleEntrepreneurDatumTypeOKVEDItem) ? get_class($soleEntrepreneurDatumTypeOKVEDItem) : gettype($soleEntrepreneurDatumTypeOKVEDItem)), __LINE__);
            }
        }
        $this->OKVED = $oKVED;
        return $this;
    }
    /**
     * Add item to OKVED value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OkvedDetailType $item
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function addToOKVED(\AisFssp\StructType\OkvedDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\OkvedDetailType) {
            throw new \InvalidArgumentException(sprintf('The OKVED property can only contain items of \AisFssp\StructType\OkvedDetailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OKVED[] = $item;
        return $this;
    }
    /**
     * Get kindId value
     * @return int|null
     */
    public function getKindId()
    {
        return $this->kindId;
    }
    /**
     * Set kindId value
     * @param int $kindId
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setKindId($kindId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($kindId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $kindId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($kindId, strpos($kindId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($kindId) && !is_numeric($kindId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kindId)), __LINE__);
        }
        $this->kindId = $kindId;
        return $this;
    }
    /**
     * Get kindName value
     * @return string|null
     */
    public function getKindName()
    {
        return $this->kindName;
    }
    /**
     * Set kindName value
     * @param string $kindName
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setKindName($kindName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kindName) && strlen($kindName) > 255) || (is_array($kindName) && count($kindName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($kindName) ? strlen($kindName) : count($kindName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($kindName) && strlen($kindName) < 1) || (is_array($kindName) && count($kindName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kindName) && !is_string($kindName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kindName)), __LINE__);
        }
        $this->kindName = $kindName;
        return $this;
    }
    /**
     * Get statusId value
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->statusId;
    }
    /**
     * Set statusId value
     * @param int $statusId
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($statusId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $statusId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($statusId, strpos($statusId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($statusId) && !is_numeric($statusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statusId)), __LINE__);
        }
        $this->statusId = $statusId;
        return $this;
    }
    /**
     * Get statusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->statusName;
    }
    /**
     * Set statusName value
     * @param string $statusName
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($statusName) && strlen($statusName) > 255) || (is_array($statusName) && count($statusName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($statusName) ? strlen($statusName) : count($statusName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($statusName) && strlen($statusName) < 1) || (is_array($statusName) && count($statusName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($statusName) && !is_string($statusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusName)), __LINE__);
        }
        $this->statusName = $statusName;
        return $this;
    }
    /**
     * Get statusDate value
     * @return string|null
     */
    public function getStatusDate()
    {
        return $this->statusDate;
    }
    /**
     * Set statusDate value
     * @param string $statusDate
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: maxExclusive
        if ($statusDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $statusDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($statusDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $statusDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDate)), __LINE__);
        }
        $this->statusDate = $statusDate;
        return $this;
    }
    /**
     * Get citizenDate value
     * @return string|null
     */
    public function getCitizenDate()
    {
        return $this->citizenDate;
    }
    /**
     * Set citizenDate value
     * @param string $citizenDate
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setCitizenDate($citizenDate = null)
    {
        // validation for constraint: maxExclusive
        if ($citizenDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $citizenDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($citizenDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $citizenDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($citizenDate) && !is_string($citizenDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($citizenDate)), __LINE__);
        }
        $this->citizenDate = $citizenDate;
        return $this;
    }
    /**
     * Get citizenKindId value
     * @return int|null
     */
    public function getCitizenKindId()
    {
        return $this->citizenKindId;
    }
    /**
     * Set citizenKindId value
     * @param int $citizenKindId
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setCitizenKindId($citizenKindId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($citizenKindId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $citizenKindId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($citizenKindId, strpos($citizenKindId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($citizenKindId) && !is_numeric($citizenKindId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($citizenKindId)), __LINE__);
        }
        $this->citizenKindId = $citizenKindId;
        return $this;
    }
    /**
     * Get citizenKindName value
     * @return string|null
     */
    public function getCitizenKindName()
    {
        return $this->citizenKindName;
    }
    /**
     * Set citizenKindName value
     * @param string $citizenKindName
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setCitizenKindName($citizenKindName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($citizenKindName) && strlen($citizenKindName) > 255) || (is_array($citizenKindName) && count($citizenKindName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($citizenKindName) ? strlen($citizenKindName) : count($citizenKindName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($citizenKindName) && strlen($citizenKindName) < 1) || (is_array($citizenKindName) && count($citizenKindName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($citizenKindName) && !is_string($citizenKindName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($citizenKindName)), __LINE__);
        }
        $this->citizenKindName = $citizenKindName;
        return $this;
    }
    /**
     * Get countryId value
     * @return int|null
     */
    public function getCountryId()
    {
        return $this->countryId;
    }
    /**
     * Set countryId value
     * @param int $countryId
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($countryId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $countryId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($countryId, strpos($countryId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($countryId) && !is_numeric($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($countryId)), __LINE__);
        }
        $this->countryId = $countryId;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($countryCode) && strlen($countryCode) !== 3) || (is_array($countryCode) && count($countryCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get countryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->countryName;
    }
    /**
     * Set countryName value
     * @param string $countryName
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($countryName) && strlen($countryName) > 255) || (is_array($countryName) && count($countryName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($countryName) ? strlen($countryName) : count($countryName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($countryName) && strlen($countryName) < 1) || (is_array($countryName) && count($countryName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryName)), __LINE__);
        }
        $this->countryName = $countryName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
