<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalaryWithheldDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о начисленном денежном довольствии и произведенных удержаниях
 * @subpackage Structs
 */
class SalaryWithheldDatumType extends InformationType
{
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - documentation: Тип операции
     * @var string
     */
    public $TransactionType;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата операции | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $TransactionDate;
    /**
     * The SalaryAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SalaryAmount;
    /**
     * The PayoutAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма полученная | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PayoutAmount;
    /**
     * The Grounds
     * Meta informations extracted from the WSDL
     * - documentation: Основание | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Grounds;
    /**
     * The Withhelds
     * Meta informations extracted from the WSDL
     * - documentation: Удержано
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\WithheldDetailType[]
     */
    public $Withhelds;
    /**
     * Constructor method for SalaryWithheldDatumType
     * @uses SalaryWithheldDatumType::setTransactionType()
     * @uses SalaryWithheldDatumType::setTransactionDate()
     * @uses SalaryWithheldDatumType::setSalaryAmount()
     * @uses SalaryWithheldDatumType::setPayoutAmount()
     * @uses SalaryWithheldDatumType::setGrounds()
     * @uses SalaryWithheldDatumType::setWithhelds()
     * @param string $transactionType
     * @param string $transactionDate
     * @param float $salaryAmount
     * @param float $payoutAmount
     * @param string $grounds
     * @param \AisFssp\StructType\WithheldDetailType[] $withhelds
     */
    public function __construct($transactionType = null, $transactionDate = null, $salaryAmount = null, $payoutAmount = null, $grounds = null, array $withhelds = array())
    {
        $this
            ->setTransactionType($transactionType)
            ->setTransactionDate($transactionDate)
            ->setSalaryAmount($salaryAmount)
            ->setPayoutAmount($payoutAmount)
            ->setGrounds($grounds)
            ->setWithhelds($withhelds);
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \AisFssp\EnumType\AccountTransactionType::valueIsValid()
     * @uses \AisFssp\EnumType\AccountTransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \AisFssp\StructType\SalaryWithheldDatumType
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\AccountTransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionType, implode(', ', \AisFssp\EnumType\AccountTransactionType::getValidValues())), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \AisFssp\StructType\SalaryWithheldDatumType
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: maxExclusive
        if ($transactionDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $transactionDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($transactionDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $transactionDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get SalaryAmount value
     * @return float|null
     */
    public function getSalaryAmount()
    {
        return $this->SalaryAmount;
    }
    /**
     * Set SalaryAmount value
     * @param float $salaryAmount
     * @return \AisFssp\StructType\SalaryWithheldDatumType
     */
    public function setSalaryAmount($salaryAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($salaryAmount) && strlen(substr($salaryAmount, strpos($salaryAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($salaryAmount, strpos($salaryAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($salaryAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $salaryAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($salaryAmount, strpos($salaryAmount, '.')))), __LINE__);
        }
        $this->SalaryAmount = $salaryAmount;
        return $this;
    }
    /**
     * Get PayoutAmount value
     * @return float|null
     */
    public function getPayoutAmount()
    {
        return $this->PayoutAmount;
    }
    /**
     * Set PayoutAmount value
     * @param float $payoutAmount
     * @return \AisFssp\StructType\SalaryWithheldDatumType
     */
    public function setPayoutAmount($payoutAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($payoutAmount) && strlen(substr($payoutAmount, strpos($payoutAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($payoutAmount, strpos($payoutAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($payoutAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $payoutAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($payoutAmount, strpos($payoutAmount, '.')))), __LINE__);
        }
        $this->PayoutAmount = $payoutAmount;
        return $this;
    }
    /**
     * Get Grounds value
     * @return string|null
     */
    public function getGrounds()
    {
        return $this->Grounds;
    }
    /**
     * Set Grounds value
     * @param string $grounds
     * @return \AisFssp\StructType\SalaryWithheldDatumType
     */
    public function setGrounds($grounds = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($grounds) && strlen($grounds) > 1000) || (is_array($grounds) && count($grounds) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($grounds) ? strlen($grounds) : count($grounds)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($grounds) && strlen($grounds) < 1) || (is_array($grounds) && count($grounds) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($grounds) && !is_string($grounds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grounds)), __LINE__);
        }
        $this->Grounds = $grounds;
        return $this;
    }
    /**
     * Get Withhelds value
     * @return \AisFssp\StructType\WithheldDetailType[]|null
     */
    public function getWithhelds()
    {
        return $this->Withhelds;
    }
    /**
     * Set Withhelds value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\WithheldDetailType[] $withhelds
     * @return \AisFssp\StructType\SalaryWithheldDatumType
     */
    public function setWithhelds(array $withhelds = array())
    {
        foreach ($withhelds as $salaryWithheldDatumTypeWithheldsItem) {
            // validation for constraint: itemType
            if (!$salaryWithheldDatumTypeWithheldsItem instanceof \AisFssp\StructType\WithheldDetailType) {
                throw new \InvalidArgumentException(sprintf('The Withhelds property can only contain items of \AisFssp\StructType\WithheldDetailType, "%s" given', is_object($salaryWithheldDatumTypeWithheldsItem) ? get_class($salaryWithheldDatumTypeWithheldsItem) : gettype($salaryWithheldDatumTypeWithheldsItem)), __LINE__);
            }
        }
        $this->Withhelds = $withhelds;
        return $this;
    }
    /**
     * Add item to Withhelds value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\WithheldDetailType $item
     * @return \AisFssp\StructType\SalaryWithheldDatumType
     */
    public function addToWithhelds(\AisFssp\StructType\WithheldDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\WithheldDetailType) {
            throw new \InvalidArgumentException(sprintf('The Withhelds property can only contain items of \AisFssp\StructType\WithheldDetailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Withhelds[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SalaryWithheldDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
