<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionRegistry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реестр ограничений
 * - type: tns:RestrictionRegistry
 * @subpackage Structs
 */
class RestrictionRegistry extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - documentation: Версия документа | Строка длиной от 1 до 8 символов
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Version;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ реестра ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The UnloadVersion
     * Meta informations extracted from the WSDL
     * - documentation: Версия реестра текущая | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $UnloadVersion;
    /**
     * The PrevVersion
     * Meta informations extracted from the WSDL
     * - documentation: Версия реестра предыдущего | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $PrevVersion;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер реестра ограничения | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The IsUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Признак обновления | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsUpdate;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The PrevDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата предыдущей выгрузки | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $PrevDate;
    /**
     * The RecordCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество записей реестра ограничений | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $RecordCount;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RestrictionRegistry
     * @uses RestrictionRegistry::setVersion()
     * @uses RestrictionRegistry::setInternalKey()
     * @uses RestrictionRegistry::setUnloadVersion()
     * @uses RestrictionRegistry::setPrevVersion()
     * @uses RestrictionRegistry::setOspCode()
     * @uses RestrictionRegistry::setDocNumber()
     * @uses RestrictionRegistry::setIsUpdate()
     * @uses RestrictionRegistry::setUnloadDate()
     * @uses RestrictionRegistry::setPrevDate()
     * @uses RestrictionRegistry::setRecordCount()
     * @uses RestrictionRegistry::setId()
     * @param string $version
     * @param int $internalKey
     * @param int $unloadVersion
     * @param int $prevVersion
     * @param string $ospCode
     * @param string $docNumber
     * @param bool $isUpdate
     * @param string $unloadDate
     * @param string $prevDate
     * @param int $recordCount
     * @param string $id
     */
    public function __construct($version = null, $internalKey = null, $unloadVersion = null, $prevVersion = null, $ospCode = null, $docNumber = null, $isUpdate = null, $unloadDate = null, $prevDate = null, $recordCount = null, $id = null)
    {
        $this
            ->setVersion($version)
            ->setInternalKey($internalKey)
            ->setUnloadVersion($unloadVersion)
            ->setPrevVersion($prevVersion)
            ->setOspCode($ospCode)
            ->setDocNumber($docNumber)
            ->setIsUpdate($isUpdate)
            ->setUnloadDate($unloadDate)
            ->setPrevDate($prevDate)
            ->setRecordCount($recordCount)
            ->setId($id);
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setVersion($version = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($version) && strlen($version) > 8) || (is_array($version) && count($version) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($version) ? strlen($version) : count($version)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($version) && strlen($version) < 1) || (is_array($version) && count($version) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get UnloadVersion value
     * @return int|null
     */
    public function getUnloadVersion()
    {
        return $this->UnloadVersion;
    }
    /**
     * Set UnloadVersion value
     * @param int $unloadVersion
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setUnloadVersion($unloadVersion = null)
    {
        // validation for constraint: maxInclusive
        if ($unloadVersion > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $unloadVersion), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unloadVersion < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $unloadVersion), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($unloadVersion) && !is_numeric($unloadVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unloadVersion)), __LINE__);
        }
        $this->UnloadVersion = $unloadVersion;
        return $this;
    }
    /**
     * Get PrevVersion value
     * @return int|null
     */
    public function getPrevVersion()
    {
        return $this->PrevVersion;
    }
    /**
     * Set PrevVersion value
     * @param int $prevVersion
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setPrevVersion($prevVersion = null)
    {
        // validation for constraint: maxInclusive
        if ($prevVersion > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $prevVersion), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($prevVersion < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $prevVersion), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($prevVersion) && !is_numeric($prevVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prevVersion)), __LINE__);
        }
        $this->PrevVersion = $prevVersion;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get IsUpdate value
     * @return bool|null
     */
    public function getIsUpdate()
    {
        return $this->IsUpdate;
    }
    /**
     * Set IsUpdate value
     * @param bool $isUpdate
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setIsUpdate($isUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdate) && !is_bool($isUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdate)), __LINE__);
        }
        $this->IsUpdate = $isUpdate;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setUnloadDate($unloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unloadDate) && !is_string($unloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unloadDate)), __LINE__);
        }
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get PrevDate value
     * @return string|null
     */
    public function getPrevDate()
    {
        return $this->PrevDate;
    }
    /**
     * Set PrevDate value
     * @param string $prevDate
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setPrevDate($prevDate = null)
    {
        // validation for constraint: maxExclusive
        if ($prevDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $prevDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($prevDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $prevDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prevDate) && !is_string($prevDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prevDate)), __LINE__);
        }
        $this->PrevDate = $prevDate;
        return $this;
    }
    /**
     * Get RecordCount value
     * @return int|null
     */
    public function getRecordCount()
    {
        return $this->RecordCount;
    }
    /**
     * Set RecordCount value
     * @param int $recordCount
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setRecordCount($recordCount = null)
    {
        // validation for constraint: maxInclusive
        if ($recordCount > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $recordCount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($recordCount) && !is_numeric($recordCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recordCount)), __LINE__);
        }
        $this->RecordCount = $recordCount;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RestrictionRegistry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
