<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportPropertyType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер ReportProperty «Сведения об имуществе» | Указывается сведения об имуществе.
 * @subpackage Structs
 */
class ReportPropertyType extends AbstractStructBase
{
    /**
     * The CourtOrdersNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер протокола об аресте имущества | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $CourtOrdersNumber;
    /**
     * The CourtOrdersDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата протокола об аресте имущества | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $CourtOrdersDate;
    /**
     * The PropertyKind
     * Meta informations extracted from the WSDL
     * - documentation: Имущество
     * @var string
     */
    public $PropertyKind;
    /**
     * The CauseArrest
     * Meta informations extracted from the WSDL
     * - documentation: Основание ареста | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $CauseArrest;
    /**
     * The Ban
     * Meta informations extracted from the WSDL
     * - documentation: Вид ареста
     * @var string
     */
    public $Ban;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Общее описание | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Description;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма арестованного имущества | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $Data;
    /**
     * Constructor method for ReportPropertyType
     * @uses ReportPropertyType::setCourtOrdersNumber()
     * @uses ReportPropertyType::setCourtOrdersDate()
     * @uses ReportPropertyType::setPropertyKind()
     * @uses ReportPropertyType::setCauseArrest()
     * @uses ReportPropertyType::setBan()
     * @uses ReportPropertyType::setDescription()
     * @uses ReportPropertyType::setAmount()
     * @uses ReportPropertyType::setData()
     * @param string $courtOrdersNumber
     * @param string $courtOrdersDate
     * @param string $propertyKind
     * @param string $causeArrest
     * @param string $ban
     * @param string $description
     * @param float $amount
     * @param \AisFssp\StructType\Data[] $data
     */
    public function __construct($courtOrdersNumber = null, $courtOrdersDate = null, $propertyKind = null, $causeArrest = null, $ban = null, $description = null, $amount = null, array $data = array())
    {
        $this
            ->setCourtOrdersNumber($courtOrdersNumber)
            ->setCourtOrdersDate($courtOrdersDate)
            ->setPropertyKind($propertyKind)
            ->setCauseArrest($causeArrest)
            ->setBan($ban)
            ->setDescription($description)
            ->setAmount($amount)
            ->setData($data);
    }
    /**
     * Get CourtOrdersNumber value
     * @return string|null
     */
    public function getCourtOrdersNumber()
    {
        return $this->CourtOrdersNumber;
    }
    /**
     * Set CourtOrdersNumber value
     * @param string $courtOrdersNumber
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public function setCourtOrdersNumber($courtOrdersNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($courtOrdersNumber) && strlen($courtOrdersNumber) > 25) || (is_array($courtOrdersNumber) && count($courtOrdersNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($courtOrdersNumber) ? strlen($courtOrdersNumber) : count($courtOrdersNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($courtOrdersNumber) && strlen($courtOrdersNumber) < 1) || (is_array($courtOrdersNumber) && count($courtOrdersNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($courtOrdersNumber) && !is_string($courtOrdersNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courtOrdersNumber)), __LINE__);
        }
        $this->CourtOrdersNumber = $courtOrdersNumber;
        return $this;
    }
    /**
     * Get CourtOrdersDate value
     * @return string|null
     */
    public function getCourtOrdersDate()
    {
        return $this->CourtOrdersDate;
    }
    /**
     * Set CourtOrdersDate value
     * @param string $courtOrdersDate
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public function setCourtOrdersDate($courtOrdersDate = null)
    {
        // validation for constraint: maxExclusive
        if ($courtOrdersDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $courtOrdersDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($courtOrdersDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $courtOrdersDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($courtOrdersDate) && !is_string($courtOrdersDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courtOrdersDate)), __LINE__);
        }
        $this->CourtOrdersDate = $courtOrdersDate;
        return $this;
    }
    /**
     * Get PropertyKind value
     * @return string|null
     */
    public function getPropertyKind()
    {
        return $this->PropertyKind;
    }
    /**
     * Set PropertyKind value
     * @uses \AisFssp\EnumType\ObligationPropertyKindType::valueIsValid()
     * @uses \AisFssp\EnumType\ObligationPropertyKindType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyKind
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public function setPropertyKind($propertyKind = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ObligationPropertyKindType::valueIsValid($propertyKind)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $propertyKind, implode(', ', \AisFssp\EnumType\ObligationPropertyKindType::getValidValues())), __LINE__);
        }
        $this->PropertyKind = $propertyKind;
        return $this;
    }
    /**
     * Get CauseArrest value
     * @return string|null
     */
    public function getCauseArrest()
    {
        return $this->CauseArrest;
    }
    /**
     * Set CauseArrest value
     * @param string $causeArrest
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public function setCauseArrest($causeArrest = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($causeArrest) && strlen($causeArrest) > 100) || (is_array($causeArrest) && count($causeArrest) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($causeArrest) ? strlen($causeArrest) : count($causeArrest)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($causeArrest) && strlen($causeArrest) < 1) || (is_array($causeArrest) && count($causeArrest) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($causeArrest) && !is_string($causeArrest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($causeArrest)), __LINE__);
        }
        $this->CauseArrest = $causeArrest;
        return $this;
    }
    /**
     * Get Ban value
     * @return string|null
     */
    public function getBan()
    {
        return $this->Ban;
    }
    /**
     * Set Ban value
     * @uses \AisFssp\EnumType\BanType::valueIsValid()
     * @uses \AisFssp\EnumType\BanType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ban
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public function setBan($ban = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\BanType::valueIsValid($ban)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ban, implode(', ', \AisFssp\EnumType\BanType::getValidValues())), __LINE__);
        }
        $this->Ban = $ban;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 300) || (is_array($description) && count($description) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($amount, strpos($amount, '.')))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public function setData(array $data = array())
    {
        foreach ($data as $reportPropertyTypeDataItem) {
            // validation for constraint: itemType
            if (!$reportPropertyTypeDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($reportPropertyTypeDataItem) ? get_class($reportPropertyTypeDataItem) : gettype($reportPropertyTypeDataItem)), __LINE__);
            }
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ReportPropertyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
