<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Report StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ Report «Уведомление об исполнении» | Содержит уведомление об исполнении | ЭП
 * - type: tns:Report
 * @subpackage Structs
 */
class Report extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор уведомления, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The RestrictnInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления ФССП России | Уникальный идентификатор постановления, присвоенный АИС ФССП России и переданный ранее
     * внешнему контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $RestrictnInternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Уникальный идентификатор исполнительного производства, присвоенный АИС ФССП России и переданный ранее
     * внешнему контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата уведомления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер уведомления | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The RestrDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления об ограничении | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RestrDocDate;
    /**
     * The RestrDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления об ограничении | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $RestrDocNumber;
    /**
     * The RestrictionAnswerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ответа
     * @var string
     */
    public $RestrictionAnswerType;
    /**
     * The LegalImpossibility
     * Meta informations extracted from the WSDL
     * - documentation: Причины невозможности исполнения требований СПИ | Указывается причина невозможности исполнения требования указанных в
     * постановлении. Обязательно к заполнению, если тип ответа "2" | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $LegalImpossibility;
    /**
     * The RestrictedAmount
     * Meta informations extracted from the WSDL
     * - documentation: Общая сумма ареста/взыскания на счете в валюте счета | Указывается сумма ареста (снятия ареста)/взыскания (прекращения
     * обращения взыскания) на счете в валюте счета. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RestrictedAmount;
    /**
     * The RestrictedAmountRub
     * Meta informations extracted from the WSDL
     * - documentation: Общая сумма ареста/взыскания на счете в рублёвом эквиваленте | Указывается сумма ареста (снятия ареста)/взыскания (прекращения
     * обращения взыскания) на счете в рублёвом эквиваленте. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RestrictedAmountRub;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Сведения об исполнении Постановления к исполнению. Содержит список наложенных ограничений (арестов)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $Data;
    /**
     * The RestrictedData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о наложенных ограничениях | Данные, передаваемые в этих полях должны включать в себя все сведения об ограничениях,
     * переданные ранее документом «Постановление к исполнению»
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $RestrictedData;
    /**
     * The NonRestrictedData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об ограничениях, наложение которых невозможно | Данные, передаваемые в этих полях должны включать в себя все сведения
     * об ограничениях, переданные ранее документом «Постановление к исполнению»
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $NonRestrictedData;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Report
     * @uses Report::setExternalKey()
     * @uses Report::setRestrictnInternalKey()
     * @uses Report::setIpInternalKey()
     * @uses Report::setDocDate()
     * @uses Report::setDocNumber()
     * @uses Report::setRestrDocDate()
     * @uses Report::setRestrDocNumber()
     * @uses Report::setRestrictionAnswerType()
     * @uses Report::setLegalImpossibility()
     * @uses Report::setRestrictedAmount()
     * @uses Report::setRestrictedAmountRub()
     * @uses Report::setData()
     * @uses Report::setRestrictedData()
     * @uses Report::setNonRestrictedData()
     * @uses Report::setSignDateTime()
     * @uses Report::setSignature()
     * @uses Report::setId()
     * @param string $externalKey
     * @param int $restrictnInternalKey
     * @param int $ipInternalKey
     * @param string $docDate
     * @param string $docNumber
     * @param string $restrDocDate
     * @param string $restrDocNumber
     * @param string $restrictionAnswerType
     * @param string $legalImpossibility
     * @param float $restrictedAmount
     * @param float $restrictedAmountRub
     * @param \AisFssp\StructType\Data[] $data
     * @param \AisFssp\StructType\Data[] $restrictedData
     * @param \AisFssp\StructType\Data[] $nonRestrictedData
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $restrictnInternalKey = null, $ipInternalKey = null, $docDate = null, $docNumber = null, $restrDocDate = null, $restrDocNumber = null, $restrictionAnswerType = null, $legalImpossibility = null, $restrictedAmount = null, $restrictedAmountRub = null, array $data = array(), array $restrictedData = array(), array $nonRestrictedData = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setRestrictnInternalKey($restrictnInternalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setRestrDocDate($restrDocDate)
            ->setRestrDocNumber($restrDocNumber)
            ->setRestrictionAnswerType($restrictionAnswerType)
            ->setLegalImpossibility($legalImpossibility)
            ->setRestrictedAmount($restrictedAmount)
            ->setRestrictedAmountRub($restrictedAmountRub)
            ->setData($data)
            ->setRestrictedData($restrictedData)
            ->setNonRestrictedData($nonRestrictedData)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\Report
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get RestrictnInternalKey value
     * @return int|null
     */
    public function getRestrictnInternalKey()
    {
        return $this->RestrictnInternalKey;
    }
    /**
     * Set RestrictnInternalKey value
     * @param int $restrictnInternalKey
     * @return \AisFssp\StructType\Report
     */
    public function setRestrictnInternalKey($restrictnInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($restrictnInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $restrictnInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($restrictnInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $restrictnInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($restrictnInternalKey) && !is_numeric($restrictnInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($restrictnInternalKey)), __LINE__);
        }
        $this->RestrictnInternalKey = $restrictnInternalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \AisFssp\StructType\Report
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($ipInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ipInternalKey) && !is_numeric($ipInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipInternalKey)), __LINE__);
        }
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\Report
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\Report
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get RestrDocDate value
     * @return string|null
     */
    public function getRestrDocDate()
    {
        return $this->RestrDocDate;
    }
    /**
     * Set RestrDocDate value
     * @param string $restrDocDate
     * @return \AisFssp\StructType\Report
     */
    public function setRestrDocDate($restrDocDate = null)
    {
        // validation for constraint: maxExclusive
        if ($restrDocDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $restrDocDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($restrDocDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $restrDocDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($restrDocDate) && !is_string($restrDocDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($restrDocDate)), __LINE__);
        }
        $this->RestrDocDate = $restrDocDate;
        return $this;
    }
    /**
     * Get RestrDocNumber value
     * @return string|null
     */
    public function getRestrDocNumber()
    {
        return $this->RestrDocNumber;
    }
    /**
     * Set RestrDocNumber value
     * @param string $restrDocNumber
     * @return \AisFssp\StructType\Report
     */
    public function setRestrDocNumber($restrDocNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($restrDocNumber) && strlen($restrDocNumber) > 25) || (is_array($restrDocNumber) && count($restrDocNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($restrDocNumber) ? strlen($restrDocNumber) : count($restrDocNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($restrDocNumber) && strlen($restrDocNumber) < 1) || (is_array($restrDocNumber) && count($restrDocNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($restrDocNumber) && !is_string($restrDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($restrDocNumber)), __LINE__);
        }
        $this->RestrDocNumber = $restrDocNumber;
        return $this;
    }
    /**
     * Get RestrictionAnswerType value
     * @return string|null
     */
    public function getRestrictionAnswerType()
    {
        return $this->RestrictionAnswerType;
    }
    /**
     * Set RestrictionAnswerType value
     * @uses \AisFssp\EnumType\RestrictionAnswerType::valueIsValid()
     * @uses \AisFssp\EnumType\RestrictionAnswerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrictionAnswerType
     * @return \AisFssp\StructType\Report
     */
    public function setRestrictionAnswerType($restrictionAnswerType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\RestrictionAnswerType::valueIsValid($restrictionAnswerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $restrictionAnswerType, implode(', ', \AisFssp\EnumType\RestrictionAnswerType::getValidValues())), __LINE__);
        }
        $this->RestrictionAnswerType = $restrictionAnswerType;
        return $this;
    }
    /**
     * Get LegalImpossibility value
     * @return string|null
     */
    public function getLegalImpossibility()
    {
        return $this->LegalImpossibility;
    }
    /**
     * Set LegalImpossibility value
     * @param string $legalImpossibility
     * @return \AisFssp\StructType\Report
     */
    public function setLegalImpossibility($legalImpossibility = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($legalImpossibility) && strlen($legalImpossibility) > 4000) || (is_array($legalImpossibility) && count($legalImpossibility) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($legalImpossibility) ? strlen($legalImpossibility) : count($legalImpossibility)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($legalImpossibility) && strlen($legalImpossibility) < 1) || (is_array($legalImpossibility) && count($legalImpossibility) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($legalImpossibility) && !is_string($legalImpossibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legalImpossibility)), __LINE__);
        }
        $this->LegalImpossibility = $legalImpossibility;
        return $this;
    }
    /**
     * Get RestrictedAmount value
     * @return float|null
     */
    public function getRestrictedAmount()
    {
        return $this->RestrictedAmount;
    }
    /**
     * Set RestrictedAmount value
     * @param float $restrictedAmount
     * @return \AisFssp\StructType\Report
     */
    public function setRestrictedAmount($restrictedAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($restrictedAmount) && strlen(substr($restrictedAmount, strpos($restrictedAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($restrictedAmount, strpos($restrictedAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($restrictedAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $restrictedAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($restrictedAmount, strpos($restrictedAmount, '.')))), __LINE__);
        }
        $this->RestrictedAmount = $restrictedAmount;
        return $this;
    }
    /**
     * Get RestrictedAmountRub value
     * @return float|null
     */
    public function getRestrictedAmountRub()
    {
        return $this->RestrictedAmountRub;
    }
    /**
     * Set RestrictedAmountRub value
     * @param float $restrictedAmountRub
     * @return \AisFssp\StructType\Report
     */
    public function setRestrictedAmountRub($restrictedAmountRub = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($restrictedAmountRub) && strlen(substr($restrictedAmountRub, strpos($restrictedAmountRub, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($restrictedAmountRub, strpos($restrictedAmountRub, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($restrictedAmountRub) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $restrictedAmountRub)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($restrictedAmountRub, strpos($restrictedAmountRub, '.')))), __LINE__);
        }
        $this->RestrictedAmountRub = $restrictedAmountRub;
        return $this;
    }
    /**
     * Get Data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\Report
     */
    public function setData(array $data = array())
    {
        foreach ($data as $reportDataItem) {
            // validation for constraint: itemType
            if (!$reportDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($reportDataItem) ? get_class($reportDataItem) : gettype($reportDataItem)), __LINE__);
            }
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\Report
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get RestrictedData value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getRestrictedData()
    {
        return $this->RestrictedData;
    }
    /**
     * Set RestrictedData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $restrictedData
     * @return \AisFssp\StructType\Report
     */
    public function setRestrictedData(array $restrictedData = array())
    {
        foreach ($restrictedData as $reportRestrictedDataItem) {
            // validation for constraint: itemType
            if (!$reportRestrictedDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The RestrictedData property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($reportRestrictedDataItem) ? get_class($reportRestrictedDataItem) : gettype($reportRestrictedDataItem)), __LINE__);
            }
        }
        $this->RestrictedData = $restrictedData;
        return $this;
    }
    /**
     * Add item to RestrictedData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\Report
     */
    public function addToRestrictedData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The RestrictedData property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RestrictedData[] = $item;
        return $this;
    }
    /**
     * Get NonRestrictedData value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getNonRestrictedData()
    {
        return $this->NonRestrictedData;
    }
    /**
     * Set NonRestrictedData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $nonRestrictedData
     * @return \AisFssp\StructType\Report
     */
    public function setNonRestrictedData(array $nonRestrictedData = array())
    {
        foreach ($nonRestrictedData as $reportNonRestrictedDataItem) {
            // validation for constraint: itemType
            if (!$reportNonRestrictedDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The NonRestrictedData property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($reportNonRestrictedDataItem) ? get_class($reportNonRestrictedDataItem) : gettype($reportNonRestrictedDataItem)), __LINE__);
            }
        }
        $this->NonRestrictedData = $nonRestrictedData;
        return $this;
    }
    /**
     * Add item to NonRestrictedData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\Report
     */
    public function addToNonRestrictedData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The NonRestrictedData property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NonRestrictedData[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\Report
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\Report
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $reportSignatureItem) {
            // validation for constraint: itemType
            if (!$reportSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($reportSignatureItem) ? get_class($reportSignatureItem) : gettype($reportSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\Report
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\Report
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Report
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
