<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistryFileResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ для передачи реестров и справочников ФССП России
 * - type: tns:RegistryFileResponse
 * @subpackage Structs
 */
class RegistryFileResponse extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время реестра | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - documentation: Тип справочника
     * - minOccurs: 0
     * @var string
     */
    public $TypeDoc;
    /**
     * The FileUID
     * Meta informations extracted from the WSDL
     * - documentation: Ссылка на файл со справочником или реестром | UID документа
     * - minOccurs: 0
     * - maxLength: 36
     * - minLength: 1
     * @var string
     */
    public $FileUID;
    /**
     * The HasMore
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия реестров в очереди | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $HasMore;
    /**
     * Constructor method for RegistryFileResponse
     * @uses RegistryFileResponse::setInternalKey()
     * @uses RegistryFileResponse::setRequestExternalKey()
     * @uses RegistryFileResponse::setUnloadDate()
     * @uses RegistryFileResponse::setTypeDoc()
     * @uses RegistryFileResponse::setFileUID()
     * @uses RegistryFileResponse::setHasMore()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param string $unloadDate
     * @param string $typeDoc
     * @param string $fileUID
     * @param bool $hasMore
     */
    public function __construct($internalKey = null, $requestExternalKey = null, $unloadDate = null, $typeDoc = null, $fileUID = null, $hasMore = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setUnloadDate($unloadDate)
            ->setTypeDoc($typeDoc)
            ->setFileUID($fileUID)
            ->setHasMore($hasMore);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\RegistryFileResponse
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \AisFssp\StructType\RegistryFileResponse
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) > 60) || (is_array($requestExternalKey) && count($requestExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestExternalKey) ? strlen($requestExternalKey) : count($requestExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) < 1) || (is_array($requestExternalKey) && count($requestExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestExternalKey) && !is_string($requestExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestExternalKey)), __LINE__);
        }
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \AisFssp\StructType\RegistryFileResponse
     */
    public function setUnloadDate($unloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unloadDate) && !is_string($unloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unloadDate)), __LINE__);
        }
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @uses \AisFssp\EnumType\RegistryDocType::valueIsValid()
     * @uses \AisFssp\EnumType\RegistryDocType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeDoc
     * @return \AisFssp\StructType\RegistryFileResponse
     */
    public function setTypeDoc($typeDoc = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\RegistryDocType::valueIsValid($typeDoc)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typeDoc, implode(', ', \AisFssp\EnumType\RegistryDocType::getValidValues())), __LINE__);
        }
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get FileUID value
     * @return string|null
     */
    public function getFileUID()
    {
        return $this->FileUID;
    }
    /**
     * Set FileUID value
     * @param string $fileUID
     * @return \AisFssp\StructType\RegistryFileResponse
     */
    public function setFileUID($fileUID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fileUID) && strlen($fileUID) > 36) || (is_array($fileUID) && count($fileUID) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($fileUID) ? strlen($fileUID) : count($fileUID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fileUID) && strlen($fileUID) < 1) || (is_array($fileUID) && count($fileUID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fileUID) && !is_string($fileUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileUID)), __LINE__);
        }
        $this->FileUID = $fileUID;
        return $this;
    }
    /**
     * Get HasMore value
     * @return bool|null
     */
    public function getHasMore()
    {
        return $this->HasMore;
    }
    /**
     * Set HasMore value
     * @param bool $hasMore
     * @return \AisFssp\StructType\RegistryFileResponse
     */
    public function setHasMore($hasMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMore) && !is_bool($hasMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMore)), __LINE__);
        }
        $this->HasMore = $hasMore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RegistryFileResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
