<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistrationDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о регистрации
 * @subpackage Structs
 */
class RegistrationDatumType extends InformationType
{
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановки на учет | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $startDate;
    /**
     * The finDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата снятия с учета | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finDate;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер | Строка длиной от 1 до 30 символов
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $regNumber;
    /**
     * Constructor method for RegistrationDatumType
     * @uses RegistrationDatumType::setStartDate()
     * @uses RegistrationDatumType::setFinDate()
     * @uses RegistrationDatumType::setRegNumber()
     * @param string $startDate
     * @param string $finDate
     * @param string $regNumber
     */
    public function __construct($startDate = null, $finDate = null, $regNumber = null)
    {
        $this
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setRegNumber($regNumber);
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \AisFssp\StructType\RegistrationDatumType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: maxExclusive
        if ($startDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($startDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get finDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->finDate;
    }
    /**
     * Set finDate value
     * @param string $finDate
     * @return \AisFssp\StructType\RegistrationDatumType
     */
    public function setFinDate($finDate = null)
    {
        // validation for constraint: maxExclusive
        if ($finDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $finDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($finDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $finDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finDate) && !is_string($finDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finDate)), __LINE__);
        }
        $this->finDate = $finDate;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \AisFssp\StructType\RegistrationDatumType
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNumber) && strlen($regNumber) > 30) || (is_array($regNumber) && count($regNumber) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($regNumber) ? strlen($regNumber) : count($regNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regNumber) && strlen($regNumber) < 1) || (is_array($regNumber) && count($regNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNumber)), __LINE__);
        }
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RegistrationDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
