<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос информации справочника
 * - type: tns:ReferenceInfoRequest
 * @subpackage Structs
 */
class ReferenceInfoRequest extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта, присвоенный АИС ФССП России. | Идентификатор объекта, присвоенный АИС ФССП России | Ключ объекта,
     * присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The requestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса списка реквизитов ОСП, полученный ранее от АИС внешнего контрагента. | Идентификатор запроса списка
     * реквизитов ОСП, полученный ранее от АИС внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом
     * (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestExternalKey;
    /**
     * The referenceCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида справочника
     * @var string
     */
    public $referenceCode;
    /**
     * Constructor method for ReferenceInfoRequest
     * @uses ReferenceInfoRequest::setInternalKey()
     * @uses ReferenceInfoRequest::setRequestExternalKey()
     * @uses ReferenceInfoRequest::setReferenceCode()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param string $referenceCode
     */
    public function __construct($internalKey = null, $requestExternalKey = null, $referenceCode = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setReferenceCode($referenceCode);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\ReferenceInfoRequest
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get requestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->requestExternalKey;
    }
    /**
     * Set requestExternalKey value
     * @param string $requestExternalKey
     * @return \AisFssp\StructType\ReferenceInfoRequest
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) > 60) || (is_array($requestExternalKey) && count($requestExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestExternalKey) ? strlen($requestExternalKey) : count($requestExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) < 1) || (is_array($requestExternalKey) && count($requestExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestExternalKey) && !is_string($requestExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestExternalKey)), __LINE__);
        }
        $this->requestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get referenceCode value
     * @return string|null
     */
    public function getReferenceCode()
    {
        return $this->referenceCode;
    }
    /**
     * Set referenceCode value
     * @uses \AisFssp\EnumType\LookupTableType::valueIsValid()
     * @uses \AisFssp\EnumType\LookupTableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $referenceCode
     * @return \AisFssp\StructType\ReferenceInfoRequest
     */
    public function setReferenceCode($referenceCode = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\LookupTableType::valueIsValid($referenceCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $referenceCode, implode(', ', \AisFssp\EnumType\LookupTableType::getValidValues())), __LINE__);
        }
        $this->referenceCode = $referenceCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ReferenceInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
