<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных «Данные справочника» используется для передачи данных одного справочника в документе «Информация справочника»
 * @subpackage Structs
 */
class ReferenceDataType extends AbstractStructBase
{
    /**
     * The referenceCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида справочника
     * - minOccurs: 1
     * @var string
     */
    public $referenceCode;
    /**
     * The osp
     * Meta informations extracted from the WSDL
     * - documentation: Данные справочника ВКСП | Используется только один тип передаваемых данных в соответствии со значением поля «Код вида
     * справочника»
     * @var \AisFssp\StructType\OspProperty
     */
    public $osp;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - documentation: Данные справочника «Валюты»
     * @var \AisFssp\StructType\CurrencyProperty
     */
    public $currency;
    /**
     * The idDocType
     * Meta informations extracted from the WSDL
     * - documentation: Данные справочника «Типы документов, удостоверяющих личность»
     * @var \AisFssp\StructType\IdDocTypeProperty
     */
    public $idDocType;
    /**
     * Constructor method for ReferenceDataType
     * @uses ReferenceDataType::setReferenceCode()
     * @uses ReferenceDataType::setOsp()
     * @uses ReferenceDataType::setCurrency()
     * @uses ReferenceDataType::setIdDocType()
     * @param string $referenceCode
     * @param \AisFssp\StructType\OspProperty $osp
     * @param \AisFssp\StructType\CurrencyProperty $currency
     * @param \AisFssp\StructType\IdDocTypeProperty $idDocType
     */
    public function __construct($referenceCode = null, \AisFssp\StructType\OspProperty $osp = null, \AisFssp\StructType\CurrencyProperty $currency = null, \AisFssp\StructType\IdDocTypeProperty $idDocType = null)
    {
        $this
            ->setReferenceCode($referenceCode)
            ->setOsp($osp)
            ->setCurrency($currency)
            ->setIdDocType($idDocType);
    }
    /**
     * Get referenceCode value
     * @return string
     */
    public function getReferenceCode()
    {
        return $this->referenceCode;
    }
    /**
     * Set referenceCode value
     * @uses \AisFssp\EnumType\LookupTableType::valueIsValid()
     * @uses \AisFssp\EnumType\LookupTableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $referenceCode
     * @return \AisFssp\StructType\ReferenceDataType
     */
    public function setReferenceCode($referenceCode = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\LookupTableType::valueIsValid($referenceCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $referenceCode, implode(', ', \AisFssp\EnumType\LookupTableType::getValidValues())), __LINE__);
        }
        $this->referenceCode = $referenceCode;
        return $this;
    }
    /**
     * Get osp value
     * @return \AisFssp\StructType\OspProperty|null
     */
    public function getOsp()
    {
        return $this->osp;
    }
    /**
     * Set osp value
     * @param \AisFssp\StructType\OspProperty $osp
     * @return \AisFssp\StructType\ReferenceDataType
     */
    public function setOsp(\AisFssp\StructType\OspProperty $osp = null)
    {
        $this->osp = $osp;
        return $this;
    }
    /**
     * Get currency value
     * @return \AisFssp\StructType\CurrencyProperty|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \AisFssp\StructType\CurrencyProperty $currency
     * @return \AisFssp\StructType\ReferenceDataType
     */
    public function setCurrency(\AisFssp\StructType\CurrencyProperty $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get idDocType value
     * @return \AisFssp\StructType\IdDocTypeProperty|null
     */
    public function getIdDocType()
    {
        return $this->idDocType;
    }
    /**
     * Set idDocType value
     * @param \AisFssp\StructType\IdDocTypeProperty $idDocType
     * @return \AisFssp\StructType\ReferenceDataType
     */
    public function setIdDocType(\AisFssp\StructType\IdDocTypeProperty $idDocType = null)
    {
        $this->idDocType = $idDocType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ReferenceDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
