<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedAddress StructType
 * Meta informations extracted from the WSDL
 * - documentation: Адрес в формате "Ред Софт" | Адрес в формате "Ред Софт"
 * @subpackage Structs
 */
class RedAddress extends AbstractStructBase
{
    /**
     * The Org
     * Meta informations extracted from the WSDL
     * - documentation: Код организации | Код организации межведомственного обмена
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Org;
    /**
     * The Dept
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Код подразделения организации межведомственного обмена
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $Dept;
    /**
     * The OrganizationCode
     * Meta informations extracted from the WSDL
     * - documentation: Код организации | Код организации | NSI_MVV_Organization
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $OrganizationCode;
    /**
     * The DepartmentCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $DepartmentCode;
    /**
     * The Protocol
     * Meta informations extracted from the WSDL
     * - documentation: Код соглашения (протокола обмена данными) | Для данной версии протокола значение «общее_0.5» и «МВВ_ТРАНЗИТ_2.0». | Код соглашения
     * (протокола)
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Protocol;
    /**
     * Constructor method for RedAddress
     * @uses RedAddress::setOrg()
     * @uses RedAddress::setDept()
     * @uses RedAddress::setOrganizationCode()
     * @uses RedAddress::setDepartmentCode()
     * @uses RedAddress::setProtocol()
     * @param string $org
     * @param string $dept
     * @param string $organizationCode
     * @param string $departmentCode
     * @param string $protocol
     */
    public function __construct($org = null, $dept = null, $organizationCode = null, $departmentCode = null, $protocol = null)
    {
        $this
            ->setOrg($org)
            ->setDept($dept)
            ->setOrganizationCode($organizationCode)
            ->setDepartmentCode($departmentCode)
            ->setProtocol($protocol);
    }
    /**
     * Get Org value
     * @return string|null
     */
    public function getOrg()
    {
        return $this->Org;
    }
    /**
     * Set Org value
     * @param string $org
     * @return \AisFssp\StructType\RedAddress
     */
    public function setOrg($org = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($org) && strlen($org) > 10) || (is_array($org) && count($org) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($org) ? strlen($org) : count($org)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($org) && strlen($org) < 1) || (is_array($org) && count($org) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($org) && !is_string($org)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($org)), __LINE__);
        }
        $this->Org = $org;
        return $this;
    }
    /**
     * Get Dept value
     * @return string|null
     */
    public function getDept()
    {
        return $this->Dept;
    }
    /**
     * Set Dept value
     * @param string $dept
     * @return \AisFssp\StructType\RedAddress
     */
    public function setDept($dept = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dept) && strlen($dept) > 320) || (is_array($dept) && count($dept) > 320)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 320 element(s) or a scalar of 320 character(s) at most, "%d" length given', is_scalar($dept) ? strlen($dept) : count($dept)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($dept) && strlen($dept) < 1) || (is_array($dept) && count($dept) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dept) && !is_string($dept)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dept)), __LINE__);
        }
        $this->Dept = $dept;
        return $this;
    }
    /**
     * Get OrganizationCode value
     * @return string|null
     */
    public function getOrganizationCode()
    {
        return $this->OrganizationCode;
    }
    /**
     * Set OrganizationCode value
     * @param string $organizationCode
     * @return \AisFssp\StructType\RedAddress
     */
    public function setOrganizationCode($organizationCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organizationCode) && strlen($organizationCode) > 20) || (is_array($organizationCode) && count($organizationCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($organizationCode) ? strlen($organizationCode) : count($organizationCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organizationCode) && strlen($organizationCode) < 1) || (is_array($organizationCode) && count($organizationCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organizationCode) && !is_string($organizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organizationCode)), __LINE__);
        }
        $this->OrganizationCode = $organizationCode;
        return $this;
    }
    /**
     * Get DepartmentCode value
     * @return string|null
     */
    public function getDepartmentCode()
    {
        return $this->DepartmentCode;
    }
    /**
     * Set DepartmentCode value
     * @param string $departmentCode
     * @return \AisFssp\StructType\RedAddress
     */
    public function setDepartmentCode($departmentCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($departmentCode) && strlen($departmentCode) > 320) || (is_array($departmentCode) && count($departmentCode) > 320)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 320 element(s) or a scalar of 320 character(s) at most, "%d" length given', is_scalar($departmentCode) ? strlen($departmentCode) : count($departmentCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($departmentCode) && strlen($departmentCode) < 1) || (is_array($departmentCode) && count($departmentCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($departmentCode) && !is_string($departmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departmentCode)), __LINE__);
        }
        $this->DepartmentCode = $departmentCode;
        return $this;
    }
    /**
     * Get Protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->Protocol;
    }
    /**
     * Set Protocol value
     * @param string $protocol
     * @return \AisFssp\StructType\RedAddress
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($protocol) && strlen($protocol) > 50) || (is_array($protocol) && count($protocol) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($protocol) ? strlen($protocol) : count($protocol)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($protocol) && strlen($protocol) < 1) || (is_array($protocol) && count($protocol) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protocol)), __LINE__);
        }
        $this->Protocol = $protocol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RedAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
