<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecoveringIpInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на запрос о полученных физическим лицом суммах, взысканных по ИП
 * @subpackage Structs
 */
class RecoveringIpInfoType extends AbstractStructBase
{
    /**
     * The Plaintiff
     * Meta informations extracted from the WSDL
     * - documentation: Взыскатель
     * @var \AisFssp\StructType\ContragentDatumType
     */
    public $Plaintiff;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об ИП
     * @var \AisFssp\StructType\IP
     */
    public $IP;
    /**
     * The RecoveredAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о взысканных суммах
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\RecoveredAmountType[]
     */
    public $RecoveredAmount;
    /**
     * Constructor method for RecoveringIpInfoType
     * @uses RecoveringIpInfoType::setPlaintiff()
     * @uses RecoveringIpInfoType::setIP()
     * @uses RecoveringIpInfoType::setRecoveredAmount()
     * @param \AisFssp\StructType\ContragentDatumType $plaintiff
     * @param \AisFssp\StructType\IP $iP
     * @param \AisFssp\StructType\RecoveredAmountType[] $recoveredAmount
     */
    public function __construct(\AisFssp\StructType\ContragentDatumType $plaintiff = null, \AisFssp\StructType\IP $iP = null, array $recoveredAmount = array())
    {
        $this
            ->setPlaintiff($plaintiff)
            ->setIP($iP)
            ->setRecoveredAmount($recoveredAmount);
    }
    /**
     * Get Plaintiff value
     * @return \AisFssp\StructType\ContragentDatumType|null
     */
    public function getPlaintiff()
    {
        return $this->Plaintiff;
    }
    /**
     * Set Plaintiff value
     * @param \AisFssp\StructType\ContragentDatumType $plaintiff
     * @return \AisFssp\StructType\RecoveringIpInfoType
     */
    public function setPlaintiff(\AisFssp\StructType\ContragentDatumType $plaintiff = null)
    {
        $this->Plaintiff = $plaintiff;
        return $this;
    }
    /**
     * Get IP value
     * @return \AisFssp\StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \AisFssp\StructType\IP $iP
     * @return \AisFssp\StructType\RecoveringIpInfoType
     */
    public function setIP(\AisFssp\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get RecoveredAmount value
     * @return \AisFssp\StructType\RecoveredAmountType[]|null
     */
    public function getRecoveredAmount()
    {
        return $this->RecoveredAmount;
    }
    /**
     * Set RecoveredAmount value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecoveredAmountType[] $recoveredAmount
     * @return \AisFssp\StructType\RecoveringIpInfoType
     */
    public function setRecoveredAmount(array $recoveredAmount = array())
    {
        foreach ($recoveredAmount as $recoveringIpInfoTypeRecoveredAmountItem) {
            // validation for constraint: itemType
            if (!$recoveringIpInfoTypeRecoveredAmountItem instanceof \AisFssp\StructType\RecoveredAmountType) {
                throw new \InvalidArgumentException(sprintf('The RecoveredAmount property can only contain items of \AisFssp\StructType\RecoveredAmountType, "%s" given', is_object($recoveringIpInfoTypeRecoveredAmountItem) ? get_class($recoveringIpInfoTypeRecoveredAmountItem) : gettype($recoveringIpInfoTypeRecoveredAmountItem)), __LINE__);
            }
        }
        $this->RecoveredAmount = $recoveredAmount;
        return $this;
    }
    /**
     * Add item to RecoveredAmount value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecoveredAmountType $item
     * @return \AisFssp\StructType\RecoveringIpInfoType
     */
    public function addToRecoveredAmount(\AisFssp\StructType\RecoveredAmountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\RecoveredAmountType) {
            throw new \InvalidArgumentException(sprintf('The RecoveredAmount property can only contain items of \AisFssp\StructType\RecoveredAmountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RecoveredAmount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RecoveringIpInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
