<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Query StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ Query "Запрос СПИ" | ЭП
 * - type: tns:Query
 * @subpackage Structs
 */
class Query extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Содержит уникальный идентификатор, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер запроса | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ, сделавшего запрос | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО полностью СПИ, сделавшего запрос | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIFioParts
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО СПИ, сделавшего запрос. Заполняется только в том случае, если соответствующие данные есть в системе. Для запросов к
     * операторам сотовой связи обязательно.
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $SPIFioParts;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ, сделавшего запрос | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The ChSPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО старшего СПИ | ФИО полностью Старшего СПИ, разрешившего запрос | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ChSPIFio;
    /**
     * The ChSPIFioParts
     * Meta informations extracted from the WSDL
     * - documentation: ФИО старшего СПИ | Код должности Старшего СПИ, разрешившего запрос. Для запросов к операторам сотовой связи обязательно.
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $ChSPIFioParts;
    /**
     * The ChSPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность старшего СПИ | Код должности Старшего СПИ, разрешившего запрос | Код должности СПИ
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $ChSPIPost;
    /**
     * The AnsDate
     * Meta informations extracted from the WSDL
     * - documentation: Срок ответа | Срок ответа, установленный СПИ | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AnsDate;
    /**
     * The SearchCountryCode
     * Meta informations extracted from the WSDL
     * - documentation: Страна поиска | Ограничение по стране поиска (код страны по ОКСМ) | Код страны цифровой | Цифровой код страны по ОКСМ
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9]{3}
     * @var string
     */
    public $SearchCountryCode;
    /**
     * The SearchCountryName
     * Meta informations extracted from the WSDL
     * - documentation: Страна поиска | Ограничение по стране поиска (наименование страны) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $SearchCountryName;
    /**
     * The SearchRegion
     * Meta informations extracted from the WSDL
     * - documentation: Регион поиска | Ограничение по региону поиска (код региона) | Код региона по КЛАДР
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $SearchRegion;
    /**
     * The SearchYear
     * Meta informations extracted from the WSDL
     * - documentation: Год поиска | Ограничение по году поиска (год, за который необходимо предоставить сведения) | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $SearchYear;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата создания | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $CreateDate;
    /**
     * The DocCode
     * Meta informations extracted from the WSDL
     * - documentation: Код документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocCode;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: Исполнительное производство | Сведения об исполнительном производстве
     * @var \AisFssp\StructType\IP
     */
    public $IP;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Используется при уточнении реквизитов должника
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $Data;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Query
     * @uses Query::setInternalKey()
     * @uses Query::setDocDate()
     * @uses Query::setDocNumber()
     * @uses Query::setSPI()
     * @uses Query::setSPIFio()
     * @uses Query::setSPIFioParts()
     * @uses Query::setSPITel()
     * @uses Query::setSPIPost()
     * @uses Query::setChSPIFio()
     * @uses Query::setChSPIFioParts()
     * @uses Query::setChSPIPost()
     * @uses Query::setAnsDate()
     * @uses Query::setSearchCountryCode()
     * @uses Query::setSearchCountryName()
     * @uses Query::setSearchRegion()
     * @uses Query::setSearchYear()
     * @uses Query::setCreateDate()
     * @uses Query::setDocCode()
     * @uses Query::setIP()
     * @uses Query::setData()
     * @uses Query::setAttachments()
     * @uses Query::setSignDateTime()
     * @uses Query::setSignature()
     * @uses Query::setId()
     * @param int $internalKey
     * @param string $docDate
     * @param string $docNumber
     * @param int $sPI
     * @param string $sPIFio
     * @param \AisFssp\StructType\FioType $sPIFioParts
     * @param string $sPITel
     * @param string $sPIPost
     * @param string $chSPIFio
     * @param \AisFssp\StructType\FioType $chSPIFioParts
     * @param string $chSPIPost
     * @param string $ansDate
     * @param string $searchCountryCode
     * @param string $searchCountryName
     * @param string $searchRegion
     * @param string $searchYear
     * @param string $createDate
     * @param string $docCode
     * @param \AisFssp\StructType\IP $iP
     * @param \AisFssp\StructType\Data[] $data
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $docDate = null, $docNumber = null, $sPI = null, $sPIFio = null, \AisFssp\StructType\FioType $sPIFioParts = null, $sPITel = null, $sPIPost = null, $chSPIFio = null, \AisFssp\StructType\FioType $chSPIFioParts = null, $chSPIPost = null, $ansDate = null, $searchCountryCode = null, $searchCountryName = null, $searchRegion = null, $searchYear = null, $createDate = null, $docCode = null, \AisFssp\StructType\IP $iP = null, array $data = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPIFioParts($sPIFioParts)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost)
            ->setChSPIFio($chSPIFio)
            ->setChSPIFioParts($chSPIFioParts)
            ->setChSPIPost($chSPIPost)
            ->setAnsDate($ansDate)
            ->setSearchCountryCode($searchCountryCode)
            ->setSearchCountryName($searchCountryName)
            ->setSearchRegion($searchRegion)
            ->setSearchYear($searchYear)
            ->setCreateDate($createDate)
            ->setDocCode($docCode)
            ->setIP($iP)
            ->setData($data)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\Query
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\Query
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\Query
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \AisFssp\StructType\Query
     */
    public function setSPI($sPI = null)
    {
        // validation for constraint: maxInclusive
        if ($sPI > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($sPI < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($sPI) && !is_numeric($sPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sPI)), __LINE__);
        }
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \AisFssp\StructType\Query
     */
    public function setSPIFio($sPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) > 100) || (is_array($sPIFio) && count($sPIFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($sPIFio) ? strlen($sPIFio) : count($sPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) < 1) || (is_array($sPIFio) && count($sPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIFio) && !is_string($sPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIFio)), __LINE__);
        }
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIFioParts value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getSPIFioParts()
    {
        return $this->SPIFioParts;
    }
    /**
     * Set SPIFioParts value
     * @param \AisFssp\StructType\FioType $sPIFioParts
     * @return \AisFssp\StructType\Query
     */
    public function setSPIFioParts(\AisFssp\StructType\FioType $sPIFioParts = null)
    {
        $this->SPIFioParts = $sPIFioParts;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \AisFssp\StructType\Query
     */
    public function setSPITel($sPITel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPITel) && strlen($sPITel) > 25) || (is_array($sPITel) && count($sPITel) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPITel) ? strlen($sPITel) : count($sPITel)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPITel) && strlen($sPITel) < 1) || (is_array($sPITel) && count($sPITel) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPITel) && !is_string($sPITel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPITel)), __LINE__);
        }
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \AisFssp\StructType\Query
     */
    public function setSPIPost($sPIPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) > 25) || (is_array($sPIPost) && count($sPIPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPIPost) ? strlen($sPIPost) : count($sPIPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) < 1) || (is_array($sPIPost) && count($sPIPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sPIPost) && !preg_match('/[0-9\\-\\.\\s]+/', $sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($sPIPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIPost) && !is_string($sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIPost)), __LINE__);
        }
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get ChSPIFio value
     * @return string|null
     */
    public function getChSPIFio()
    {
        return $this->ChSPIFio;
    }
    /**
     * Set ChSPIFio value
     * @param string $chSPIFio
     * @return \AisFssp\StructType\Query
     */
    public function setChSPIFio($chSPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chSPIFio) && strlen($chSPIFio) > 100) || (is_array($chSPIFio) && count($chSPIFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($chSPIFio) ? strlen($chSPIFio) : count($chSPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chSPIFio) && strlen($chSPIFio) < 1) || (is_array($chSPIFio) && count($chSPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chSPIFio) && !is_string($chSPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chSPIFio)), __LINE__);
        }
        $this->ChSPIFio = $chSPIFio;
        return $this;
    }
    /**
     * Get ChSPIFioParts value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getChSPIFioParts()
    {
        return $this->ChSPIFioParts;
    }
    /**
     * Set ChSPIFioParts value
     * @param \AisFssp\StructType\FioType $chSPIFioParts
     * @return \AisFssp\StructType\Query
     */
    public function setChSPIFioParts(\AisFssp\StructType\FioType $chSPIFioParts = null)
    {
        $this->ChSPIFioParts = $chSPIFioParts;
        return $this;
    }
    /**
     * Get ChSPIPost value
     * @return string|null
     */
    public function getChSPIPost()
    {
        return $this->ChSPIPost;
    }
    /**
     * Set ChSPIPost value
     * @param string $chSPIPost
     * @return \AisFssp\StructType\Query
     */
    public function setChSPIPost($chSPIPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chSPIPost) && strlen($chSPIPost) > 25) || (is_array($chSPIPost) && count($chSPIPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($chSPIPost) ? strlen($chSPIPost) : count($chSPIPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chSPIPost) && strlen($chSPIPost) < 1) || (is_array($chSPIPost) && count($chSPIPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($chSPIPost) && !preg_match('/[0-9\\-\\.\\s]+/', $chSPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($chSPIPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chSPIPost) && !is_string($chSPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chSPIPost)), __LINE__);
        }
        $this->ChSPIPost = $chSPIPost;
        return $this;
    }
    /**
     * Get AnsDate value
     * @return string|null
     */
    public function getAnsDate()
    {
        return $this->AnsDate;
    }
    /**
     * Set AnsDate value
     * @param string $ansDate
     * @return \AisFssp\StructType\Query
     */
    public function setAnsDate($ansDate = null)
    {
        // validation for constraint: maxExclusive
        if ($ansDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $ansDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ansDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $ansDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ansDate) && !is_string($ansDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ansDate)), __LINE__);
        }
        $this->AnsDate = $ansDate;
        return $this;
    }
    /**
     * Get SearchCountryCode value
     * @return string|null
     */
    public function getSearchCountryCode()
    {
        return $this->SearchCountryCode;
    }
    /**
     * Set SearchCountryCode value
     * @param string $searchCountryCode
     * @return \AisFssp\StructType\Query
     */
    public function setSearchCountryCode($searchCountryCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($searchCountryCode) && strlen($searchCountryCode) !== 3) || (is_array($searchCountryCode) && count($searchCountryCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($searchCountryCode) && !preg_match('/[0-9]{3}/', $searchCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{3}", "%s" given', var_export($searchCountryCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($searchCountryCode) && !is_string($searchCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchCountryCode)), __LINE__);
        }
        $this->SearchCountryCode = $searchCountryCode;
        return $this;
    }
    /**
     * Get SearchCountryName value
     * @return string|null
     */
    public function getSearchCountryName()
    {
        return $this->SearchCountryName;
    }
    /**
     * Set SearchCountryName value
     * @param string $searchCountryName
     * @return \AisFssp\StructType\Query
     */
    public function setSearchCountryName($searchCountryName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($searchCountryName) && strlen($searchCountryName) > 255) || (is_array($searchCountryName) && count($searchCountryName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($searchCountryName) ? strlen($searchCountryName) : count($searchCountryName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($searchCountryName) && strlen($searchCountryName) < 1) || (is_array($searchCountryName) && count($searchCountryName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($searchCountryName) && !is_string($searchCountryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchCountryName)), __LINE__);
        }
        $this->SearchCountryName = $searchCountryName;
        return $this;
    }
    /**
     * Get SearchRegion value
     * @return string|null
     */
    public function getSearchRegion()
    {
        return $this->SearchRegion;
    }
    /**
     * Set SearchRegion value
     * @param string $searchRegion
     * @return \AisFssp\StructType\Query
     */
    public function setSearchRegion($searchRegion = null)
    {
        // validation for constraint: length
        if ((is_scalar($searchRegion) && strlen($searchRegion) !== 2) || (is_array($searchRegion) && count($searchRegion) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($searchRegion) && !preg_match('/[0-9]{2}/', $searchRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{2}", "%s" given', var_export($searchRegion, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($searchRegion) && !is_string($searchRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchRegion)), __LINE__);
        }
        $this->SearchRegion = $searchRegion;
        return $this;
    }
    /**
     * Get SearchYear value
     * @return string|null
     */
    public function getSearchYear()
    {
        return $this->SearchYear;
    }
    /**
     * Set SearchYear value
     * @param string $searchYear
     * @return \AisFssp\StructType\Query
     */
    public function setSearchYear($searchYear = null)
    {
        // validation for constraint: maxInclusive
        if ($searchYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $searchYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($searchYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $searchYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($searchYear) && !is_string($searchYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchYear)), __LINE__);
        }
        $this->SearchYear = $searchYear;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \AisFssp\StructType\Query
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: maxExclusive
        if ($createDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $createDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($createDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $createDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get DocCode value
     * @return string|null
     */
    public function getDocCode()
    {
        return $this->DocCode;
    }
    /**
     * Set DocCode value
     * @param string $docCode
     * @return \AisFssp\StructType\Query
     */
    public function setDocCode($docCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docCode) && strlen($docCode) > 1) || (is_array($docCode) && count($docCode) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docCode) ? strlen($docCode) : count($docCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docCode) && strlen($docCode) < 1) || (is_array($docCode) && count($docCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docCode) && !is_string($docCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docCode)), __LINE__);
        }
        $this->DocCode = $docCode;
        return $this;
    }
    /**
     * Get IP value
     * @return \AisFssp\StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \AisFssp\StructType\IP $iP
     * @return \AisFssp\StructType\Query
     */
    public function setIP(\AisFssp\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get Data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\Query
     */
    public function setData(array $data = array())
    {
        foreach ($data as $queryDataItem) {
            // validation for constraint: itemType
            if (!$queryDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($queryDataItem) ? get_class($queryDataItem) : gettype($queryDataItem)), __LINE__);
            }
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\Query
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\Query
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $queryAttachmentsItem) {
            // validation for constraint: itemType
            if (!$queryAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($queryAttachmentsItem) ? get_class($queryAttachmentsItem) : gettype($queryAttachmentsItem)), __LINE__);
            }
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\Query
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\Query
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\Query
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $querySignatureItem) {
            // validation for constraint: itemType
            if (!$querySignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($querySignatureItem) ? get_class($querySignatureItem) : gettype($querySignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\Query
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\Query
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Query
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
