<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcDoc StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ProcDoc «Постановление СПИ» | Содержит сведения о постановлении СПИ, направленном в адрес стороны ИП | ЭП
 * - type: tns:ProcDoc
 * @subpackage Structs
 */
class ProcDoc extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор постановления, присвоенный АИС ФССП России | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ, вынесшего постановление | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО полностью СПИ, утвердившего документ | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ, утвердившего документ | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Штрих-код | Штрих-код документа в формате code 39. Значение этого поля имеет формат: «NNNNNNNNN/DDDD-Y...Y», где NNNNNNNNN — числовой
     * идентификатор документа, DDDD — код отдела СП по справочнику ВКСП, Y...Y -номер копии. | Штрих-код в формате code39
     * - minOccurs: 0
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string
     */
    public $Barcode;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип постановления | Код документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного
     * документооборота | NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The Sum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Содержит сумму, указанную в постановлении | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Sum;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Основание решения СПИ | Текст основания принятия решения | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Reason;
    /**
     * The Article
     * Meta informations extracted from the WSDL
     * - documentation: Статья | Статья основания решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Article;
    /**
     * The Point
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи | Пункт статьи основания | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Point;
    /**
     * The Part
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт | Подпункт статьи основания решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Part;
    /**
     * The NewOspCode
     * Meta informations extracted from the WSDL
     * - documentation: Номер отдела в который передается ИП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $NewOspCode;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - documentation: ДатаНачалаПериода | Дата начала периода приостановление, отложения, рассрочки, отсрочки | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - documentation: ДатаОкончанияПериода | Дата окончания периода приостановление, отложения, рассрочки, отсрочки | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $EndDate;
    /**
     * The ResolutionBase
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Оригинал постановления СПИ, вынесенного в соответствии с Приказом ФССП России от 22.04.2015 № 248 «Об
     * утверждении требований к формату постановления судебного пристава-исполнителя или иного должностного лица Федеральной службы
     * судебных приставов, вынесенного в форме электронного документа» в форме электронного документа в формате в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $ResolutionBase;
    /**
     * The SignatureResolutionBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП постановления СПИ | ЭП постановления СПИ вынесенного в электронном виде, элемента «ResolutionBase» в формате pkcs#7
     * - minOccurs: 0
     * @var string
     */
    public $SignatureResolutionBase;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: ИП | Содержит основные сведения об исполнительном производстве и должнике
     * @var \AisFssp\StructType\IP
     */
    public $IP;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Сведения о должнике, указанные в постановлении СПИ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $Data;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ProcDoc
     * @uses ProcDoc::setInternalKey()
     * @uses ProcDoc::setDocDate()
     * @uses ProcDoc::setSPI()
     * @uses ProcDoc::setSPIFio()
     * @uses ProcDoc::setSPITel()
     * @uses ProcDoc::setSPIPost()
     * @uses ProcDoc::setDocNum()
     * @uses ProcDoc::setBarcode()
     * @uses ProcDoc::setDocType()
     * @uses ProcDoc::setSum()
     * @uses ProcDoc::setReason()
     * @uses ProcDoc::setArticle()
     * @uses ProcDoc::setPoint()
     * @uses ProcDoc::setPart()
     * @uses ProcDoc::setNewOspCode()
     * @uses ProcDoc::setBeginDate()
     * @uses ProcDoc::setEndDate()
     * @uses ProcDoc::setResolutionBase()
     * @uses ProcDoc::setSignatureResolutionBase()
     * @uses ProcDoc::setIP()
     * @uses ProcDoc::setData()
     * @uses ProcDoc::setSignDateTime()
     * @uses ProcDoc::setSignature()
     * @uses ProcDoc::setId()
     * @param int $internalKey
     * @param string $docDate
     * @param int $sPI
     * @param string $sPIFio
     * @param string $sPITel
     * @param string $sPIPost
     * @param string $docNum
     * @param string $barcode
     * @param string $docType
     * @param float $sum
     * @param string $reason
     * @param string $article
     * @param string $point
     * @param string $part
     * @param string $newOspCode
     * @param string $beginDate
     * @param string $endDate
     * @param string $resolutionBase
     * @param string $signatureResolutionBase
     * @param \AisFssp\StructType\IP $iP
     * @param \AisFssp\StructType\Data[] $data
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $docDate = null, $sPI = null, $sPIFio = null, $sPITel = null, $sPIPost = null, $docNum = null, $barcode = null, $docType = null, $sum = null, $reason = null, $article = null, $point = null, $part = null, $newOspCode = null, $beginDate = null, $endDate = null, $resolutionBase = null, $signatureResolutionBase = null, \AisFssp\StructType\IP $iP = null, array $data = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setDocDate($docDate)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost)
            ->setDocNum($docNum)
            ->setBarcode($barcode)
            ->setDocType($docType)
            ->setSum($sum)
            ->setReason($reason)
            ->setArticle($article)
            ->setPoint($point)
            ->setPart($part)
            ->setNewOspCode($newOspCode)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setResolutionBase($resolutionBase)
            ->setSignatureResolutionBase($signatureResolutionBase)
            ->setIP($iP)
            ->setData($data)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setSPI($sPI = null)
    {
        // validation for constraint: maxInclusive
        if ($sPI > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($sPI < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($sPI) && !is_numeric($sPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sPI)), __LINE__);
        }
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setSPIFio($sPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) > 100) || (is_array($sPIFio) && count($sPIFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($sPIFio) ? strlen($sPIFio) : count($sPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) < 1) || (is_array($sPIFio) && count($sPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIFio) && !is_string($sPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIFio)), __LINE__);
        }
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setSPITel($sPITel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPITel) && strlen($sPITel) > 25) || (is_array($sPITel) && count($sPITel) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPITel) ? strlen($sPITel) : count($sPITel)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPITel) && strlen($sPITel) < 1) || (is_array($sPITel) && count($sPITel) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPITel) && !is_string($sPITel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPITel)), __LINE__);
        }
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setSPIPost($sPIPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) > 25) || (is_array($sPIPost) && count($sPIPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPIPost) ? strlen($sPIPost) : count($sPIPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) < 1) || (is_array($sPIPost) && count($sPIPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sPIPost) && !preg_match('/[0-9\\-\\.\\s]+/', $sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($sPIPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIPost) && !is_string($sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIPost)), __LINE__);
        }
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setDocNum($docNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNum) && strlen($docNum) > 25) || (is_array($docNum) && count($docNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNum) ? strlen($docNum) : count($docNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNum) && strlen($docNum) < 1) || (is_array($docNum) && count($docNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNum) && !is_string($docNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNum)), __LINE__);
        }
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($barcode) && strlen($barcode) > 44) || (is_array($barcode) && count($barcode) > 44)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 44 element(s) or a scalar of 44 character(s) at most, "%d" length given', is_scalar($barcode) ? strlen($barcode) : count($barcode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($barcode) && strlen($barcode) < 1) || (is_array($barcode) && count($barcode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($barcode) && !preg_match('/[0-9A-Z\\-\\.\\+$\/%]+/', $barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z\-\.\+$/%]+", "%s" given', var_export($barcode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docType) && strlen($docType) > 1) || (is_array($docType) && count($docType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docType) ? strlen($docType) : count($docType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docType) && strlen($docType) < 1) || (is_array($docType) && count($docType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get Sum value
     * @return float|null
     */
    public function getSum()
    {
        return $this->Sum;
    }
    /**
     * Set Sum value
     * @param float $sum
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setSum($sum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($sum) && strlen(substr($sum, strpos($sum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($sum, strpos($sum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($sum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $sum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($sum, strpos($sum, '.')))), __LINE__);
        }
        $this->Sum = $sum;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setReason($reason = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reason) && strlen($reason) > 300) || (is_array($reason) && count($reason) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($reason) ? strlen($reason) : count($reason)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reason) && strlen($reason) < 1) || (is_array($reason) && count($reason) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param string $article
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setArticle($article = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($article) && strlen($article) > 10) || (is_array($article) && count($article) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($article) ? strlen($article) : count($article)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($article) && strlen($article) < 1) || (is_array($article) && count($article) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($article) && !is_string($article)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($article)), __LINE__);
        }
        $this->Article = $article;
        return $this;
    }
    /**
     * Get Point value
     * @return string|null
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @param string $point
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setPoint($point = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($point) && strlen($point) > 10) || (is_array($point) && count($point) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($point) ? strlen($point) : count($point)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($point) && strlen($point) < 1) || (is_array($point) && count($point) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($point) && !is_string($point)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($point)), __LINE__);
        }
        $this->Point = $point;
        return $this;
    }
    /**
     * Get Part value
     * @return string|null
     */
    public function getPart()
    {
        return $this->Part;
    }
    /**
     * Set Part value
     * @param string $part
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setPart($part = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($part) && strlen($part) > 10) || (is_array($part) && count($part) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($part) ? strlen($part) : count($part)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($part) && strlen($part) < 1) || (is_array($part) && count($part) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($part) && !is_string($part)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($part)), __LINE__);
        }
        $this->Part = $part;
        return $this;
    }
    /**
     * Get NewOspCode value
     * @return string|null
     */
    public function getNewOspCode()
    {
        return $this->NewOspCode;
    }
    /**
     * Set NewOspCode value
     * @param string $newOspCode
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setNewOspCode($newOspCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($newOspCode) && strlen($newOspCode) !== 5) || (is_array($newOspCode) && count($newOspCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($newOspCode) && !preg_match('/[0-9]{5}/', $newOspCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($newOspCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newOspCode) && !is_string($newOspCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newOspCode)), __LINE__);
        }
        $this->NewOspCode = $newOspCode;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: maxExclusive
        if ($beginDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $beginDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($beginDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $beginDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: maxExclusive
        if ($endDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($endDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ResolutionBase value
     * @return string|null
     */
    public function getResolutionBase()
    {
        return $this->ResolutionBase;
    }
    /**
     * Set ResolutionBase value
     * @param string $resolutionBase
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setResolutionBase($resolutionBase = null)
    {
        // validation for constraint: string
        if (!is_null($resolutionBase) && !is_string($resolutionBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resolutionBase)), __LINE__);
        }
        $this->ResolutionBase = $resolutionBase;
        return $this;
    }
    /**
     * Get SignatureResolutionBase value
     * @return string|null
     */
    public function getSignatureResolutionBase()
    {
        return $this->SignatureResolutionBase;
    }
    /**
     * Set SignatureResolutionBase value
     * @param string $signatureResolutionBase
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setSignatureResolutionBase($signatureResolutionBase = null)
    {
        // validation for constraint: string
        if (!is_null($signatureResolutionBase) && !is_string($signatureResolutionBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureResolutionBase)), __LINE__);
        }
        $this->SignatureResolutionBase = $signatureResolutionBase;
        return $this;
    }
    /**
     * Get IP value
     * @return \AisFssp\StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \AisFssp\StructType\IP $iP
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setIP(\AisFssp\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get Data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setData(array $data = array())
    {
        foreach ($data as $procDocDataItem) {
            // validation for constraint: itemType
            if (!$procDocDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($procDocDataItem) ? get_class($procDocDataItem) : gettype($procDocDataItem)), __LINE__);
            }
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\ProcDoc
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $procDocSignatureItem) {
            // validation for constraint: itemType
            if (!$procDocSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($procDocSignatureItem) ? get_class($procDocSignatureItem) : gettype($procDocSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\ProcDoc
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\ProcDoc
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ProcDoc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
