<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintFormDocumentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Печатная форма документа в формате принудительного исполнения в электронном виде | Используется для передачи печатной формы
 * юридически значимых документов в соответствующем формате. Тип данных позволяет передавать печатную форму в двоичной форме, а также
 * подпись в формате PKCS#7.
 * @subpackage Structs
 */
class PrintFormDocumentType extends AbstractStructBase
{
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - documentation: Данные печатной формы документа
     * - minOccurs: 1
     * @var string
     */
    public $Content;
    /**
     * The ContentType
     * Meta informations extracted from the WSDL
     * - documentation: MIME-формат документа | MIME-тип данных | MIME-тип данных
     * - minOccurs: 1
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $ContentType;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование
     * объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DigitalSignature
     * Meta informations extracted from the WSDL
     * - documentation: ЭП печатной формы документа | Подпись печатной формы документа в формате PKCS#7 detached.
     * @var string
     */
    public $DigitalSignature;
    /**
     * Constructor method for PrintFormDocumentType
     * @uses PrintFormDocumentType::setContent()
     * @uses PrintFormDocumentType::setContentType()
     * @uses PrintFormDocumentType::setDocType()
     * @uses PrintFormDocumentType::setDocNumber()
     * @uses PrintFormDocumentType::setDocDate()
     * @uses PrintFormDocumentType::setDigitalSignature()
     * @param string $content
     * @param string $contentType
     * @param string $docType
     * @param string $docNumber
     * @param string $docDate
     * @param string $digitalSignature
     */
    public function __construct($content = null, $contentType = null, $docType = null, $docNumber = null, $docDate = null, $digitalSignature = null)
    {
        $this
            ->setContent($content)
            ->setContentType($contentType)
            ->setDocType($docType)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setDigitalSignature($digitalSignature);
    }
    /**
     * Get Content value
     * @return string
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \AisFssp\StructType\PrintFormDocumentType
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \AisFssp\StructType\PrintFormDocumentType
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contentType) && strlen($contentType) > 255) || (is_array($contentType) && count($contentType) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($contentType) ? strlen($contentType) : count($contentType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($contentType) && strlen($contentType) < 1) || (is_array($contentType) && count($contentType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \AisFssp\StructType\PrintFormDocumentType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docType) && strlen($docType) > 1) || (is_array($docType) && count($docType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docType) ? strlen($docType) : count($docType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docType) && strlen($docType) < 1) || (is_array($docType) && count($docType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\PrintFormDocumentType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\PrintFormDocumentType
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DigitalSignature value
     * @return string|null
     */
    public function getDigitalSignature()
    {
        return $this->DigitalSignature;
    }
    /**
     * Set DigitalSignature value
     * @param string $digitalSignature
     * @return \AisFssp\StructType\PrintFormDocumentType
     */
    public function setDigitalSignature($digitalSignature = null)
    {
        // validation for constraint: string
        if (!is_null($digitalSignature) && !is_string($digitalSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digitalSignature)), __LINE__);
        }
        $this->DigitalSignature = $digitalSignature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PrintFormDocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
