<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayProperties StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер PayProperties | Содержит сведения о реквизитах плательщика или получателя.
 * - type: tns:PayProperties
 * @subpackage Structs
 */
class PayProperties extends AbstractStructBase
{
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН получателя | Обязательно для кредитных организаций и платежных систем. | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $INN;
    /**
     * The KPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП получателя | Обязательно для кредитных организаций и платежных систем. | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $KPP;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование организации | Обязательно для кредитных организаций и платежных систем. | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The BankBIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК банка | Банковский идентификационный код (БИК)
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $BankBIK;
    /**
     * The SwiftCode
     * Meta informations extracted from the WSDL
     * - documentation: Код SIWFT | Код SWIFT
     * - length: 12
     * - pattern: [0-9]{12}
     * @var string
     */
    public $SwiftCode;
    /**
     * The UfkCode
     * Meta informations extracted from the WSDL
     * - documentation: Код УФК | Код УФК
     * - length: 4
     * - pattern: [0-9]{4}
     * @var string
     */
    public $UfkCode;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование банка | Обязательно для кредитных организаций и платежных систем. | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $BankName;
    /**
     * The BankCorAcc
     * Meta informations extracted from the WSDL
     * - documentation: Коррсчет банка | При наличии у банка данного реквизита заполнение поля обязательно | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $BankCorAcc;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - documentation: Счёт | Обязательно для кредитных организаций и платежных систем. | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Account;
    /**
     * The PersonalAccount
     * Meta informations extracted from the WSDL
     * - documentation: Лицевой счет | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PersonalAccount;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: Код ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The OKTMO
     * Meta informations extracted from the WSDL
     * - documentation: ОКТМО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $OKTMO;
    /**
     * The Kbk
     * Meta informations extracted from the WSDL
     * - documentation: КБК | Код бюджетной классификации (КБК)
     * - minOccurs: 0
     * - length: 20
     * - pattern: [0-9]{20}
     * @var string
     */
    public $Kbk;
    /**
     * Constructor method for PayProperties
     * @uses PayProperties::setINN()
     * @uses PayProperties::setKPP()
     * @uses PayProperties::setName()
     * @uses PayProperties::setBankBIK()
     * @uses PayProperties::setSwiftCode()
     * @uses PayProperties::setUfkCode()
     * @uses PayProperties::setBankName()
     * @uses PayProperties::setBankCorAcc()
     * @uses PayProperties::setAccount()
     * @uses PayProperties::setPersonalAccount()
     * @uses PayProperties::setOKATO()
     * @uses PayProperties::setOKTMO()
     * @uses PayProperties::setKbk()
     * @param string $iNN
     * @param string $kPP
     * @param string $name
     * @param string $bankBIK
     * @param string $swiftCode
     * @param string $ufkCode
     * @param string $bankName
     * @param string $bankCorAcc
     * @param string $account
     * @param string $personalAccount
     * @param string $oKATO
     * @param string $oKTMO
     * @param string $kbk
     */
    public function __construct($iNN = null, $kPP = null, $name = null, $bankBIK = null, $swiftCode = null, $ufkCode = null, $bankName = null, $bankCorAcc = null, $account = null, $personalAccount = null, $oKATO = null, $oKTMO = null, $kbk = null)
    {
        $this
            ->setINN($iNN)
            ->setKPP($kPP)
            ->setName($name)
            ->setBankBIK($bankBIK)
            ->setSwiftCode($swiftCode)
            ->setUfkCode($ufkCode)
            ->setBankName($bankName)
            ->setBankCorAcc($bankCorAcc)
            ->setAccount($account)
            ->setPersonalAccount($personalAccount)
            ->setOKATO($oKATO)
            ->setOKTMO($oKTMO)
            ->setKbk($kbk);
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \AisFssp\StructType\PayProperties
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: length
        if ((is_scalar($iNN) && strlen($iNN) !== 10) || (is_array($iNN) && count($iNN) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iNN) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}/', $iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}", "%s" given', var_export($iNN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get KPP value
     * @return string|null
     */
    public function getKPP()
    {
        return $this->KPP;
    }
    /**
     * Set KPP value
     * @param string $kPP
     * @return \AisFssp\StructType\PayProperties
     */
    public function setKPP($kPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($kPP) && strlen($kPP) !== 9) || (is_array($kPP) && count($kPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $kPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($kPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kPP) && !is_string($kPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kPP)), __LINE__);
        }
        $this->KPP = $kPP;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \AisFssp\StructType\PayProperties
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 1000) || (is_array($name) && count($name) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get BankBIK value
     * @return string|null
     */
    public function getBankBIK()
    {
        return $this->BankBIK;
    }
    /**
     * Set BankBIK value
     * @param string $bankBIK
     * @return \AisFssp\StructType\PayProperties
     */
    public function setBankBIK($bankBIK = null)
    {
        // validation for constraint: length
        if ((is_scalar($bankBIK) && strlen($bankBIK) !== 9) || (is_array($bankBIK) && count($bankBIK) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($bankBIK) && !preg_match('/[0-9]{9}/', $bankBIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{9}", "%s" given', var_export($bankBIK, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankBIK) && !is_string($bankBIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankBIK)), __LINE__);
        }
        $this->BankBIK = $bankBIK;
        return $this;
    }
    /**
     * Get SwiftCode value
     * @return string|null
     */
    public function getSwiftCode()
    {
        return $this->SwiftCode;
    }
    /**
     * Set SwiftCode value
     * @param string $swiftCode
     * @return \AisFssp\StructType\PayProperties
     */
    public function setSwiftCode($swiftCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($swiftCode) && strlen($swiftCode) !== 12) || (is_array($swiftCode) && count($swiftCode) !== 12)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($swiftCode) && !preg_match('/[0-9]{12}/', $swiftCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{12}", "%s" given', var_export($swiftCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($swiftCode) && !is_string($swiftCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($swiftCode)), __LINE__);
        }
        $this->SwiftCode = $swiftCode;
        return $this;
    }
    /**
     * Get UfkCode value
     * @return string|null
     */
    public function getUfkCode()
    {
        return $this->UfkCode;
    }
    /**
     * Set UfkCode value
     * @param string $ufkCode
     * @return \AisFssp\StructType\PayProperties
     */
    public function setUfkCode($ufkCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ufkCode) && strlen($ufkCode) !== 4) || (is_array($ufkCode) && count($ufkCode) !== 4)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ufkCode) && !preg_match('/[0-9]{4}/', $ufkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{4}", "%s" given', var_export($ufkCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ufkCode) && !is_string($ufkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ufkCode)), __LINE__);
        }
        $this->UfkCode = $ufkCode;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \AisFssp\StructType\PayProperties
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankName) && strlen($bankName) > 1000) || (is_array($bankName) && count($bankName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($bankName) ? strlen($bankName) : count($bankName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankName) && strlen($bankName) < 1) || (is_array($bankName) && count($bankName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankCorAcc value
     * @return string|null
     */
    public function getBankCorAcc()
    {
        return $this->BankCorAcc;
    }
    /**
     * Set BankCorAcc value
     * @param string $bankCorAcc
     * @return \AisFssp\StructType\PayProperties
     */
    public function setBankCorAcc($bankCorAcc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankCorAcc) && strlen($bankCorAcc) > 20) || (is_array($bankCorAcc) && count($bankCorAcc) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($bankCorAcc) ? strlen($bankCorAcc) : count($bankCorAcc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankCorAcc) && strlen($bankCorAcc) < 1) || (is_array($bankCorAcc) && count($bankCorAcc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankCorAcc) && !is_string($bankCorAcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCorAcc)), __LINE__);
        }
        $this->BankCorAcc = $bankCorAcc;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \AisFssp\StructType\PayProperties
     */
    public function setAccount($account = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($account) && strlen($account) > 20) || (is_array($account) && count($account) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($account) ? strlen($account) : count($account)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($account) && strlen($account) < 1) || (is_array($account) && count($account) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get PersonalAccount value
     * @return string|null
     */
    public function getPersonalAccount()
    {
        return $this->PersonalAccount;
    }
    /**
     * Set PersonalAccount value
     * @param string $personalAccount
     * @return \AisFssp\StructType\PayProperties
     */
    public function setPersonalAccount($personalAccount = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($personalAccount) && strlen($personalAccount) > 25) || (is_array($personalAccount) && count($personalAccount) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($personalAccount) ? strlen($personalAccount) : count($personalAccount)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($personalAccount) && strlen($personalAccount) < 1) || (is_array($personalAccount) && count($personalAccount) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($personalAccount) && !is_string($personalAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personalAccount)), __LINE__);
        }
        $this->PersonalAccount = $personalAccount;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \AisFssp\StructType\PayProperties
     */
    public function setOKATO($oKATO = null)
    {
        // validation for constraint: length
        if ((is_scalar($oKATO) && strlen($oKATO) !== 11) || (is_array($oKATO) && count($oKATO) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKATO) && !preg_match('/[0-9]{11}/', $oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($oKATO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKATO) && !is_string($oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKATO)), __LINE__);
        }
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get OKTMO value
     * @return string|null
     */
    public function getOKTMO()
    {
        return $this->OKTMO;
    }
    /**
     * Set OKTMO value
     * @param string $oKTMO
     * @return \AisFssp\StructType\PayProperties
     */
    public function setOKTMO($oKTMO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oKTMO) && strlen($oKTMO) > 11) || (is_array($oKTMO) && count($oKTMO) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($oKTMO) ? strlen($oKTMO) : count($oKTMO)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oKTMO) && strlen($oKTMO) < 8) || (is_array($oKTMO) && count($oKTMO) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKTMO) && !preg_match('/([0-9]{8})|([0-9]{11})/', $oKTMO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{8})|([0-9]{11})", "%s" given', var_export($oKTMO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKTMO) && !is_string($oKTMO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKTMO)), __LINE__);
        }
        $this->OKTMO = $oKTMO;
        return $this;
    }
    /**
     * Get Kbk value
     * @return string|null
     */
    public function getKbk()
    {
        return $this->Kbk;
    }
    /**
     * Set Kbk value
     * @param string $kbk
     * @return \AisFssp\StructType\PayProperties
     */
    public function setKbk($kbk = null)
    {
        // validation for constraint: length
        if ((is_scalar($kbk) && strlen($kbk) !== 20) || (is_array($kbk) && count($kbk) !== 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kbk) && !preg_match('/[0-9]{20}/', $kbk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{20}", "%s" given', var_export($kbk, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kbk) && !is_string($kbk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kbk)), __LINE__);
        }
        $this->Kbk = $kbk;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PayProperties
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
