<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OspProperties StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ OspProperties «Реквизиты ОСП» | Содержит список сведений о расчетных счетах ОСП для зачисления платежей | ЭП
 * - type: tns:OspProperties
 * @subpackage Structs
 */
class OspProperties extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Идентификатор объекта, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП
     * РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор запроса списка реквизитов ОСП, полученный ранее от АИС внешнего контрагента |
     * Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным
     * для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The OspProperty
     * Meta informations extracted from the WSDL
     * - documentation: Список ОСП | Список реквизитов отделов СП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\OspProperty[]
     */
    public $OspProperty;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for OspProperties
     * @uses OspProperties::setInternalKey()
     * @uses OspProperties::setRequestExternalKey()
     * @uses OspProperties::setOspProperty()
     * @uses OspProperties::setSignDateTime()
     * @uses OspProperties::setSignature()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param \AisFssp\StructType\OspProperty[] $ospProperty
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($internalKey = null, $requestExternalKey = null, array $ospProperty = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setOspProperty($ospProperty)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\OspProperties
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \AisFssp\StructType\OspProperties
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) > 60) || (is_array($requestExternalKey) && count($requestExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestExternalKey) ? strlen($requestExternalKey) : count($requestExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) < 1) || (is_array($requestExternalKey) && count($requestExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestExternalKey) && !is_string($requestExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestExternalKey)), __LINE__);
        }
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get OspProperty value
     * @return \AisFssp\StructType\OspProperty[]|null
     */
    public function getOspProperty()
    {
        return $this->OspProperty;
    }
    /**
     * Set OspProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OspProperty[] $ospProperty
     * @return \AisFssp\StructType\OspProperties
     */
    public function setOspProperty(array $ospProperty = array())
    {
        foreach ($ospProperty as $ospPropertiesOspPropertyItem) {
            // validation for constraint: itemType
            if (!$ospPropertiesOspPropertyItem instanceof \AisFssp\StructType\OspProperty) {
                throw new \InvalidArgumentException(sprintf('The OspProperty property can only contain items of \AisFssp\StructType\OspProperty, "%s" given', is_object($ospPropertiesOspPropertyItem) ? get_class($ospPropertiesOspPropertyItem) : gettype($ospPropertiesOspPropertyItem)), __LINE__);
            }
        }
        $this->OspProperty = $ospProperty;
        return $this;
    }
    /**
     * Add item to OspProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OspProperty $item
     * @return \AisFssp\StructType\OspProperties
     */
    public function addToOspProperty(\AisFssp\StructType\OspProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\OspProperty) {
            throw new \InvalidArgumentException(sprintf('The OspProperty property can only contain items of \AisFssp\StructType\OspProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OspProperty[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\OspProperties
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\OspProperties
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $ospPropertiesSignatureItem) {
            // validation for constraint: itemType
            if (!$ospPropertiesSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($ospPropertiesSignatureItem) ? get_class($ospPropertiesSignatureItem) : gettype($ospPropertiesSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\OspProperties
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\OspProperties
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
