<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OspDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер OspDetail «Сведения об отделе судебных приставов»
 * @subpackage Structs
 */
class OspDetail extends AbstractStructBase
{
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - documentation: Приоритет | Допустимы значения 1 — 10 | Положительное короткое целое
     * - minInclusive: 1
     * @var int
     */
    public $Priority;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The OKTMO
     * Meta informations extracted from the WSDL
     * - documentation: ОКТМО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $OKTMO;
    /**
     * The MinAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма от | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $MinAmount;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма до | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $MaxAmount;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ИД
     * - minOccurs: 0
     * @var string
     */
    public $IDType;
    /**
     * The ClaimerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип органа, выдавшего ИД
     * - minOccurs: 0
     * @var string
     */
    public $ClaimerType;
    /**
     * The IdSubj
     * Meta informations extracted from the WSDL
     * - documentation: Тип предмета исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IdSubj;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника
     * - minOccurs: 0
     * @var string
     */
    public $DebtorType;
    /**
     * The KladrStreet
     * Meta informations extracted from the WSDL
     * - documentation: Код КЛАДР улицы | Код КЛАДР второго раздела
     * - minOccurs: 0
     * - length: 15
     * - pattern: [0-9]{15}
     * @var string
     */
    public $KladrStreet;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - documentation: Название улицы | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Street;
    /**
     * The HouseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Дома | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $HouseNumber;
    /**
     * The EvenHouse
     * Meta informations extracted from the WSDL
     * - documentation: Все четные дома | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $EvenHouse;
    /**
     * The UnevenHouse
     * Meta informations extracted from the WSDL
     * - documentation: Все нечетные дома | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $UnevenHouse;
    /**
     * Constructor method for OspDetail
     * @uses OspDetail::setPriority()
     * @uses OspDetail::setOKATO()
     * @uses OspDetail::setOKTMO()
     * @uses OspDetail::setMinAmount()
     * @uses OspDetail::setMaxAmount()
     * @uses OspDetail::setIDType()
     * @uses OspDetail::setClaimerType()
     * @uses OspDetail::setIdSubj()
     * @uses OspDetail::setDebtorType()
     * @uses OspDetail::setKladrStreet()
     * @uses OspDetail::setStreet()
     * @uses OspDetail::setHouseNumber()
     * @uses OspDetail::setEvenHouse()
     * @uses OspDetail::setUnevenHouse()
     * @param int $priority
     * @param string $oKATO
     * @param string $oKTMO
     * @param float $minAmount
     * @param float $maxAmount
     * @param string $iDType
     * @param string $claimerType
     * @param string $idSubj
     * @param string $debtorType
     * @param string $kladrStreet
     * @param string $street
     * @param string $houseNumber
     * @param bool $evenHouse
     * @param bool $unevenHouse
     */
    public function __construct($priority = null, $oKATO = null, $oKTMO = null, $minAmount = null, $maxAmount = null, $iDType = null, $claimerType = null, $idSubj = null, $debtorType = null, $kladrStreet = null, $street = null, $houseNumber = null, $evenHouse = null, $unevenHouse = null)
    {
        $this
            ->setPriority($priority)
            ->setOKATO($oKATO)
            ->setOKTMO($oKTMO)
            ->setMinAmount($minAmount)
            ->setMaxAmount($maxAmount)
            ->setIDType($iDType)
            ->setClaimerType($claimerType)
            ->setIdSubj($idSubj)
            ->setDebtorType($debtorType)
            ->setKladrStreet($kladrStreet)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setEvenHouse($evenHouse)
            ->setUnevenHouse($unevenHouse);
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \AisFssp\StructType\OspDetail
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: minInclusive
        if ($priority < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $priority), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($priority) && !is_numeric($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \AisFssp\StructType\OspDetail
     */
    public function setOKATO($oKATO = null)
    {
        // validation for constraint: length
        if ((is_scalar($oKATO) && strlen($oKATO) !== 11) || (is_array($oKATO) && count($oKATO) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKATO) && !preg_match('/[0-9]{11}/', $oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($oKATO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKATO) && !is_string($oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKATO)), __LINE__);
        }
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get OKTMO value
     * @return string|null
     */
    public function getOKTMO()
    {
        return $this->OKTMO;
    }
    /**
     * Set OKTMO value
     * @param string $oKTMO
     * @return \AisFssp\StructType\OspDetail
     */
    public function setOKTMO($oKTMO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oKTMO) && strlen($oKTMO) > 11) || (is_array($oKTMO) && count($oKTMO) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($oKTMO) ? strlen($oKTMO) : count($oKTMO)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oKTMO) && strlen($oKTMO) < 8) || (is_array($oKTMO) && count($oKTMO) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKTMO) && !preg_match('/([0-9]{8})|([0-9]{11})/', $oKTMO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{8})|([0-9]{11})", "%s" given', var_export($oKTMO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKTMO) && !is_string($oKTMO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKTMO)), __LINE__);
        }
        $this->OKTMO = $oKTMO;
        return $this;
    }
    /**
     * Get MinAmount value
     * @return float|null
     */
    public function getMinAmount()
    {
        return $this->MinAmount;
    }
    /**
     * Set MinAmount value
     * @param float $minAmount
     * @return \AisFssp\StructType\OspDetail
     */
    public function setMinAmount($minAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($minAmount) && strlen(substr($minAmount, strpos($minAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($minAmount, strpos($minAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($minAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $minAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($minAmount, strpos($minAmount, '.')))), __LINE__);
        }
        $this->MinAmount = $minAmount;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float|null
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \AisFssp\StructType\OspDetail
     */
    public function setMaxAmount($maxAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($maxAmount) && strlen(substr($maxAmount, strpos($maxAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($maxAmount, strpos($maxAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($maxAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $maxAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($maxAmount, strpos($maxAmount, '.')))), __LINE__);
        }
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \AisFssp\EnumType\IdType::valueIsValid()
     * @uses \AisFssp\EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \AisFssp\StructType\OspDetail
     */
    public function setIDType($iDType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\IdType::valueIsValid($iDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDType, implode(', ', \AisFssp\EnumType\IdType::getValidValues())), __LINE__);
        }
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get ClaimerType value
     * @return string|null
     */
    public function getClaimerType()
    {
        return $this->ClaimerType;
    }
    /**
     * Set ClaimerType value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimerType
     * @return \AisFssp\StructType\OspDetail
     */
    public function setClaimerType($claimerType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($claimerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $claimerType, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->ClaimerType = $claimerType;
        return $this;
    }
    /**
     * Get IdSubj value
     * @return string|null
     */
    public function getIdSubj()
    {
        return $this->IdSubj;
    }
    /**
     * Set IdSubj value
     * @param string $idSubj
     * @return \AisFssp\StructType\OspDetail
     */
    public function setIdSubj($idSubj = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idSubj) && strlen($idSubj) > 8) || (is_array($idSubj) && count($idSubj) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($idSubj) ? strlen($idSubj) : count($idSubj)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($idSubj) && strlen($idSubj) < 1) || (is_array($idSubj) && count($idSubj) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idSubj) && !is_string($idSubj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idSubj)), __LINE__);
        }
        $this->IdSubj = $idSubj;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \AisFssp\StructType\OspDetail
     */
    public function setDebtorType($debtorType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($debtorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $debtorType, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get KladrStreet value
     * @return string|null
     */
    public function getKladrStreet()
    {
        return $this->KladrStreet;
    }
    /**
     * Set KladrStreet value
     * @param string $kladrStreet
     * @return \AisFssp\StructType\OspDetail
     */
    public function setKladrStreet($kladrStreet = null)
    {
        // validation for constraint: length
        if ((is_scalar($kladrStreet) && strlen($kladrStreet) !== 15) || (is_array($kladrStreet) && count($kladrStreet) !== 15)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kladrStreet) && !preg_match('/[0-9]{15}/', $kladrStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{15}", "%s" given', var_export($kladrStreet, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kladrStreet) && !is_string($kladrStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kladrStreet)), __LINE__);
        }
        $this->KladrStreet = $kladrStreet;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \AisFssp\StructType\OspDetail
     */
    public function setStreet($street = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($street) && strlen($street) > 60) || (is_array($street) && count($street) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($street) ? strlen($street) : count($street)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($street) && strlen($street) < 1) || (is_array($street) && count($street) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get HouseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->HouseNumber;
    }
    /**
     * Set HouseNumber value
     * @param string $houseNumber
     * @return \AisFssp\StructType\OspDetail
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($houseNumber) && strlen($houseNumber) > 100) || (is_array($houseNumber) && count($houseNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($houseNumber) ? strlen($houseNumber) : count($houseNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($houseNumber) && strlen($houseNumber) < 1) || (is_array($houseNumber) && count($houseNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumber)), __LINE__);
        }
        $this->HouseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get EvenHouse value
     * @return bool|null
     */
    public function getEvenHouse()
    {
        return $this->EvenHouse;
    }
    /**
     * Set EvenHouse value
     * @param bool $evenHouse
     * @return \AisFssp\StructType\OspDetail
     */
    public function setEvenHouse($evenHouse = null)
    {
        // validation for constraint: boolean
        if (!is_null($evenHouse) && !is_bool($evenHouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($evenHouse)), __LINE__);
        }
        $this->EvenHouse = $evenHouse;
        return $this;
    }
    /**
     * Get UnevenHouse value
     * @return bool|null
     */
    public function getUnevenHouse()
    {
        return $this->UnevenHouse;
    }
    /**
     * Set UnevenHouse value
     * @param bool $unevenHouse
     * @return \AisFssp\StructType\OspDetail
     */
    public function setUnevenHouse($unevenHouse = null)
    {
        // validation for constraint: boolean
        if (!is_null($unevenHouse) && !is_bool($unevenHouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($unevenHouse)), __LINE__);
        }
        $this->UnevenHouse = $unevenHouse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\OspDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
