<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageCollection StructType
 * Meta informations extracted from the WSDL
 * - documentation: Коллекция сообщений
 * @subpackage Structs
 */
class MessageCollection extends AbstractStructBase
{
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - documentation: Множество сообщений
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Message[]
     */
    public $message;
    /**
     * Constructor method for MessageCollection
     * @uses MessageCollection::setMessage()
     * @param \AisFssp\StructType\Message[] $message
     */
    public function __construct(array $message = array())
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get message value
     * @return \AisFssp\StructType\Message[]|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Message[] $message
     * @return \AisFssp\StructType\MessageCollection
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $messageCollectionMessageItem) {
            // validation for constraint: itemType
            if (!$messageCollectionMessageItem instanceof \AisFssp\StructType\Message) {
                throw new \InvalidArgumentException(sprintf('The message property can only contain items of \AisFssp\StructType\Message, "%s" given', is_object($messageCollectionMessageItem) ? get_class($messageCollectionMessageItem) : gettype($messageCollectionMessageItem)), __LINE__);
            }
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Add item to message value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Message $item
     * @return \AisFssp\StructType\MessageCollection
     */
    public function addToMessage(\AisFssp\StructType\Message $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Message) {
            throw new \InvalidArgumentException(sprintf('The message property can only contain items of \AisFssp\StructType\Message, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->message[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\MessageCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
