<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сообщение. Включает в себя один пакет документов | ЭЦП | Технологическая ЭЦП (накладывается сервером, формирующим сообщение)
 * - type: tns:DocumentNote
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The pack
     * Meta informations extracted from the WSDL
     * - documentation: Пакет документов
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \AisFssp\StructType\DataBlock
     */
    public $pack;
    /**
     * The externalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $externalKey;
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The origin
     * Meta informations extracted from the WSDL
     * - documentation: Адрес отправителя пакета
     * - minOccurs: 0
     * @var \AisFssp\StructType\RedAddress
     */
    public $origin;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - documentation: Адрес получателя пакета
     * - minOccurs: 0
     * @var \AisFssp\StructType\RedAddress
     */
    public $target;
    /**
     * The generation
     * Meta informations extracted from the WSDL
     * - documentation: Номер поколения
     * - minOccurs: 0
     * @var int
     */
    public $generation;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for Message
     * @uses Message::setPack()
     * @uses Message::setExternalKey()
     * @uses Message::setInternalKey()
     * @uses Message::setOrigin()
     * @uses Message::setTarget()
     * @uses Message::setGeneration()
     * @uses Message::setSignature()
     * @param \AisFssp\StructType\DataBlock $pack
     * @param string $externalKey
     * @param int $internalKey
     * @param \AisFssp\StructType\RedAddress $origin
     * @param \AisFssp\StructType\RedAddress $target
     * @param int $generation
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct(\AisFssp\StructType\DataBlock $pack = null, $externalKey = null, $internalKey = null, \AisFssp\StructType\RedAddress $origin = null, \AisFssp\StructType\RedAddress $target = null, $generation = null, array $signature = array())
    {
        $this
            ->setPack($pack)
            ->setExternalKey($externalKey)
            ->setInternalKey($internalKey)
            ->setOrigin($origin)
            ->setTarget($target)
            ->setGeneration($generation)
            ->setSignature($signature);
    }
    /**
     * Get pack value
     * @return \AisFssp\StructType\DataBlock
     */
    public function getPack()
    {
        return $this->pack;
    }
    /**
     * Set pack value
     * @param \AisFssp\StructType\DataBlock $pack
     * @return \AisFssp\StructType\Message
     */
    public function setPack(\AisFssp\StructType\DataBlock $pack = null)
    {
        $this->pack = $pack;
        return $this;
    }
    /**
     * Get externalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->externalKey;
    }
    /**
     * Set externalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\Message
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->externalKey = $externalKey;
        return $this;
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\Message
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get origin value
     * @return \AisFssp\StructType\RedAddress|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \AisFssp\StructType\RedAddress $origin
     * @return \AisFssp\StructType\Message
     */
    public function setOrigin(\AisFssp\StructType\RedAddress $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get target value
     * @return \AisFssp\StructType\RedAddress|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param \AisFssp\StructType\RedAddress $target
     * @return \AisFssp\StructType\Message
     */
    public function setTarget(\AisFssp\StructType\RedAddress $target = null)
    {
        $this->target = $target;
        return $this;
    }
    /**
     * Get generation value
     * @return int|null
     */
    public function getGeneration()
    {
        return $this->generation;
    }
    /**
     * Set generation value
     * @param int $generation
     * @return \AisFssp\StructType\Message
     */
    public function setGeneration($generation = null)
    {
        // validation for constraint: int
        if (!is_null($generation) && !is_numeric($generation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($generation)), __LINE__);
        }
        $this->generation = $generation;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\Message
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $messageSignatureItem) {
            // validation for constraint: itemType
            if (!$messageSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($messageSignatureItem) ? get_class($messageSignatureItem) : gettype($messageSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\Message
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Message
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
