<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailStateTrackingRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ MailStateTrackingRequest "Запрос статуса корреспонденции" | Запрос статуса корреспонденции
 * - type: tns:MailStateTrackingRequest
 * @subpackage Structs
 */
class MailStateTrackingRequest extends AbstractStructBase
{
    /**
     * The BarcodeList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \AisFssp\StructType\BarcodeList[]
     */
    public $BarcodeList;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор запроса на отслеживание корреспонденции. | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * Constructor method for MailStateTrackingRequest
     * @uses MailStateTrackingRequest::setBarcodeList()
     * @uses MailStateTrackingRequest::setInternalKey()
     * @uses MailStateTrackingRequest::setDocDate()
     * @param \AisFssp\StructType\BarcodeList[] $barcodeList
     * @param int $internalKey
     * @param string $docDate
     */
    public function __construct(array $barcodeList = array(), $internalKey = null, $docDate = null)
    {
        $this
            ->setBarcodeList($barcodeList)
            ->setInternalKey($internalKey)
            ->setDocDate($docDate);
    }
    /**
     * Get BarcodeList value
     * @return \AisFssp\StructType\BarcodeList[]
     */
    public function getBarcodeList()
    {
        return $this->BarcodeList;
    }
    /**
     * Set BarcodeList value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\BarcodeList[] $barcodeList
     * @return \AisFssp\StructType\MailStateTrackingRequest
     */
    public function setBarcodeList(array $barcodeList = array())
    {
        foreach ($barcodeList as $mailStateTrackingRequestBarcodeListItem) {
            // validation for constraint: itemType
            if (!$mailStateTrackingRequestBarcodeListItem instanceof \AisFssp\StructType\BarcodeList) {
                throw new \InvalidArgumentException(sprintf('The BarcodeList property can only contain items of \AisFssp\StructType\BarcodeList, "%s" given', is_object($mailStateTrackingRequestBarcodeListItem) ? get_class($mailStateTrackingRequestBarcodeListItem) : gettype($mailStateTrackingRequestBarcodeListItem)), __LINE__);
            }
        }
        $this->BarcodeList = $barcodeList;
        return $this;
    }
    /**
     * Add item to BarcodeList value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\BarcodeList $item
     * @return \AisFssp\StructType\MailStateTrackingRequest
     */
    public function addToBarcodeList(\AisFssp\StructType\BarcodeList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\BarcodeList) {
            throw new \InvalidArgumentException(sprintf('The BarcodeList property can only contain items of \AisFssp\StructType\BarcodeList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BarcodeList[] = $item;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\MailStateTrackingRequest
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\MailStateTrackingRequest
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\MailStateTrackingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
