<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о лицензии
 * @subpackage Structs
 */
class LicenseDatumType extends InformationType
{
    /**
     * The licenseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер лицензии | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $licenseNumber;
    /**
     * The licenseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $licenseDate;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $startDate;
    /**
     * The finDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finDate;
    /**
     * The suspendDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата приостановления действия лицензии или дата аннулирования лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $suspendDate;
    /**
     * The finDateResumed
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия лицензии | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finDateResumed;
    /**
     * The licenseActivities
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о видах деятельности на которые выдана лицензия
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\LicenseActivityType[]
     */
    public $licenseActivities;
    /**
     * The stateId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор состояния лицензии | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $stateId;
    /**
     * The stateName
     * Meta informations extracted from the WSDL
     * - documentation: Название состояния лицензии | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $stateName;
    /**
     * The recipientName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование получателя | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $recipientName;
    /**
     * The recipientAddress
     * Meta informations extracted from the WSDL
     * - documentation: Местонахождения получателя | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $recipientAddress;
    /**
     * The operationAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места эксплуатации | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $operationAddress;
    /**
     * The authorizedPersonFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО уполномоченного лица | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $authorizedPersonFio;
    /**
     * The authorizedPersonPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность уполномоченного лица | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $authorizedPersonPost;
    /**
     * The appendix
     * Meta informations extracted from the WSDL
     * - documentation: Приложение | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $appendix;
    /**
     * Constructor method for LicenseDatumType
     * @uses LicenseDatumType::setLicenseNumber()
     * @uses LicenseDatumType::setLicenseDate()
     * @uses LicenseDatumType::setStartDate()
     * @uses LicenseDatumType::setFinDate()
     * @uses LicenseDatumType::setSuspendDate()
     * @uses LicenseDatumType::setFinDateResumed()
     * @uses LicenseDatumType::setLicenseActivities()
     * @uses LicenseDatumType::setStateId()
     * @uses LicenseDatumType::setStateName()
     * @uses LicenseDatumType::setRecipientName()
     * @uses LicenseDatumType::setRecipientAddress()
     * @uses LicenseDatumType::setOperationAddress()
     * @uses LicenseDatumType::setAuthorizedPersonFio()
     * @uses LicenseDatumType::setAuthorizedPersonPost()
     * @uses LicenseDatumType::setAppendix()
     * @param string $licenseNumber
     * @param string $licenseDate
     * @param string $startDate
     * @param string $finDate
     * @param string $suspendDate
     * @param string $finDateResumed
     * @param \AisFssp\StructType\LicenseActivityType[] $licenseActivities
     * @param int $stateId
     * @param string $stateName
     * @param string $recipientName
     * @param string $recipientAddress
     * @param string $operationAddress
     * @param string $authorizedPersonFio
     * @param string $authorizedPersonPost
     * @param string $appendix
     */
    public function __construct($licenseNumber = null, $licenseDate = null, $startDate = null, $finDate = null, $suspendDate = null, $finDateResumed = null, array $licenseActivities = array(), $stateId = null, $stateName = null, $recipientName = null, $recipientAddress = null, $operationAddress = null, $authorizedPersonFio = null, $authorizedPersonPost = null, $appendix = null)
    {
        $this
            ->setLicenseNumber($licenseNumber)
            ->setLicenseDate($licenseDate)
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setSuspendDate($suspendDate)
            ->setFinDateResumed($finDateResumed)
            ->setLicenseActivities($licenseActivities)
            ->setStateId($stateId)
            ->setStateName($stateName)
            ->setRecipientName($recipientName)
            ->setRecipientAddress($recipientAddress)
            ->setOperationAddress($operationAddress)
            ->setAuthorizedPersonFio($authorizedPersonFio)
            ->setAuthorizedPersonPost($authorizedPersonPost)
            ->setAppendix($appendix);
    }
    /**
     * Get licenseNumber value
     * @return string|null
     */
    public function getLicenseNumber()
    {
        return $this->licenseNumber;
    }
    /**
     * Set licenseNumber value
     * @param string $licenseNumber
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setLicenseNumber($licenseNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($licenseNumber) && strlen($licenseNumber) > 50) || (is_array($licenseNumber) && count($licenseNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($licenseNumber) ? strlen($licenseNumber) : count($licenseNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($licenseNumber) && strlen($licenseNumber) < 1) || (is_array($licenseNumber) && count($licenseNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($licenseNumber) && !is_string($licenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseNumber)), __LINE__);
        }
        $this->licenseNumber = $licenseNumber;
        return $this;
    }
    /**
     * Get licenseDate value
     * @return string|null
     */
    public function getLicenseDate()
    {
        return $this->licenseDate;
    }
    /**
     * Set licenseDate value
     * @param string $licenseDate
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setLicenseDate($licenseDate = null)
    {
        // validation for constraint: maxExclusive
        if ($licenseDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $licenseDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($licenseDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $licenseDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($licenseDate) && !is_string($licenseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseDate)), __LINE__);
        }
        $this->licenseDate = $licenseDate;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: maxExclusive
        if ($startDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($startDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get finDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->finDate;
    }
    /**
     * Set finDate value
     * @param string $finDate
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setFinDate($finDate = null)
    {
        // validation for constraint: maxExclusive
        if ($finDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $finDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($finDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $finDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finDate) && !is_string($finDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finDate)), __LINE__);
        }
        $this->finDate = $finDate;
        return $this;
    }
    /**
     * Get suspendDate value
     * @return string|null
     */
    public function getSuspendDate()
    {
        return $this->suspendDate;
    }
    /**
     * Set suspendDate value
     * @param string $suspendDate
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setSuspendDate($suspendDate = null)
    {
        // validation for constraint: maxExclusive
        if ($suspendDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $suspendDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($suspendDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $suspendDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($suspendDate) && !is_string($suspendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suspendDate)), __LINE__);
        }
        $this->suspendDate = $suspendDate;
        return $this;
    }
    /**
     * Get finDateResumed value
     * @return string|null
     */
    public function getFinDateResumed()
    {
        return $this->finDateResumed;
    }
    /**
     * Set finDateResumed value
     * @param string $finDateResumed
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setFinDateResumed($finDateResumed = null)
    {
        // validation for constraint: maxExclusive
        if ($finDateResumed >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $finDateResumed), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($finDateResumed < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $finDateResumed), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finDateResumed) && !is_string($finDateResumed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finDateResumed)), __LINE__);
        }
        $this->finDateResumed = $finDateResumed;
        return $this;
    }
    /**
     * Get licenseActivities value
     * @return \AisFssp\StructType\LicenseActivityType[]|null
     */
    public function getLicenseActivities()
    {
        return $this->licenseActivities;
    }
    /**
     * Set licenseActivities value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\LicenseActivityType[] $licenseActivities
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setLicenseActivities(array $licenseActivities = array())
    {
        foreach ($licenseActivities as $licenseDatumTypeLicenseActivitiesItem) {
            // validation for constraint: itemType
            if (!$licenseDatumTypeLicenseActivitiesItem instanceof \AisFssp\StructType\LicenseActivityType) {
                throw new \InvalidArgumentException(sprintf('The licenseActivities property can only contain items of \AisFssp\StructType\LicenseActivityType, "%s" given', is_object($licenseDatumTypeLicenseActivitiesItem) ? get_class($licenseDatumTypeLicenseActivitiesItem) : gettype($licenseDatumTypeLicenseActivitiesItem)), __LINE__);
            }
        }
        $this->licenseActivities = $licenseActivities;
        return $this;
    }
    /**
     * Add item to licenseActivities value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\LicenseActivityType $item
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function addToLicenseActivities(\AisFssp\StructType\LicenseActivityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\LicenseActivityType) {
            throw new \InvalidArgumentException(sprintf('The licenseActivities property can only contain items of \AisFssp\StructType\LicenseActivityType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->licenseActivities[] = $item;
        return $this;
    }
    /**
     * Get stateId value
     * @return int|null
     */
    public function getStateId()
    {
        return $this->stateId;
    }
    /**
     * Set stateId value
     * @param int $stateId
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setStateId($stateId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($stateId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $stateId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($stateId, strpos($stateId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($stateId) && !is_numeric($stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stateId)), __LINE__);
        }
        $this->stateId = $stateId;
        return $this;
    }
    /**
     * Get stateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->stateName;
    }
    /**
     * Set stateName value
     * @param string $stateName
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($stateName) && strlen($stateName) > 255) || (is_array($stateName) && count($stateName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($stateName) ? strlen($stateName) : count($stateName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($stateName) && strlen($stateName) < 1) || (is_array($stateName) && count($stateName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateName)), __LINE__);
        }
        $this->stateName = $stateName;
        return $this;
    }
    /**
     * Get recipientName value
     * @return string|null
     */
    public function getRecipientName()
    {
        return $this->recipientName;
    }
    /**
     * Set recipientName value
     * @param string $recipientName
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setRecipientName($recipientName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recipientName) && strlen($recipientName) > 100) || (is_array($recipientName) && count($recipientName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($recipientName) ? strlen($recipientName) : count($recipientName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recipientName) && strlen($recipientName) < 1) || (is_array($recipientName) && count($recipientName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recipientName) && !is_string($recipientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientName)), __LINE__);
        }
        $this->recipientName = $recipientName;
        return $this;
    }
    /**
     * Get recipientAddress value
     * @return string|null
     */
    public function getRecipientAddress()
    {
        return $this->recipientAddress;
    }
    /**
     * Set recipientAddress value
     * @param string $recipientAddress
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setRecipientAddress($recipientAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recipientAddress) && strlen($recipientAddress) > 1000) || (is_array($recipientAddress) && count($recipientAddress) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($recipientAddress) ? strlen($recipientAddress) : count($recipientAddress)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recipientAddress) && strlen($recipientAddress) < 1) || (is_array($recipientAddress) && count($recipientAddress) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recipientAddress) && !is_string($recipientAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientAddress)), __LINE__);
        }
        $this->recipientAddress = $recipientAddress;
        return $this;
    }
    /**
     * Get operationAddress value
     * @return string|null
     */
    public function getOperationAddress()
    {
        return $this->operationAddress;
    }
    /**
     * Set operationAddress value
     * @param string $operationAddress
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setOperationAddress($operationAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($operationAddress) && strlen($operationAddress) > 1000) || (is_array($operationAddress) && count($operationAddress) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($operationAddress) ? strlen($operationAddress) : count($operationAddress)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($operationAddress) && strlen($operationAddress) < 1) || (is_array($operationAddress) && count($operationAddress) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operationAddress) && !is_string($operationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationAddress)), __LINE__);
        }
        $this->operationAddress = $operationAddress;
        return $this;
    }
    /**
     * Get authorizedPersonFio value
     * @return string|null
     */
    public function getAuthorizedPersonFio()
    {
        return $this->authorizedPersonFio;
    }
    /**
     * Set authorizedPersonFio value
     * @param string $authorizedPersonFio
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setAuthorizedPersonFio($authorizedPersonFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorizedPersonFio) && strlen($authorizedPersonFio) > 100) || (is_array($authorizedPersonFio) && count($authorizedPersonFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authorizedPersonFio) ? strlen($authorizedPersonFio) : count($authorizedPersonFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorizedPersonFio) && strlen($authorizedPersonFio) < 1) || (is_array($authorizedPersonFio) && count($authorizedPersonFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorizedPersonFio) && !is_string($authorizedPersonFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizedPersonFio)), __LINE__);
        }
        $this->authorizedPersonFio = $authorizedPersonFio;
        return $this;
    }
    /**
     * Get authorizedPersonPost value
     * @return string|null
     */
    public function getAuthorizedPersonPost()
    {
        return $this->authorizedPersonPost;
    }
    /**
     * Set authorizedPersonPost value
     * @param string $authorizedPersonPost
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setAuthorizedPersonPost($authorizedPersonPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorizedPersonPost) && strlen($authorizedPersonPost) > 255) || (is_array($authorizedPersonPost) && count($authorizedPersonPost) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($authorizedPersonPost) ? strlen($authorizedPersonPost) : count($authorizedPersonPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorizedPersonPost) && strlen($authorizedPersonPost) < 1) || (is_array($authorizedPersonPost) && count($authorizedPersonPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorizedPersonPost) && !is_string($authorizedPersonPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizedPersonPost)), __LINE__);
        }
        $this->authorizedPersonPost = $authorizedPersonPost;
        return $this;
    }
    /**
     * Get appendix value
     * @return string|null
     */
    public function getAppendix()
    {
        return $this->appendix;
    }
    /**
     * Set appendix value
     * @param string $appendix
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public function setAppendix($appendix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($appendix) && strlen($appendix) > 1000) || (is_array($appendix) && count($appendix) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($appendix) ? strlen($appendix) : count($appendix)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($appendix) && strlen($appendix) < 1) || (is_array($appendix) && count($appendix) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($appendix) && !is_string($appendix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appendix)), __LINE__);
        }
        $this->appendix = $appendix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\LicenseDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
