<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KKTDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений KKTDataType "Наличие ККТ"
 * @subpackage Structs
 */
class KKTDataType extends InformationType
{
    /**
     * The ModelName
     * Meta informations extracted from the WSDL
     * - documentation: Модель, наименование ККТ | ИР ККТ п.7 раздел 1 | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $ModelName;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - documentation: Заводской номер ККТ | ИР ККТ п.11 раздел 1 | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $SerialNumber;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места установки (нахождения) ККТ | ИР ККТ п.17 раздел 1 по КЛАДР | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Address;
    /**
     * Constructor method for KKTDataType
     * @uses KKTDataType::setModelName()
     * @uses KKTDataType::setSerialNumber()
     * @uses KKTDataType::setAddress()
     * @param string $modelName
     * @param string $serialNumber
     * @param string $address
     */
    public function __construct($modelName = null, $serialNumber = null, $address = null)
    {
        $this
            ->setModelName($modelName)
            ->setSerialNumber($serialNumber)
            ->setAddress($address);
    }
    /**
     * Get ModelName value
     * @return string|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param string $modelName
     * @return \AisFssp\StructType\KKTDataType
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($modelName) && strlen($modelName) > 50) || (is_array($modelName) && count($modelName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($modelName) ? strlen($modelName) : count($modelName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($modelName) && strlen($modelName) < 1) || (is_array($modelName) && count($modelName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelName)), __LINE__);
        }
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \AisFssp\StructType\KKTDataType
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serialNumber) && strlen($serialNumber) > 20) || (is_array($serialNumber) && count($serialNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($serialNumber) ? strlen($serialNumber) : count($serialNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($serialNumber) && strlen($serialNumber) < 1) || (is_array($serialNumber) && count($serialNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \AisFssp\StructType\KKTDataType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address) && strlen($address) > 300) || (is_array($address) && count($address) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($address) ? strlen($address) : count($address)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($address) && strlen($address) < 1) || (is_array($address) && count($address) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\KKTDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
