<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationRegistryQuery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос в реестр розыска
 * - type: tns:InvestigationRegistryQuery
 * @subpackage Structs
 */
class InvestigationRegistryQuery extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Тип разыскиваемого лица | Указывается тип разыскиваемого лица, либо лица, чье имущество разыскивается
     * @var string
     */
    public $Type;
    /**
     * The InvFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО разыскиваемого лица | Указывается разыскиваемое лицо (Ф.И.О. гражданина, ребёнка), либо лицо, чье имущество разыскивается.
     * Допустимо заполнение только одного из полей «ФИО разыскиваемого лица» или «Наименование организации»
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $InvFio;
    /**
     * The InvName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование организации | Указывается разыскиваемая организация (наименование организации), либо организация, чье имущество
     * разыскивается. Допустимо заполнение только одного из полей «ФИО разыскиваемого лица» или «Наименование организации» | Строка длиной от
     * 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $InvName;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Указывается дата рождения разыскиваемого лица либо гражданина, чье имущество разыскивается, если известена |
     * Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BirthDate;
    /**
     * The BirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения | Указывается год рождения разыскиваемого лица либо гражданина, чье имущество разыскивается, если известен | Год
     * (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $BirthYear;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН организации | Указывается ИНН разыскиваемой организации либо организации, чье имущество разыскивается. Поле обязательное
     * для заполнения, если тип разыскиваемого лица — юридическое лицо | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $INN;
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Указывается номер ИП. Используется для поиска розыскного дела в реестре розыска | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumber;
    /**
     * The Aliment
     * Meta informations extracted from the WSDL
     * - documentation: Алиментные обязательства | Признак поиска разыскиваемого лица, являющегося должником по алиментным обязательствам. Если
     * признак отсутствует в схеме, то по умолчанию принимает значение «true». | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $Aliment;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for InvestigationRegistryQuery
     * @uses InvestigationRegistryQuery::setExternalKey()
     * @uses InvestigationRegistryQuery::setType()
     * @uses InvestigationRegistryQuery::setInvFio()
     * @uses InvestigationRegistryQuery::setInvName()
     * @uses InvestigationRegistryQuery::setBirthDate()
     * @uses InvestigationRegistryQuery::setBirthYear()
     * @uses InvestigationRegistryQuery::setINN()
     * @uses InvestigationRegistryQuery::setIPNumber()
     * @uses InvestigationRegistryQuery::setAliment()
     * @uses InvestigationRegistryQuery::setSignature()
     * @uses InvestigationRegistryQuery::setId()
     * @param string $externalKey
     * @param string $type
     * @param \AisFssp\StructType\FioType $invFio
     * @param string $invName
     * @param string $birthDate
     * @param string $birthYear
     * @param string $iNN
     * @param string $iPNumber
     * @param bool $aliment
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $type = null, \AisFssp\StructType\FioType $invFio = null, $invName = null, $birthDate = null, $birthYear = null, $iNN = null, $iPNumber = null, $aliment = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setType($type)
            ->setInvFio($invFio)
            ->setInvName($invName)
            ->setBirthDate($birthDate)
            ->setBirthYear($birthYear)
            ->setINN($iNN)
            ->setIPNumber($iPNumber)
            ->setAliment($aliment)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get InvFio value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getInvFio()
    {
        return $this->InvFio;
    }
    /**
     * Set InvFio value
     * @param \AisFssp\StructType\FioType $invFio
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setInvFio(\AisFssp\StructType\FioType $invFio = null)
    {
        $this->InvFio = $invFio;
        return $this;
    }
    /**
     * Get InvName value
     * @return string|null
     */
    public function getInvName()
    {
        return $this->InvName;
    }
    /**
     * Set InvName value
     * @param string $invName
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setInvName($invName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invName) && strlen($invName) > 1000) || (is_array($invName) && count($invName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($invName) ? strlen($invName) : count($invName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($invName) && strlen($invName) < 1) || (is_array($invName) && count($invName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invName) && !is_string($invName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invName)), __LINE__);
        }
        $this->InvName = $invName;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($birthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get BirthYear value
     * @return string|null
     */
    public function getBirthYear()
    {
        return $this->BirthYear;
    }
    /**
     * Set BirthYear value
     * @param string $birthYear
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setBirthYear($birthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($birthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $birthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthYear) && !is_string($birthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthYear)), __LINE__);
        }
        $this->BirthYear = $birthYear;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: length
        if ((is_scalar($iNN) && strlen($iNN) !== 10) || (is_array($iNN) && count($iNN) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iNN) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}/', $iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}", "%s" given', var_export($iNN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get IPNumber value
     * @return string|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @param string $iPNumber
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setIPNumber($iPNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) > 25) || (is_array($iPNumber) && count($iPNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNumber) ? strlen($iPNumber) : count($iPNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) < 1) || (is_array($iPNumber) && count($iPNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNumber) && !is_string($iPNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNumber)), __LINE__);
        }
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Get Aliment value
     * @return bool|null
     */
    public function getAliment()
    {
        return $this->Aliment;
    }
    /**
     * Set Aliment value
     * @param bool $aliment
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setAliment($aliment = null)
    {
        // validation for constraint: boolean
        if (!is_null($aliment) && !is_bool($aliment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aliment)), __LINE__);
        }
        $this->Aliment = $aliment;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $investigationRegistryQuerySignatureItem) {
            // validation for constraint: itemType
            if (!$investigationRegistryQuerySignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($investigationRegistryQuerySignatureItem) ? get_class($investigationRegistryQuerySignatureItem) : gettype($investigationRegistryQuerySignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\InvestigationRegistryQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
