<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationRegistryDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Строка выписки из реестра розыска
 * @subpackage Structs
 */
class InvestigationRegistryDetail extends AbstractStructBase
{
    /**
     * The IssueDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заведения розыскного дела | Указывается дата заведения розыскного дела | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IssueDate;
    /**
     * The IssueNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер розыскного дела | Указывается номер розыскного дела | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IssueNumber;
    /**
     * The IsDurationOverMonth
     * Meta informations extracted from the WSDL
     * - documentation: Срок нахождения в реестре больше месяца | Признак устанавливается в активное состояние, если с момента загрузки розыскного
     * дела в реестр розыска прошло больше месяца | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsDurationOverMonth;
    /**
     * The invCategory
     * Meta informations extracted from the WSDL
     * - documentation: Категория розыска | Указывается тип розыскного дела (должник-организация, имущество должника-организации, должник-физическое
     * лицо, имущество должника-физического лица, ребёнок) | Категория розыска
     * - length: 1
     * @var string
     */
    public $invCategory;
    /**
     * Constructor method for InvestigationRegistryDetail
     * @uses InvestigationRegistryDetail::setIssueDate()
     * @uses InvestigationRegistryDetail::setIssueNumber()
     * @uses InvestigationRegistryDetail::setIsDurationOverMonth()
     * @uses InvestigationRegistryDetail::setInvCategory()
     * @param string $issueDate
     * @param string $issueNumber
     * @param bool $isDurationOverMonth
     * @param string $invCategory
     */
    public function __construct($issueDate = null, $issueNumber = null, $isDurationOverMonth = null, $invCategory = null)
    {
        $this
            ->setIssueDate($issueDate)
            ->setIssueNumber($issueNumber)
            ->setIsDurationOverMonth($isDurationOverMonth)
            ->setInvCategory($invCategory);
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \AisFssp\StructType\InvestigationRegistryDetail
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: maxExclusive
        if ($issueDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $issueDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($issueDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $issueDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->IssueNumber;
    }
    /**
     * Set IssueNumber value
     * @param string $issueNumber
     * @return \AisFssp\StructType\InvestigationRegistryDetail
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issueNumber) && strlen($issueNumber) > 25) || (is_array($issueNumber) && count($issueNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($issueNumber) ? strlen($issueNumber) : count($issueNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($issueNumber) && strlen($issueNumber) < 1) || (is_array($issueNumber) && count($issueNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueNumber)), __LINE__);
        }
        $this->IssueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get IsDurationOverMonth value
     * @return bool|null
     */
    public function getIsDurationOverMonth()
    {
        return $this->IsDurationOverMonth;
    }
    /**
     * Set IsDurationOverMonth value
     * @param bool $isDurationOverMonth
     * @return \AisFssp\StructType\InvestigationRegistryDetail
     */
    public function setIsDurationOverMonth($isDurationOverMonth = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDurationOverMonth) && !is_bool($isDurationOverMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDurationOverMonth)), __LINE__);
        }
        $this->IsDurationOverMonth = $isDurationOverMonth;
        return $this;
    }
    /**
     * Get invCategory value
     * @return string|null
     */
    public function getInvCategory()
    {
        return $this->invCategory;
    }
    /**
     * Set invCategory value
     * @param string $invCategory
     * @return \AisFssp\StructType\InvestigationRegistryDetail
     */
    public function setInvCategory($invCategory = null)
    {
        // validation for constraint: length
        if ((is_scalar($invCategory) && strlen($invCategory) !== 1) || (is_array($invCategory) && count($invCategory) !== 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invCategory) && !is_string($invCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invCategory)), __LINE__);
        }
        $this->invCategory = $invCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\InvestigationRegistryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
