<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingEMailMessage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Входящее сообщение ведомственной электронной почты
 * - type: tns:IncomingEMailMessage
 * @subpackage Structs
 */
class IncomingEMailMessage extends AbstractStructBase
{
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - documentation: Получатель | Адрес электронной почты
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - maxLength: 100
     * - minLength: 1
     * @var string[]
     */
    public $Recipient;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения (присваивается сервером МВВ) | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта
     * или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The MessageId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения почтового сервера | Идентификатор сообщения электронной почты
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $MessageId;
    /**
     * The Sender
     * Meta informations extracted from the WSDL
     * - documentation: Отправитель | Адрес электронной почты
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Sender;
    /**
     * The CC
     * Meta informations extracted from the WSDL
     * - documentation: Копия | Адрес электронной почты
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string[]
     */
    public $CC;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - documentation: Тема | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Subject;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - documentation: Заголовки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\EMailHeaderType[]
     */
    public $Header;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текст сообщения | Массив произвольных данных (текстовый)
     * @var string
     */
    public $Text;
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - documentation: Вложения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $Attachment;
    /**
     * Constructor method for IncomingEMailMessage
     * @uses IncomingEMailMessage::setRecipient()
     * @uses IncomingEMailMessage::setInternalKey()
     * @uses IncomingEMailMessage::setMessageId()
     * @uses IncomingEMailMessage::setSender()
     * @uses IncomingEMailMessage::setCC()
     * @uses IncomingEMailMessage::setSubject()
     * @uses IncomingEMailMessage::setHeader()
     * @uses IncomingEMailMessage::setText()
     * @uses IncomingEMailMessage::setAttachment()
     * @param string[] $recipient
     * @param int $internalKey
     * @param string $messageId
     * @param string $sender
     * @param string[] $cC
     * @param string $subject
     * @param \AisFssp\StructType\EMailHeaderType[] $header
     * @param string $text
     * @param \AisFssp\StructType\AttachmentType[] $attachment
     */
    public function __construct(array $recipient = array(), $internalKey = null, $messageId = null, $sender = null, array $cC = array(), $subject = null, array $header = array(), $text = null, array $attachment = array())
    {
        $this
            ->setRecipient($recipient)
            ->setInternalKey($internalKey)
            ->setMessageId($messageId)
            ->setSender($sender)
            ->setCC($cC)
            ->setSubject($subject)
            ->setHeader($header)
            ->setText($text)
            ->setAttachment($attachment);
    }
    /**
     * Get Recipient value
     * @return string[]
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @throws \InvalidArgumentException
     * @param string[] $recipient
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function setRecipient(array $recipient = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($recipient) && strlen($recipient) > 100) || (is_array($recipient) && count($recipient) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($recipient) ? strlen($recipient) : count($recipient)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recipient) && strlen($recipient) < 1) || (is_array($recipient) && count($recipient) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($recipient as $incomingEMailMessageRecipientItem) {
            // validation for constraint: itemType
            if (!is_string($incomingEMailMessageRecipientItem)) {
                throw new \InvalidArgumentException(sprintf('The Recipient property can only contain items of string, "%s" given', is_object($incomingEMailMessageRecipientItem) ? get_class($incomingEMailMessageRecipientItem) : gettype($incomingEMailMessageRecipientItem)), __LINE__);
            }
        }
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Add item to Recipient value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function addToRecipient($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 100) || (is_array($item) && count($item) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Recipient property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Recipient[] = $item;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get MessageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param string $messageId
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageId) && strlen($messageId) > 255) || (is_array($messageId) && count($messageId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($messageId) ? strlen($messageId) : count($messageId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageId) && strlen($messageId) < 1) || (is_array($messageId) && count($messageId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageId)), __LINE__);
        }
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get Sender value
     * @return string|null
     */
    public function getSender()
    {
        return $this->Sender;
    }
    /**
     * Set Sender value
     * @param string $sender
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function setSender($sender = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sender) && strlen($sender) > 100) || (is_array($sender) && count($sender) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($sender) ? strlen($sender) : count($sender)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sender) && strlen($sender) < 1) || (is_array($sender) && count($sender) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sender)), __LINE__);
        }
        $this->Sender = $sender;
        return $this;
    }
    /**
     * Get CC value
     * @return string[]|null
     */
    public function getCC()
    {
        return $this->CC;
    }
    /**
     * Set CC value
     * @throws \InvalidArgumentException
     * @param string[] $cC
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function setCC(array $cC = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($cC) && strlen($cC) > 100) || (is_array($cC) && count($cC) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($cC) ? strlen($cC) : count($cC)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cC) && strlen($cC) < 1) || (is_array($cC) && count($cC) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($cC as $incomingEMailMessageCCItem) {
            // validation for constraint: itemType
            if (!is_string($incomingEMailMessageCCItem)) {
                throw new \InvalidArgumentException(sprintf('The CC property can only contain items of string, "%s" given', is_object($incomingEMailMessageCCItem) ? get_class($incomingEMailMessageCCItem) : gettype($incomingEMailMessageCCItem)), __LINE__);
            }
        }
        $this->CC = $cC;
        return $this;
    }
    /**
     * Add item to CC value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function addToCC($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 100) || (is_array($item) && count($item) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CC property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CC[] = $item;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subject) && strlen($subject) > 1000) || (is_array($subject) && count($subject) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($subject) ? strlen($subject) : count($subject)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($subject) && strlen($subject) < 1) || (is_array($subject) && count($subject) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Header value
     * @return \AisFssp\StructType\EMailHeaderType[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EMailHeaderType[] $header
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function setHeader(array $header = array())
    {
        foreach ($header as $incomingEMailMessageHeaderItem) {
            // validation for constraint: itemType
            if (!$incomingEMailMessageHeaderItem instanceof \AisFssp\StructType\EMailHeaderType) {
                throw new \InvalidArgumentException(sprintf('The Header property can only contain items of \AisFssp\StructType\EMailHeaderType, "%s" given', is_object($incomingEMailMessageHeaderItem) ? get_class($incomingEMailMessageHeaderItem) : gettype($incomingEMailMessageHeaderItem)), __LINE__);
            }
        }
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EMailHeaderType $item
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function addToHeader(\AisFssp\StructType\EMailHeaderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\EMailHeaderType) {
            throw new \InvalidArgumentException(sprintf('The Header property can only contain items of \AisFssp\StructType\EMailHeaderType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachment
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $incomingEMailMessageAttachmentItem) {
            // validation for constraint: itemType
            if (!$incomingEMailMessageAttachmentItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($incomingEMailMessageAttachmentItem) ? get_class($incomingEMailMessageAttachmentItem) : gettype($incomingEMailMessageAttachmentItem)), __LINE__);
            }
        }
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public function addToAttachment(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IncomingEMailMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
