<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentificationDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений IdentificationDataType "Удостоверение личности" | Используется для передачи информации о документах физического лица
 * @subpackage Structs
 */
class IdentificationDataType extends InformationType
{
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - documentation: Код типа документа | Код типа документа из справочника документов, удостоверяющих личность | Код типа документа,
     * удостоверяющего личность
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $TypeDoc;
    /**
     * The NameDoc
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа документа | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $NameDoc;
    /**
     * The SerDoc
     * Meta informations extracted from the WSDL
     * - documentation: Серия документа | Серия документа, удостоверяющего личность. В случае невозможности разделить серию и номер документа, серия
     * документа хранится вместе с номером в поле "Номер документа" | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SerDoc;
    /**
     * The NumDoc
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа, удостоверяющего личность | Строка длиной от 1 до 25 символов
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NumDoc;
    /**
     * The IssuedDoc
     * Meta informations extracted from the WSDL
     * - documentation: Наименование подразделения | Наименование подразделения, выдавшего документ | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IssuedDoc;
    /**
     * The DateDoc
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDoc;
    /**
     * The CodeDep
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 7 символов
     * - minOccurs: 0
     * - maxLength: 7
     * - minLength: 1
     * @var string
     */
    public $CodeDep;
    /**
     * The FIODoc
     * Meta informations extracted from the WSDL
     * - documentation: ФИО | Фамилия, имя, отчество по документу. Используется только для обмена с организациями, поддерживающими передачу этих данных
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $FIODoc;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $birthDate;
    /**
     * The birthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $birthPlace;
    /**
     * The isValid
     * Meta informations extracted from the WSDL
     * - documentation: Признак действующего документа | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $isValid;
    /**
     * The invalidateReasonCode
     * Meta informations extracted from the WSDL
     * - documentation: Код причины недействительности | Код причины недействительности документа
     * - minOccurs: 0
     * - length: 1
     * @var string
     */
    public $invalidateReasonCode;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН | ИНН Физического лица
     * - minOccurs: 0
     * - length: 12
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10}
     * @var string
     */
    public $INN;
    /**
     * The gender
     * Meta informations extracted from the WSDL
     * - documentation: Пол
     * - minOccurs: 0
     * @var string
     */
    public $gender;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Код страны | Код страны буквенный | Трехзначный (альфа-3) буквенный код страны мира по классификатору ОКСМ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $countryCode;
    /**
     * The StrAddr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес | Адрес по документу. Используется только для обмена с организациями, поддерживающими передачу этих данных | Строка
     * длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $StrAddr;
    /**
     * Constructor method for IdentificationDataType
     * @uses IdentificationDataType::setTypeDoc()
     * @uses IdentificationDataType::setNameDoc()
     * @uses IdentificationDataType::setSerDoc()
     * @uses IdentificationDataType::setNumDoc()
     * @uses IdentificationDataType::setIssuedDoc()
     * @uses IdentificationDataType::setDateDoc()
     * @uses IdentificationDataType::setCodeDep()
     * @uses IdentificationDataType::setFIODoc()
     * @uses IdentificationDataType::setBirthDate()
     * @uses IdentificationDataType::setBirthPlace()
     * @uses IdentificationDataType::setIsValid()
     * @uses IdentificationDataType::setInvalidateReasonCode()
     * @uses IdentificationDataType::setINN()
     * @uses IdentificationDataType::setGender()
     * @uses IdentificationDataType::setCountryCode()
     * @uses IdentificationDataType::setStrAddr()
     * @param string $typeDoc
     * @param string $nameDoc
     * @param string $serDoc
     * @param string $numDoc
     * @param string $issuedDoc
     * @param string $dateDoc
     * @param string $codeDep
     * @param \AisFssp\StructType\FioType $fIODoc
     * @param string $birthDate
     * @param string $birthPlace
     * @param bool $isValid
     * @param string $invalidateReasonCode
     * @param string $iNN
     * @param string $gender
     * @param string $countryCode
     * @param string $strAddr
     */
    public function __construct($typeDoc = null, $nameDoc = null, $serDoc = null, $numDoc = null, $issuedDoc = null, $dateDoc = null, $codeDep = null, \AisFssp\StructType\FioType $fIODoc = null, $birthDate = null, $birthPlace = null, $isValid = null, $invalidateReasonCode = null, $iNN = null, $gender = null, $countryCode = null, $strAddr = null)
    {
        $this
            ->setTypeDoc($typeDoc)
            ->setNameDoc($nameDoc)
            ->setSerDoc($serDoc)
            ->setNumDoc($numDoc)
            ->setIssuedDoc($issuedDoc)
            ->setDateDoc($dateDoc)
            ->setCodeDep($codeDep)
            ->setFIODoc($fIODoc)
            ->setBirthDate($birthDate)
            ->setBirthPlace($birthPlace)
            ->setIsValid($isValid)
            ->setInvalidateReasonCode($invalidateReasonCode)
            ->setINN($iNN)
            ->setGender($gender)
            ->setCountryCode($countryCode)
            ->setStrAddr($strAddr);
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @param string $typeDoc
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setTypeDoc($typeDoc = null)
    {
        // validation for constraint: length
        if ((is_scalar($typeDoc) && strlen($typeDoc) !== 2) || (is_array($typeDoc) && count($typeDoc) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($typeDoc) && !preg_match('/[0-9]{2}/', $typeDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{2}", "%s" given', var_export($typeDoc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($typeDoc) && !is_string($typeDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeDoc)), __LINE__);
        }
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get NameDoc value
     * @return string|null
     */
    public function getNameDoc()
    {
        return $this->NameDoc;
    }
    /**
     * Set NameDoc value
     * @param string $nameDoc
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setNameDoc($nameDoc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nameDoc) && strlen($nameDoc) > 255) || (is_array($nameDoc) && count($nameDoc) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($nameDoc) ? strlen($nameDoc) : count($nameDoc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($nameDoc) && strlen($nameDoc) < 1) || (is_array($nameDoc) && count($nameDoc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nameDoc) && !is_string($nameDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameDoc)), __LINE__);
        }
        $this->NameDoc = $nameDoc;
        return $this;
    }
    /**
     * Get SerDoc value
     * @return string|null
     */
    public function getSerDoc()
    {
        return $this->SerDoc;
    }
    /**
     * Set SerDoc value
     * @param string $serDoc
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setSerDoc($serDoc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serDoc) && strlen($serDoc) > 25) || (is_array($serDoc) && count($serDoc) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($serDoc) ? strlen($serDoc) : count($serDoc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($serDoc) && strlen($serDoc) < 1) || (is_array($serDoc) && count($serDoc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serDoc) && !is_string($serDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serDoc)), __LINE__);
        }
        $this->SerDoc = $serDoc;
        return $this;
    }
    /**
     * Get NumDoc value
     * @return string|null
     */
    public function getNumDoc()
    {
        return $this->NumDoc;
    }
    /**
     * Set NumDoc value
     * @param string $numDoc
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setNumDoc($numDoc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numDoc) && strlen($numDoc) > 25) || (is_array($numDoc) && count($numDoc) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($numDoc) ? strlen($numDoc) : count($numDoc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numDoc) && strlen($numDoc) < 1) || (is_array($numDoc) && count($numDoc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numDoc) && !is_string($numDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numDoc)), __LINE__);
        }
        $this->NumDoc = $numDoc;
        return $this;
    }
    /**
     * Get IssuedDoc value
     * @return string|null
     */
    public function getIssuedDoc()
    {
        return $this->IssuedDoc;
    }
    /**
     * Set IssuedDoc value
     * @param string $issuedDoc
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setIssuedDoc($issuedDoc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issuedDoc) && strlen($issuedDoc) > 300) || (is_array($issuedDoc) && count($issuedDoc) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($issuedDoc) ? strlen($issuedDoc) : count($issuedDoc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($issuedDoc) && strlen($issuedDoc) < 1) || (is_array($issuedDoc) && count($issuedDoc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issuedDoc) && !is_string($issuedDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuedDoc)), __LINE__);
        }
        $this->IssuedDoc = $issuedDoc;
        return $this;
    }
    /**
     * Get DateDoc value
     * @return string|null
     */
    public function getDateDoc()
    {
        return $this->DateDoc;
    }
    /**
     * Set DateDoc value
     * @param string $dateDoc
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setDateDoc($dateDoc = null)
    {
        // validation for constraint: maxExclusive
        if ($dateDoc >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateDoc), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateDoc < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateDoc), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDoc) && !is_string($dateDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDoc)), __LINE__);
        }
        $this->DateDoc = $dateDoc;
        return $this;
    }
    /**
     * Get CodeDep value
     * @return string|null
     */
    public function getCodeDep()
    {
        return $this->CodeDep;
    }
    /**
     * Set CodeDep value
     * @param string $codeDep
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setCodeDep($codeDep = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codeDep) && strlen($codeDep) > 7) || (is_array($codeDep) && count($codeDep) > 7)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 7 element(s) or a scalar of 7 character(s) at most, "%d" length given', is_scalar($codeDep) ? strlen($codeDep) : count($codeDep)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($codeDep) && strlen($codeDep) < 1) || (is_array($codeDep) && count($codeDep) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codeDep) && !is_string($codeDep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeDep)), __LINE__);
        }
        $this->CodeDep = $codeDep;
        return $this;
    }
    /**
     * Get FIODoc value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getFIODoc()
    {
        return $this->FIODoc;
    }
    /**
     * Set FIODoc value
     * @param \AisFssp\StructType\FioType $fIODoc
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setFIODoc(\AisFssp\StructType\FioType $fIODoc = null)
    {
        $this->FIODoc = $fIODoc;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($birthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get birthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->birthPlace;
    }
    /**
     * Set birthPlace value
     * @param string $birthPlace
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setBirthPlace($birthPlace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($birthPlace) && strlen($birthPlace) > 300) || (is_array($birthPlace) && count($birthPlace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($birthPlace) ? strlen($birthPlace) : count($birthPlace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($birthPlace) && strlen($birthPlace) < 1) || (is_array($birthPlace) && count($birthPlace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthPlace) && !is_string($birthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthPlace)), __LINE__);
        }
        $this->birthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get isValid value
     * @return bool|null
     */
    public function getIsValid()
    {
        return $this->isValid;
    }
    /**
     * Set isValid value
     * @param bool $isValid
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isValid)), __LINE__);
        }
        $this->isValid = $isValid;
        return $this;
    }
    /**
     * Get invalidateReasonCode value
     * @return string|null
     */
    public function getInvalidateReasonCode()
    {
        return $this->invalidateReasonCode;
    }
    /**
     * Set invalidateReasonCode value
     * @param string $invalidateReasonCode
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setInvalidateReasonCode($invalidateReasonCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($invalidateReasonCode) && strlen($invalidateReasonCode) !== 1) || (is_array($invalidateReasonCode) && count($invalidateReasonCode) !== 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invalidateReasonCode) && !is_string($invalidateReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invalidateReasonCode)), __LINE__);
        }
        $this->invalidateReasonCode = $invalidateReasonCode;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: length
        if ((is_scalar($iNN) && strlen($iNN) !== 12) || (is_array($iNN) && count($iNN) !== 12)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iNN) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10}/', $iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10}", "%s" given', var_export($iNN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }
    /**
     * Set gender value
     * @uses \AisFssp\EnumType\GenderCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\GenderCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\GenderCodeType::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gender, implode(', ', \AisFssp\EnumType\GenderCodeType::getValidValues())), __LINE__);
        }
        $this->gender = $gender;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($countryCode) && strlen($countryCode) !== 3) || (is_array($countryCode) && count($countryCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get StrAddr value
     * @return string|null
     */
    public function getStrAddr()
    {
        return $this->StrAddr;
    }
    /**
     * Set StrAddr value
     * @param string $strAddr
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public function setStrAddr($strAddr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($strAddr) && strlen($strAddr) > 300) || (is_array($strAddr) && count($strAddr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($strAddr) ? strlen($strAddr) : count($strAddr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($strAddr) && strlen($strAddr) < 1) || (is_array($strAddr) && count($strAddr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($strAddr) && !is_string($strAddr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($strAddr)), __LINE__);
        }
        $this->StrAddr = $strAddr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IdentificationDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
