<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных IPSideRequestType «Регистрация запроса стороны ИП в ОСП (абстрактный)»
 * @subpackage Structs
 */
abstract class IPSideRequestType extends AbstractStructBase
{
    /**
     * The reqeustKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса ЕПГУ | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $reqeustKey;
    /**
     * The sideType
     * Meta informations extracted from the WSDL
     * - documentation: Тип стороны ИП
     * - minOccurs: 0
     * @var string
     */
    public $sideType;
    /**
     * The side
     * Meta informations extracted from the WSDL
     * - documentation: Сторона ИП
     * @var \AisFssp\StructType\ContragentDatumType
     */
    public $side;
    /**
     * The representative
     * Meta informations extracted from the WSDL
     * - documentation: Представитель | Заполняется в том случае, если пользователь портала госуслуг представляет сторону ИП
     * - minOccurs: 0
     * @var \AisFssp\StructType\ContragentDatumType
     */
    public $representative;
    /**
     * The debtor
     * Meta informations extracted from the WSDL
     * - documentation: Должник
     * @var \AisFssp\StructType\ContragentDatumType
     */
    public $debtor;
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела судебных приставов | Код ОСП, в адрес которого направляется заявление | Ведомственный классификатор отделов
     * судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The requestDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $requestDate;
    /**
     * The EApplication
     * Meta informations extracted from the WSDL
     * - documentation: Электронное обращение
     * - minOccurs: 0
     * @var \AisFssp\StructType\EmbeddedDocumentType
     */
    public $EApplication;
    /**
     * Constructor method for IPSideRequestType
     * @uses IPSideRequestType::setReqeustKey()
     * @uses IPSideRequestType::setSideType()
     * @uses IPSideRequestType::setSide()
     * @uses IPSideRequestType::setRepresentative()
     * @uses IPSideRequestType::setDebtor()
     * @uses IPSideRequestType::setOspCode()
     * @uses IPSideRequestType::setRequestDate()
     * @uses IPSideRequestType::setEApplication()
     * @param string $reqeustKey
     * @param string $sideType
     * @param \AisFssp\StructType\ContragentDatumType $side
     * @param \AisFssp\StructType\ContragentDatumType $representative
     * @param \AisFssp\StructType\ContragentDatumType $debtor
     * @param string $ospCode
     * @param string $requestDate
     * @param \AisFssp\StructType\EmbeddedDocumentType $eApplication
     */
    public function __construct($reqeustKey = null, $sideType = null, \AisFssp\StructType\ContragentDatumType $side = null, \AisFssp\StructType\ContragentDatumType $representative = null, \AisFssp\StructType\ContragentDatumType $debtor = null, $ospCode = null, $requestDate = null, \AisFssp\StructType\EmbeddedDocumentType $eApplication = null)
    {
        $this
            ->setReqeustKey($reqeustKey)
            ->setSideType($sideType)
            ->setSide($side)
            ->setRepresentative($representative)
            ->setDebtor($debtor)
            ->setOspCode($ospCode)
            ->setRequestDate($requestDate)
            ->setEApplication($eApplication);
    }
    /**
     * Get reqeustKey value
     * @return string|null
     */
    public function getReqeustKey()
    {
        return $this->reqeustKey;
    }
    /**
     * Set reqeustKey value
     * @param string $reqeustKey
     * @return \AisFssp\StructType\IPSideRequestType
     */
    public function setReqeustKey($reqeustKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reqeustKey) && strlen($reqeustKey) > 60) || (is_array($reqeustKey) && count($reqeustKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($reqeustKey) ? strlen($reqeustKey) : count($reqeustKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reqeustKey) && strlen($reqeustKey) < 1) || (is_array($reqeustKey) && count($reqeustKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reqeustKey) && !is_string($reqeustKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqeustKey)), __LINE__);
        }
        $this->reqeustKey = $reqeustKey;
        return $this;
    }
    /**
     * Get sideType value
     * @return string|null
     */
    public function getSideType()
    {
        return $this->sideType;
    }
    /**
     * Set sideType value
     * @uses \AisFssp\EnumType\IPSideType::valueIsValid()
     * @uses \AisFssp\EnumType\IPSideType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sideType
     * @return \AisFssp\StructType\IPSideRequestType
     */
    public function setSideType($sideType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\IPSideType::valueIsValid($sideType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sideType, implode(', ', \AisFssp\EnumType\IPSideType::getValidValues())), __LINE__);
        }
        $this->sideType = $sideType;
        return $this;
    }
    /**
     * Get side value
     * @return \AisFssp\StructType\ContragentDatumType|null
     */
    public function getSide()
    {
        return $this->side;
    }
    /**
     * Set side value
     * @param \AisFssp\StructType\ContragentDatumType $side
     * @return \AisFssp\StructType\IPSideRequestType
     */
    public function setSide(\AisFssp\StructType\ContragentDatumType $side = null)
    {
        $this->side = $side;
        return $this;
    }
    /**
     * Get representative value
     * @return \AisFssp\StructType\ContragentDatumType|null
     */
    public function getRepresentative()
    {
        return $this->representative;
    }
    /**
     * Set representative value
     * @param \AisFssp\StructType\ContragentDatumType $representative
     * @return \AisFssp\StructType\IPSideRequestType
     */
    public function setRepresentative(\AisFssp\StructType\ContragentDatumType $representative = null)
    {
        $this->representative = $representative;
        return $this;
    }
    /**
     * Get debtor value
     * @return \AisFssp\StructType\ContragentDatumType|null
     */
    public function getDebtor()
    {
        return $this->debtor;
    }
    /**
     * Set debtor value
     * @param \AisFssp\StructType\ContragentDatumType $debtor
     * @return \AisFssp\StructType\IPSideRequestType
     */
    public function setDebtor(\AisFssp\StructType\ContragentDatumType $debtor = null)
    {
        $this->debtor = $debtor;
        return $this;
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\IPSideRequestType
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get requestDate value
     * @return string|null
     */
    public function getRequestDate()
    {
        return $this->requestDate;
    }
    /**
     * Set requestDate value
     * @param string $requestDate
     * @return \AisFssp\StructType\IPSideRequestType
     */
    public function setRequestDate($requestDate = null)
    {
        // validation for constraint: maxExclusive
        if ($requestDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $requestDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($requestDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $requestDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestDate) && !is_string($requestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestDate)), __LINE__);
        }
        $this->requestDate = $requestDate;
        return $this;
    }
    /**
     * Get EApplication value
     * @return \AisFssp\StructType\EmbeddedDocumentType|null
     */
    public function getEApplication()
    {
        return $this->EApplication;
    }
    /**
     * Set EApplication value
     * @param \AisFssp\StructType\EmbeddedDocumentType $eApplication
     * @return \AisFssp\StructType\IPSideRequestType
     */
    public function setEApplication(\AisFssp\StructType\EmbeddedDocumentType $eApplication = null)
    {
        $this->EApplication = $eApplication;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPSideRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
