<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideRequestCourseIPType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ IPSideRequestCourseIPType «Регистрация запроса о ходе ИП по номеру ИП» | ЭП
 * @subpackage Structs
 */
class IPSideRequestCourseIPType extends IPSideRequestType
{
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер исполнительного производства | Строка длиной от 1 до 25 символов
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumber;
    /**
     * The IsInteractive
     * Meta informations extracted from the WSDL
     * - documentation: Признак интерактивного запроса | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsInteractive;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPSideRequestCourseIPType
     * @uses IPSideRequestCourseIPType::setIPNumber()
     * @uses IPSideRequestCourseIPType::setIsInteractive()
     * @uses IPSideRequestCourseIPType::setSignature()
     * @uses IPSideRequestCourseIPType::setId()
     * @param string $iPNumber
     * @param bool $isInteractive
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($iPNumber = null, $isInteractive = null, array $signature = array(), $id = null)
    {
        $this
            ->setIPNumber($iPNumber)
            ->setIsInteractive($isInteractive)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get IPNumber value
     * @return string|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @param string $iPNumber
     * @return \AisFssp\StructType\IPSideRequestCourseIPType
     */
    public function setIPNumber($iPNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) > 25) || (is_array($iPNumber) && count($iPNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNumber) ? strlen($iPNumber) : count($iPNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) < 1) || (is_array($iPNumber) && count($iPNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNumber) && !is_string($iPNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNumber)), __LINE__);
        }
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Get IsInteractive value
     * @return bool|null
     */
    public function getIsInteractive()
    {
        return $this->IsInteractive;
    }
    /**
     * Set IsInteractive value
     * @param bool $isInteractive
     * @return \AisFssp\StructType\IPSideRequestCourseIPType
     */
    public function setIsInteractive($isInteractive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInteractive) && !is_bool($isInteractive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isInteractive)), __LINE__);
        }
        $this->IsInteractive = $isInteractive;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\IPSideRequestCourseIPType
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $iPSideRequestCourseIPTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$iPSideRequestCourseIPTypeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($iPSideRequestCourseIPTypeSignatureItem) ? get_class($iPSideRequestCourseIPTypeSignatureItem) : gettype($iPSideRequestCourseIPTypeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\IPSideRequestCourseIPType
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\IPSideRequestCourseIPType
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPSideRequestCourseIPType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
