<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPReqAppResultRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ IPReqAppResultRequestType «Запрос на получение ответов на заявления или запросы в ОСП» | ЭП
 * @subpackage Structs
 */
class IPReqAppResultRequestType extends AbstractStructBase
{
    /**
     * The requestKeys
     * Meta informations extracted from the WSDL
     * - documentation: Ключи запросов или заявлений | Ключи запросов, возвращенные веб-сервисом при регистрации запроса или заявления | Ключ объекта,
     * присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxOccurs: unbounded
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int[]
     */
    public $requestKeys;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPReqAppResultRequestType
     * @uses IPReqAppResultRequestType::setRequestKeys()
     * @uses IPReqAppResultRequestType::setSignature()
     * @uses IPReqAppResultRequestType::setId()
     * @param int[] $requestKeys
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct(array $requestKeys = array(), array $signature = array(), $id = null)
    {
        $this
            ->setRequestKeys($requestKeys)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get requestKeys value
     * @return int[]|null
     */
    public function getRequestKeys()
    {
        return $this->requestKeys;
    }
    /**
     * Set requestKeys value
     * @throws \InvalidArgumentException
     * @param int[] $requestKeys
     * @return \AisFssp\StructType\IPReqAppResultRequestType
     */
    public function setRequestKeys(array $requestKeys = array())
    {
        // validation for constraint: maxInclusive
        if ($requestKeys > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $requestKeys), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($requestKeys < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $requestKeys), __LINE__);
        }
        foreach ($requestKeys as $iPReqAppResultRequestTypeRequestKeysItem) {
            // validation for constraint: itemType
            if (!is_numeric($iPReqAppResultRequestTypeRequestKeysItem)) {
                throw new \InvalidArgumentException(sprintf('The requestKeys property can only contain items of integer, "%s" given', is_object($iPReqAppResultRequestTypeRequestKeysItem) ? get_class($iPReqAppResultRequestTypeRequestKeysItem) : gettype($iPReqAppResultRequestTypeRequestKeysItem)), __LINE__);
            }
        }
        $this->requestKeys = $requestKeys;
        return $this;
    }
    /**
     * Add item to requestKeys value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \AisFssp\StructType\IPReqAppResultRequestType
     */
    public function addToRequestKeys($item)
    {
        // validation for constraint: maxInclusive
        if ($item > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $item), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($item < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $item), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The requestKeys property can only contain items of integer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->requestKeys[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\IPReqAppResultRequestType
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $iPReqAppResultRequestTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$iPReqAppResultRequestTypeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($iPReqAppResultRequestTypeSignatureItem) ? get_class($iPReqAppResultRequestTypeSignatureItem) : gettype($iPReqAppResultRequestTypeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\IPReqAppResultRequestType
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\IPReqAppResultRequestType
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPReqAppResultRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
