<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPDataRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос информации о наличии и реквизитах ИП | ЭП
 * - type: tns:IPDataRequest
 * @subpackage Structs
 */
class IPDataRequest extends RequestByDatum
{
    /**
     * The IdSubj
     * Meta informations extracted from the WSDL
     * - documentation: Код предмета исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IdSubj;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for IPDataRequest
     * @uses IPDataRequest::setIdSubj()
     * @uses IPDataRequest::setSignature()
     * @param string $idSubj
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($idSubj = null, array $signature = array())
    {
        $this
            ->setIdSubj($idSubj)
            ->setSignature($signature);
    }
    /**
     * Get IdSubj value
     * @return string|null
     */
    public function getIdSubj()
    {
        return $this->IdSubj;
    }
    /**
     * Set IdSubj value
     * @param string $idSubj
     * @return \AisFssp\StructType\IPDataRequest
     */
    public function setIdSubj($idSubj = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idSubj) && strlen($idSubj) > 8) || (is_array($idSubj) && count($idSubj) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($idSubj) ? strlen($idSubj) : count($idSubj)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($idSubj) && strlen($idSubj) < 1) || (is_array($idSubj) && count($idSubj) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idSubj) && !is_string($idSubj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idSubj)), __LINE__);
        }
        $this->IdSubj = $idSubj;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\IPDataRequest
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $iPDataRequestSignatureItem) {
            // validation for constraint: itemType
            if (!$iPDataRequestSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($iPDataRequestSignatureItem) ? get_class($iPDataRequestSignatureItem) : gettype($iPDataRequestSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\IPDataRequest
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPDataRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
