<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPBriefInfoRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявление о наличии ИП в банке данных (по номеру ИП) | Используется для получения сведений об ИП по номеру ИП. | ЭП
 * @subpackage Structs
 */
class IPBriefInfoRequestType extends AbstractStructBase
{
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса ЕПГУ или АИС внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС,
     * ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | В текущей версии сервиса возможен запрос по одному номеру ИП | Номер документа
     * - maxOccurs: unbounded
     * - maxLength: 25
     * - minLength: 1
     * @var string[]
     */
    public $IPNumber;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPBriefInfoRequestType
     * @uses IPBriefInfoRequestType::setRequestKey()
     * @uses IPBriefInfoRequestType::setIPNumber()
     * @uses IPBriefInfoRequestType::setSignature()
     * @uses IPBriefInfoRequestType::setId()
     * @param string $requestKey
     * @param string[] $iPNumber
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($requestKey = null, array $iPNumber = array(), array $signature = array(), $id = null)
    {
        $this
            ->setRequestKey($requestKey)
            ->setIPNumber($iPNumber)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \AisFssp\StructType\IPBriefInfoRequestType
     */
    public function setRequestKey($requestKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestKey) && strlen($requestKey) > 60) || (is_array($requestKey) && count($requestKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestKey) ? strlen($requestKey) : count($requestKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestKey) && strlen($requestKey) < 1) || (is_array($requestKey) && count($requestKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestKey) && !is_string($requestKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestKey)), __LINE__);
        }
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get IPNumber value
     * @return string[]|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @throws \InvalidArgumentException
     * @param string[] $iPNumber
     * @return \AisFssp\StructType\IPBriefInfoRequestType
     */
    public function setIPNumber(array $iPNumber = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) > 25) || (is_array($iPNumber) && count($iPNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNumber) ? strlen($iPNumber) : count($iPNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) < 1) || (is_array($iPNumber) && count($iPNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($iPNumber as $iPBriefInfoRequestTypeIPNumberItem) {
            // validation for constraint: itemType
            if (!is_string($iPBriefInfoRequestTypeIPNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The IPNumber property can only contain items of string, "%s" given', is_object($iPBriefInfoRequestTypeIPNumberItem) ? get_class($iPBriefInfoRequestTypeIPNumberItem) : gettype($iPBriefInfoRequestTypeIPNumberItem)), __LINE__);
            }
        }
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Add item to IPNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \AisFssp\StructType\IPBriefInfoRequestType
     */
    public function addToIPNumber($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 25) || (is_array($item) && count($item) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The IPNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPNumber[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\IPBriefInfoRequestType
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $iPBriefInfoRequestTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$iPBriefInfoRequestTypeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($iPBriefInfoRequestTypeSignatureItem) ? get_class($iPBriefInfoRequestTypeSignatureItem) : gettype($iPBriefInfoRequestTypeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\IPBriefInfoRequestType
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\IPBriefInfoRequestType
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPBriefInfoRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
